/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.HeterogeneousRegionCountCostFunction;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancerHeterogeneousCostRules
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerHeterogeneousCostRules.class);
    @Rule
    public TestName name = new TestName();
    static final String DEFAULT_RULES_FILE_NAME = "hbase-balancer.rules";
    private HeterogeneousRegionCountCostFunction costFunction;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private String rulesFilename;

    @BeforeClass
    public static void beforeClass() throws IOException {
        HTU.getTestFileSystem().mkdirs(HTU.getDataTestDir());
    }

    @Before
    public void before() throws IOException {
        this.rulesFilename = HTU.getDataTestDir(this.name.getMethodName() + "." + DEFAULT_RULES_FILE_NAME).toString();
        HTU.getConfiguration().set("hbase.master.balancer.heterogeneousRegionCountRulesFile", this.rulesFilename);
    }

    static String createRulesFile(String file, List<String> lines) throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup(file);
        java.nio.file.Path path = Files.createFile(FileSystems.getDefault().getPath(file, new String[0]), new FileAttribute[0]);
        return Files.write(path, lines, Charset.forName("UTF-8"), new OpenOption[0]).toString();
    }

    static String createRulesFile(String file) throws IOException {
        return TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(file, Collections.emptyList());
    }

    private static void cleanup(String file) throws IOException {
        try {
            Files.delete(FileSystems.getDefault().getPath(file, new String[0]));
        }
        catch (NoSuchFileException nsfe) {
            System.out.println("FileNotFoundException for " + file);
        }
    }

    @Test
    public void testNoRules() throws IOException {
        HTU.getConfiguration().set("hbase.master.balancer.heterogeneousRegionCountRulesFile", "non-existent-file!");
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testBadFormatInRules() throws IOException {
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(this.rulesFilename, Collections.singletonList("bad rules format"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(this.rulesFilename, Arrays.asList("srv[1-2] 10", "bad_rules format", "a"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)1L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testTwoRules() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(this.rulesFilename, Arrays.asList("^server1$ 10", "^server2 21"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testBadRegexp() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(this.rulesFilename, Collections.singletonList("server[ 1"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testNoOverride() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(this.rulesFilename, Arrays.asList("^server1$ 10", "^server2 21"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(HTU.getConfiguration());
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup(this.rulesFilename);
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadingFomHDFS() throws Exception {
        HTU.startMiniDFSCluster(3);
        try {
            MiniDFSCluster cluster = HTU.getDFSCluster();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path path = new Path(fs.getHomeDirectory(), DEFAULT_RULES_FILE_NAME);
            FSDataOutputStream stream = fs.create(path);
            stream.write("server1 10".getBytes());
            stream.flush();
            stream.close();
            Configuration configuration = HTU.getConfiguration();
            configuration.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", path.toString());
            this.costFunction = new HeterogeneousRegionCountCostFunction(configuration);
            this.costFunction.loadRules();
            Assert.assertEquals((long)1L, (long)this.costFunction.getNumberOfRulesLoaded());
        }
        finally {
            HTU.shutdownMiniCluster();
        }
    }
}

