/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class CellSortReducer
extends Reducer<ImmutableBytesWritable, Cell, ImmutableBytesWritable, Cell> {
    protected void reduce(ImmutableBytesWritable row, Iterable<Cell> kvs, Reducer.Context context) throws IOException, InterruptedException {
        TreeSet<Cell> map = new TreeSet<Cell>((Comparator<Cell>)CellComparator.getInstance());
        for (Cell kv : kvs) {
            try {
                map.add(PrivateCellUtil.deepClone((Cell)kv));
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
        }
        context.setStatus("Read " + map.getClass());
        int index = 0;
        for (Cell kv : map) {
            context.write((Object)row, (Object)new MapReduceExtendedCell(kv));
            if (++index % 100 != 0) continue;
            context.setStatus("Wrote " + index);
        }
    }
}

