/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import io.netty.channel.unix.Errors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Streaming$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.Worker$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.GroupMappingServiceProvider;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.status.api.v1.StackTrace;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.CallSite$;
import org.apache.spark.util.Iterators$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.SignalUtils$;
import org.apache.spark.util.SparkUncaughtExceptionHandler;
import org.apache.spark.util.SparkUncaughtExceptionHandler$;
import org.apache.spark.util.Utils;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.collect.Interner;
import org.sparkproject.guava.collect.Interners;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Files;
import org.sparkproject.guava.net.InetAddresses;
import org.sparkproject.jetty.util.MultiException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private InetAddress localIpAddress;
    private boolean isG1GC;
    private final Random random;
    private final SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler;
    private volatile String cachedLocalDir;
    private final int DEFAULT_DRIVER_MEM_MB;
    private final int MAX_DIR_CREATION_ATTEMPTS;
    private volatile String[] localRootDirs;
    private final String LOCAL_SCHEME;
    private final Interner<String> weakStringInterner;
    private final Regex PATTERN_FOR_COMMAND_LINE_ARG;
    private final int COPY_BUFFER_LEN;
    private final ThreadLocal<byte[]> copyBuffer;
    private Option<String> customHostname;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private final Regex SPARK_CORE_CLASS_REGEX;
    private final Regex SPARK_SQL_CLASS_REGEX;
    private LoadingCache<String, Long> compressedLogFileLengthCache;
    private final boolean isWindows;
    private final boolean isMac;
    private final boolean isMacOnAppleSilicon;
    private final boolean preferIPv6;
    private final Regex windowsDrive;
    private final Set<String> EMPTY_USER_GROUPS;
    private final String BACKUP_STANDALONE_MASTER_PREFIX;
    private final String REDACTION_REPLACEMENT_TEXT;
    private final Regex fullWidthRegex;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new Utils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Random random() {
        return this.random;
    }

    private SparkUncaughtExceptionHandler sparkUncaughtExceptionHandler() {
        return this.sparkUncaughtExceptionHandler;
    }

    private String cachedLocalDir() {
        return this.cachedLocalDir;
    }

    private void cachedLocalDir_$eq(String x$1) {
        this.cachedLocalDir = x$1;
    }

    public int DEFAULT_DRIVER_MEM_MB() {
        return this.DEFAULT_DRIVER_MEM_MB;
    }

    public int MAX_DIR_CREATION_ATTEMPTS() {
        return this.MAX_DIR_CREATION_ATTEMPTS;
    }

    private String[] localRootDirs() {
        return this.localRootDirs;
    }

    private void localRootDirs_$eq(String[] x$1) {
        this.localRootDirs = x$1;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    private Interner<String> weakStringInterner() {
        return this.weakStringInterner;
    }

    private Regex PATTERN_FOR_COMMAND_LINE_ARG() {
        return this.PATTERN_FOR_COMMAND_LINE_ARG;
    }

    private int COPY_BUFFER_LEN() {
        return this.COPY_BUFFER_LEN;
    }

    private ThreadLocal<byte[]> copyBuffer() {
        return this.copyBuffer;
    }

    public <T> byte[] serialize(T o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        return bos.toByteArray();
    }

    public <T> T deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return (T)ois.readObject();
    }

    public <T> T deserialize(byte[] bytes, ClassLoader loader) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis, loader){
            private final ClassLoader loader$1;

            public Class<?> resolveClass(ObjectStreamClass desc) {
                return Class.forName(desc.getName(), false, this.loader$1);
            }
            {
                this.loader$1 = loader$1;
                super(bis$1);
            }
        };
        return (T)ois.readObject();
    }

    public long deserializeLongValue(byte[] bytes) {
        long result = (long)bytes[7] & 0xFFL;
        result += ((long)bytes[6] & 0xFFL) << 8;
        result += ((long)bytes[5] & 0xFFL) << 16;
        result += ((long)bytes[4] & 0xFFL) << 24;
        result += ((long)bytes[3] & 0xFFL) << 32;
        result += ((long)bytes[2] & 0xFFL) << 40;
        return (result += ((long)bytes[1] & 0xFFL) << 48) + (((long)bytes[0] & 0xFFL) << 56);
    }

    public void serializeViaNestedStream(OutputStream os, SerializerInstance ser, Function1<SerializationStream, BoxedUnit> f) {
        try (SerializationStream osWrapper = ser.serializeStream(new OutputStream(os){
            private final OutputStream os$1;

            public void write(int b) {
                this.os$1.write(b);
            }

            public void write(byte[] b, int off, int len) {
                this.os$1.write(b, off, len);
            }
            {
                this.os$1 = os$1;
            }
        });){
            f.apply((Object)osWrapper);
        }
    }

    public void deserializeViaNestedStream(InputStream is, SerializerInstance ser, Function1<DeserializationStream, BoxedUnit> f) {
        try (DeserializationStream isWrapper = ser.deserializeStream(new InputStream(is){
            private final InputStream is$1;

            public int read() {
                return this.is$1.read();
            }

            public int read(byte[] b, int off, int len) {
                return this.is$1.read(b, off, len);
            }
            {
                this.is$1 = is$1;
            }
        });){
            f.apply((Object)isWrapper);
        }
    }

    public String weakIntern(String s) {
        return (String)this.weakStringInterner().intern((Object)s);
    }

    public ClassLoader getSparkClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrSparkClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getSparkClassLoader());
    }

    public boolean classIsLoadable(String clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.classForName(clazz, false, MODULE$.classForName$default$3())).isSuccess();
    }

    public <C> Class<C> classForName(String className, boolean initialize, boolean noSparkClassLoader) {
        if (!noSparkClassLoader) {
            return Class.forName(className, initialize, this.getContextOrSparkClassLoader());
        }
        return Class.forName(className, initialize, Thread.currentThread().getContextClassLoader());
    }

    public <C> boolean classForName$default$2() {
        return true;
    }

    public <C> boolean classForName$default$3() {
        return false;
    }

    public <T> T withContextClassLoader(ClassLoader ctxClassLoader, Function0<T> fn) {
        Object object;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            object = fn.apply();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return (T)object;
    }

    private void writeByteBufferImpl(ByteBuffer bb, Function3<byte[], Object, Object, BoxedUnit> writer) {
        if (bb.hasArray()) {
            writer.apply((Object)bb.array(), (Object)BoxesRunTime.boxToInteger((int)(bb.arrayOffset() + bb.position())), (Object)BoxesRunTime.boxToInteger((int)bb.remaining()));
            return;
        }
        byte[] buffer = this.copyBuffer().get();
        int originalPosition = bb.position();
        int bytesToCopy = Math.min(bb.remaining(), this.COPY_BUFFER_LEN());
        while (bytesToCopy > 0) {
            bb.get(buffer, 0, bytesToCopy);
            writer.apply((Object)buffer, (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)bytesToCopy));
            bytesToCopy = Math.min(bb.remaining(), this.COPY_BUFFER_LEN());
        }
        bb.position(originalPosition);
    }

    public void writeByteBuffer(ByteBuffer bb, DataOutput out) {
        this.writeByteBufferImpl(bb, (Function3<byte[], Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> {
            out.write(x$1, BoxesRunTime.unboxToInt((Object)x$2), BoxesRunTime.unboxToInt((Object)x$3));
            return BoxedUnit.UNIT;
        });
    }

    public void writeByteBuffer(ByteBuffer bb, OutputStream out) {
        this.writeByteBufferImpl(bb, (Function3<byte[], Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x$1, x$2, x$3) -> {
            out.write(x$1, BoxesRunTime.unboxToInt((Object)x$2), BoxesRunTime.unboxToInt((Object)x$3));
            return BoxedUnit.UNIT;
        });
    }

    public boolean chmod700(File file) {
        return file.setReadable(false, false) && file.setReadable(true, true) && file.setWritable(false, false) && file.setWritable(true, true) && file.setExecutable(false, false) && file.setExecutable(true, true);
    }

    public boolean createDirectory(File dir) {
        boolean bl;
        try {
            java.nio.file.Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            if (!dir.exists() || !dir.isDirectory()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Failed to create directory ").append(dir).toString());
            }
            bl = dir.isDirectory();
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Failed to create directory ").append(dir).toString(), e);
            bl = false;
        }
        return bl;
    }

    public File createDirectory(String root, String namePrefix) {
        return JavaUtils.createDirectory((String)root, (String)namePrefix);
    }

    public String createDirectory$default$2() {
        return "spark";
    }

    public File createTempDir() {
        return this.createTempDir(System.getProperty("java.io.tmpdir"), "spark");
    }

    public File createTempDir(String root, String namePrefix) {
        File dir = this.createDirectory(root, namePrefix);
        ShutdownHookManager$.MODULE$.registerShutdownDeleteDir(dir);
        return dir;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "spark";
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return BoxesRunTime.unboxToLong(this.tryWithSafeFinally((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)in, (Object)out);
            if (tuple2 != null) {
                InputStream input = (InputStream)tuple2._1();
                OutputStream output = (OutputStream)tuple2._2();
                if (input instanceof FileInputStream) {
                    FileInputStream fileInputStream = (FileInputStream)input;
                    if (output instanceof FileOutputStream) {
                        FileOutputStream fileOutputStream = (FileOutputStream)output;
                        if (transferToEnabled) {
                            FileChannel inChannel = fileInputStream.getChannel();
                            FileChannel outChannel = fileOutputStream.getChannel();
                            long size = inChannel.size();
                            MODULE$.copyFileStreamNIO(inChannel, outChannel, 0L, size);
                            return size;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                InputStream input = (InputStream)tuple2._1();
                OutputStream output = (OutputStream)tuple2._2();
                long count = 0L;
                byte[] buf = new byte[8192];
                int n = 0;
                while (n != -1) {
                    n = input.read(buf);
                    if (n == -1) continue;
                    output.write(buf, 0, n);
                    count += (long)n;
                }
                return count;
            }
            throw new MatchError((Object)tuple2);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (closeStreams) {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
                return;
            }
        }));
    }

    public boolean copyStream$default$3() {
        return false;
    }

    public boolean copyStream$default$4() {
        return false;
    }

    public InputStream copyStreamUpTo(InputStream in, long maxSize) {
        ChunkedByteBufferOutputStream out;
        LongRef count = LongRef.create((long)0L);
        boolean fullyCopied = BoxesRunTime.unboxToBoolean(this.tryWithSafeFinally((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Utils$.$anonfun$copyStreamUpTo$2(maxSize, count, in, out = new ChunkedByteBufferOutputStream(65536, (Function1<Object, ByteBuffer>)(Function1 & Serializable & scala.Serializable)x$1 -> Utils$.$anonfun$copyStreamUpTo$1(BoxesRunTime.unboxToInt((Object)x$1))))), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                if (count$1.elem < maxSize) {
                    in.close();
                }
            }
            finally {
                out.close();
            }
        }));
        if (fullyCopied) {
            return out.toChunkedByteBuffer().toInputStream(true);
        }
        return new SequenceInputStream(out.toChunkedByteBuffer().toInputStream(true), in);
    }

    public void copyFileStreamNIO(FileChannel input, WritableByteChannel output, long startPosition, long bytesToCopy) {
        None$ none$;
        WritableByteChannel writableByteChannel = output;
        if (writableByteChannel instanceof FileChannel) {
            FileChannel fileChannel = (FileChannel)writableByteChannel;
            none$ = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)fileChannel.position()), (Object)fileChannel));
        } else {
            none$ = None$.MODULE$;
        }
        None$ outputInitialState = none$;
        LongRef count = LongRef.create((long)0L);
        while (count.elem < bytesToCopy) {
            count.elem += input.transferTo(count.elem + startPosition, bytesToCopy - count.elem, output);
        }
        Predef$.MODULE$.assert(count.elem == bytesToCopy, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("request to copy ").append(bytesToCopy).append(" bytes, but actually copied ").append(count$2.elem).append(" bytes.").toString());
        outputInitialState.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Utils$.$anonfun$copyFileStreamNIO$2(bytesToCopy, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new java.lang.StringBuilder(1).append("/").append(fileName).toString(), null, null).getRawPath().substring(1);
    }

    public String decodeFileNameInURI(URI uri) {
        String rawPath = uri.getRawPath();
        String rawFileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawPath.split("/"))).last();
        return new URI(new java.lang.StringBuilder(8).append("file:///").append(rawFileName).toString()).getPath().substring(1);
    }

    public File fetchFile(String url, File targetDir, SparkConf conf, org.apache.hadoop.conf.Configuration hadoopConf, long timestamp, boolean useCache, boolean shouldUntar) {
        Object object;
        File file;
        String fileName = this.decodeFileNameInURI(new URI(url));
        File targetFile = new File(targetDir, fileName);
        boolean fetchCacheEnabled = conf.getBoolean("spark.files.useFetchCache", true);
        if (useCache && fetchCacheEnabled) {
            String cachedFileName = new java.lang.StringBuilder(6).append(url.hashCode()).append(timestamp).append("_cache").toString();
            String lockFileName = new java.lang.StringBuilder(5).append(url.hashCode()).append(timestamp).append("_lock").toString();
            if (this.cachedLocalDir().isEmpty()) {
                Utils$ utils$ = this;
                synchronized (utils$) {
                    if (this.cachedLocalDir().isEmpty()) {
                        this.cachedLocalDir_$eq(this.getLocalDir(conf));
                    }
                }
            }
            File localDir = new File(this.cachedLocalDir());
            File lockFile = new File(localDir, lockFileName);
            FileChannel lockFileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
            FileLock lock = lockFileChannel.lock();
            File cachedFile = new File(localDir, cachedFileName);
            try {
                Object object2 = !cachedFile.exists() ? this.doFetchFile(url, localDir, cachedFileName, conf, hadoopConf) : BoxedUnit.UNIT;
            }
            finally {
                lock.release();
                lockFileChannel.close();
            }
            this.copyFile(url, cachedFile, targetFile, conf.getBoolean("spark.files.overwrite", false), this.copyFile$default$5());
            file = BoxedUnit.UNIT;
        } else {
            file = this.doFetchFile(url, targetDir, fileName, conf, hadoopConf);
        }
        if (shouldUntar) {
            if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Untarring behavior will be deprecated at spark.files and SparkContext.addFile. Consider using spark.archives or SparkContext.addArchive instead.");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(10).append("Untarring ").append(fileName).toString());
                object = this.executeAndGetOutput((Seq<String>)((Seq)new .colon.colon((Object)"tar", (List)new .colon.colon((Object)"-xzf", (List)new .colon.colon((Object)fileName, (List)Nil$.MODULE$)))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
            } else if (fileName.endsWith(".tar")) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Untarring behavior will be deprecated at spark.files and SparkContext.addFile. Consider using spark.archives or SparkContext.addArchive instead.");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(10).append("Untarring ").append(fileName).toString());
                object = this.executeAndGetOutput((Seq<String>)((Seq)new .colon.colon((Object)"tar", (List)new .colon.colon((Object)"-xf", (List)new .colon.colon((Object)fileName, (List)Nil$.MODULE$)))), targetDir, this.executeAndGetOutput$default$3(), this.executeAndGetOutput$default$4());
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"a+x");
        Object object3 = this.isWindows() ? BoxesRunTime.boxToInteger((int)FileUtil.chmod((String)targetFile.getAbsolutePath(), (String)"u+r")) : BoxedUnit.UNIT;
        return targetFile;
    }

    public boolean fetchFile$default$7() {
        return true;
    }

    public void unpack(File source, File dest) {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        String lowerSrc = StringUtils.toLowerCase((String)source.getName());
        if (lowerSrc.endsWith(".jar")) {
            RunJar.unJar((File)source, (File)dest, (Pattern)RunJar.MATCH_ANY);
            return;
        }
        if (lowerSrc.endsWith(".zip")) {
            FileUtil.unZip((File)source, (File)dest);
            return;
        }
        if (lowerSrc.endsWith(".tar.gz") || lowerSrc.endsWith(".tgz")) {
            FileUtil.unTar((File)source, (File)dest);
            return;
        }
        if (lowerSrc.endsWith(".tar")) {
            this.unTarUsingJava(source, dest);
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Cannot unpack ").append(source).append(", just copying it to ").append(dest).append(".").toString());
        this.copyRecursive(source, dest);
    }

    private void unTarUsingJava(File source, File dest) {
        if (!dest.mkdirs() && !dest.isDirectory()) {
            throw new IOException(new java.lang.StringBuilder(24).append("Mkdirs failed to create ").append(dest).toString());
        }
        try {
            Method mth = FileUtil.class.getDeclaredMethod("unTarUsingJava", File.class, File.class, Boolean.TYPE);
            mth.setAccessible(true);
            mth.invoke(null, source, dest, Boolean.FALSE);
        }
        catch (Throwable throwable) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
    }

    public <T> Tuple2<T, Object> timeTakenMs(Function0<T> body2) {
        long startTime = System.nanoTime();
        Object result = body2.apply();
        long endTime = System.nanoTime();
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)package$.MODULE$.max(TimeUnit.NANOSECONDS.toMillis(endTime - startTime), 0L)));
    }

    private void downloadFile(String url, InputStream in, File destFile, boolean fileOverwrite) {
        File tempFile = File.createTempFile("fetchFileTemp", null, new File(destFile.getParentFile().getAbsolutePath()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(13).append("Fetching ").append(url).append(" to ").append(tempFile).toString());
        try {
            FileOutputStream out = new FileOutputStream(tempFile);
            this.copyStream(in, out, true, this.copyStream$default$4());
            this.copyFile(url, tempFile, destFile, fileOverwrite, true);
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(String url, File sourceFile, File destFile, boolean fileOverwrite, boolean removeSourceFile) {
        if (destFile.exists()) {
            if (!this.filesEqualRecursive(sourceFile, destFile)) {
                if (!fileOverwrite) throw new SparkException(new java.lang.StringBuilder(44).append("File ").append(destFile).append(" exists and does not match contents of ").append(url).toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(64).append("File ").append(destFile).append(" exists and does not match contents of ").append(url).append(", replacing it with ").append(url).toString());
                if (!destFile.delete()) {
                    throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Failed to delete %s while attempting to overwrite it with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destFile.getAbsolutePath(), sourceFile.getAbsolutePath()})));
                }
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("%s has been previously copied to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceFile.getAbsolutePath(), destFile.getAbsolutePath()})));
                return;
            }
        }
        if (removeSourceFile) {
            java.nio.file.Files.move(sourceFile.toPath(), destFile.toPath(), new CopyOption[0]);
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(12).append("Copying ").append(sourceFile.getAbsolutePath()).append(" to ").append(destFile.getAbsolutePath()).toString());
        this.copyRecursive(sourceFile, destFile);
    }

    private boolean copyFile$default$5() {
        return false;
    }

    private boolean filesEqualRecursive(File file1, File file2) {
        if (file1.isDirectory() && file2.isDirectory()) {
            File[] subfiles1 = file1.listFiles();
            File[] subfiles2 = file2.listFiles();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles1)).size() != new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles2)).size()) {
                return false;
            }
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles1)).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), (Ordering)Ordering.String$.MODULE$))).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles2)).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), (Ordering)Ordering.String$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$filesEqualRecursive$3(x0$1)));
        }
        if (file1.isFile() && file2.isFile()) {
            return Files.equal((File)file1, (File)file2);
        }
        return false;
    }

    private void copyRecursive(File source, File dest) {
        if (source.isDirectory()) {
            if (!dest.mkdir()) {
                throw new IOException(new java.lang.StringBuilder(27).append("Failed to create directory ").append(dest.getPath()).toString());
            }
            File[] subfiles = source.listFiles();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subfiles)).foreach((Function1 & Serializable & scala.Serializable)f -> {
                Utils$.MODULE$.copyRecursive(f, new File(dest, f.getName()));
                return BoxedUnit.UNIT;
            });
            return;
        }
        java.nio.file.Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
    }

    public File doFetchFile(String url, File targetDir, String filename, SparkConf conf, org.apache.hadoop.conf.Configuration hadoopConf) {
        File targetFile = new File(targetDir, filename);
        URI uri = new URI(url);
        boolean fileOverwrite = conf.getBoolean("spark.files.overwrite", false);
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "file");
        if ("spark".equals(string)) {
            if (SparkEnv$.MODULE$.get() == null) {
                throw new IllegalStateException("Cannot retrieve files with 'spark' scheme without an active SparkEnv.");
            }
            ReadableByteChannel source = SparkEnv$.MODULE$.get().rpcEnv().openChannel(url);
            InputStream is = Channels.newInputStream(source);
            this.downloadFile(url, is, targetFile, fileOverwrite);
        } else if ("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string))) {
            URLConnection uc = new URL(url).openConnection();
            int timeoutMs = (int)conf.getTimeAsSeconds("spark.files.fetchTimeout", "60s") * 1000;
            uc.setConnectTimeout(timeoutMs);
            uc.setReadTimeout(timeoutMs);
            uc.connect();
            InputStream in = uc.getInputStream();
            this.downloadFile(url, in, targetFile, fileOverwrite);
        } else if ("file".equals(string)) {
            File sourceFile = uri.isAbsolute() ? new File(uri) : new File(uri.getPath());
            this.copyFile(url, sourceFile, targetFile, fileOverwrite, this.copyFile$default$5());
        } else {
            FileSystem fs = this.getHadoopFileSystem(uri, hadoopConf);
            Path path = new Path(uri);
            this.fetchHcfsFile(path, targetDir, fs, conf, hadoopConf, fileOverwrite, (Option<String>)new Some((Object)filename));
        }
        return targetFile;
    }

    public void fetchHcfsFile(Path path, File targetDir, FileSystem fs, SparkConf conf, org.apache.hadoop.conf.Configuration hadoopConf, boolean fileOverwrite, Option<String> filename) {
        if (!targetDir.exists() && !targetDir.mkdir()) {
            throw new IOException(new java.lang.StringBuilder(27).append("Failed to create directory ").append(targetDir.getPath()).toString());
        }
        File dest = new File(targetDir, (String)filename.getOrElse((Function0 & Serializable & scala.Serializable)() -> path.getName()));
        if (fs.isFile(path)) {
            try (FSDataInputStream in = fs.open(path);){
                this.downloadFile(path.toString(), (InputStream)in, dest, fileOverwrite);
            }
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).foreach((Function1 & Serializable & scala.Serializable)fileStatus -> {
            Utils$.MODULE$.fetchHcfsFile(fileStatus.getPath(), dest, fs, conf, hadoopConf, fileOverwrite, Utils$.MODULE$.fetchHcfsFile$default$7());
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> fetchHcfsFile$default$7() {
        return None$.MODULE$;
    }

    public void validateURL(URI uri) throws MalformedURLException {
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "file");
        if ("http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string))) {
            try {
                uri.toURL();
            }
            catch (MalformedURLException e) {
                MalformedURLException ex = new MalformedURLException(new java.lang.StringBuilder(26).append("URI (").append(uri.toString()).append(") is not a valid URL.").toString());
                ex.initCause(e);
                throw ex;
            }
            return;
        }
    }

    public String getLocalDir(SparkConf conf) {
        String[] localRootDirs = this.getOrCreateLocalRootDirs(conf);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localRootDirs)).isEmpty()) {
            String[] configuredLocalDirs = this.getConfiguredLocalDirs(conf);
            throw new IOException(new java.lang.StringBuilder(40).append("Failed to get a temp directory under [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs)).mkString(",")).append("].").toString());
        }
        return localRootDirs[Random$.MODULE$.nextInt(localRootDirs.length)];
    }

    public boolean isRunningInYarnContainer(SparkConf conf) {
        return conf.getenv("CONTAINER_ID") != null;
    }

    public boolean isInRunningSparkTask() {
        return TaskContext$.MODULE$.get() != null;
    }

    public String[] getOrCreateLocalRootDirs(SparkConf conf) {
        if (this.localRootDirs() == null) {
            Utils$ utils$ = this;
            synchronized (utils$) {
                if (this.localRootDirs() == null) {
                    this.localRootDirs_$eq(this.getOrCreateLocalRootDirsImpl(conf));
                }
            }
        }
        return this.localRootDirs();
    }

    public String[] getConfiguredLocalDirs(SparkConf conf) {
        block4: {
            boolean shuffleServiceEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()));
            if (this.isRunningInYarnContainer(conf)) {
                return (String[])this.randomizeInPlace(this.getYarnLocalDirs(conf).split(","), this.randomizeInPlace$default$2());
            }
            if (conf.getenv("SPARK_EXECUTOR_DIRS") != null) {
                return conf.getenv("SPARK_EXECUTOR_DIRS").split(File.pathSeparator);
            }
            if (conf.getenv("SPARK_LOCAL_DIRS") != null) {
                return conf.getenv("SPARK_LOCAL_DIRS").split(",");
            }
            if (conf.getenv("MESOS_SANDBOX") != null && !shuffleServiceEnabled) {
                return (String[])((Object[])new String[]{conf.getenv("MESOS_SANDBOX")});
            }
            if (conf.getenv("MESOS_SANDBOX") == null || !shuffleServiceEnabled) break block4;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(81).append("MESOS_SANDBOX available but not using provided Mesos sandbox because ").append(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED().key()).append(" is enabled.").toString());
        }
        return conf.get("spark.local.dir", System.getProperty("java.io.tmpdir")).split(",");
    }

    private String[] getOrCreateLocalRootDirsImpl(SparkConf conf) {
        String[] configuredLocalDirs = this.getConfiguredLocalDirs(conf);
        String[] uris = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs)).filter((Function1 & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getOrCreateLocalRootDirsImpl$1(root)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uris)).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(144).append("The configured local directories are not expected to be URIs; however, got suspicious ").append("values [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uris)).mkString(", ")).append("]. Please check your configured local directories.").toString());
        }
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configuredLocalDirs)).flatMap((Function1 & Serializable & scala.Serializable)root -> {
            Iterable iterable;
            block3: {
                try {
                    File rootDir = new File((String)root);
                    if (rootDir.exists() || rootDir.mkdirs()) {
                        File dir = MODULE$.createTempDir((String)root, MODULE$.createTempDir$default$2());
                        MODULE$.chmod700(dir);
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)dir.getAbsolutePath()));
                        break block3;
                    }
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Failed to create dir in ").append((String)root).append(". Ignoring this directory.").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                catch (IOException e) {
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(61).append("Failed to create local root dir in ").append((String)root).append(". Ignoring this directory.").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    private String getYarnLocalDirs(SparkConf conf) {
        String localDirs = (String)Option$.MODULE$.apply((Object)conf.getenv("LOCAL_DIRS")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        if (localDirs.isEmpty()) {
            throw new Exception("Yarn Local dirs can't be empty");
        }
        return localDirs;
    }

    public void clearLocalRootDirs() {
        this.localRootDirs_$eq(null);
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int j = rand.nextInt(i + 1);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, j);
            ScalaRunTime$.MODULE$.array_update(arr, j, ScalaRunTime$.MODULE$.array_apply(arr, i));
            ScalaRunTime$.MODULE$.array_update(arr, i, tmp);
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    private InetAddress localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.localIpAddress;
    }

    private InetAddress localIpAddress() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.localIpAddress$lzycompute();
        }
        return this.localIpAddress;
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            String defaultIpOverride = System.getenv("SPARK_LOCAL_IP");
            if (defaultIpOverride != null) {
                inetAddress = InetAddress.getByName(defaultIpOverride);
            } else {
                void var3_3;
                InetAddress address = InetAddress.getLocalHost();
                if (address.isLoopbackAddress()) {
                    Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                    Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                    reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                        Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                        return BoxedUnit.UNIT;
                    });
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(95).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address.getHostAddress()).append(", but we couldn't find any").append(" external IP address!").toString());
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set SPARK_LOCAL_IP if you need to bind to another address");
                }
                inetAddress = var3_3;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localCanonicalHostName() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getCanonicalHostName()));
    }

    public String localHostName() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.localIpAddress().getHostAddress()));
    }

    public String localHostNameForURI() {
        return this.addBracketsIfNeeded((String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> InetAddresses.toUriString((InetAddress)MODULE$.localIpAddress())));
    }

    public String addBracketsIfNeeded(String addr) {
        if (addr.contains(":") && !addr.contains("[")) {
            return new java.lang.StringBuilder(2).append("[").append(addr).append("]").toString();
        }
        return addr;
    }

    public String normalizeIpIfNeeded(String host) {
        String string;
        Regex addressRe = new StringOps(Predef$.MODULE$.augmentString("^\\[{0,1}([0-9:]+?:[0-9]*)\\]{0,1}$")).r();
        Option option = addressRe.unapplySeq((CharSequence)(string = host));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String unbracketed = (String)((LinearSeqOptimized)option.get()).apply(0);
            return this.addBracketsIfNeeded(InetAddresses.toAddrString((InetAddress)InetAddresses.forString((String)unbracketed)));
        }
        return host;
    }

    public void checkHost(String host) {
        if (host != null && host.split(":").length > 2) {
            Predef$.MODULE$.assert(host.startsWith("[") && host.endsWith("]"), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("Expected hostname or IPv6 IP enclosed in [] but got ").append(host).toString());
            return;
        }
        Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Expected hostname or IP but got ").append(host).toString());
    }

    public void checkHostPort(String hostPort) {
        if (hostPort != null && hostPort.split(":").length > 2) {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf("]:") != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
            return;
        }
        Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    public Tuple2<String, Object> parseHostPort(String hostPort) {
        Tuple2<String, Object> tuple2;
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached != null) {
            return cached;
        }
        if (hostPort != null && hostPort.split(":").length > 2) {
            int index = hostPort.lastIndexOf("]:");
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 2).trim();
            Tuple2 retval = new Tuple2((Object)hostPort.substring(0, index + 1).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
        } else {
            int index = hostPort.lastIndexOf(58);
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 1).trim();
            Tuple2 retval = new Tuple2((Object)hostPort.substring(0, index).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retval);
        }
        return this.hostPortParseResults().get(hostPort);
    }

    public String getUsedTimeNs(long startTimeNs) {
        return new java.lang.StringBuilder(3).append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString();
    }

    public File[] recursiveList(File f) {
        Predef$.MODULE$.require(f.isDirectory());
        Buffer result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.listFiles())).toBuffer();
        Buffer dirList = (Buffer)result.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDirectory()));
        while (dirList.nonEmpty()) {
            File curDir = (File)dirList.remove(0);
            File[] files = curDir.listFiles();
            result.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
            dirList.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDirectory())))));
        }
        return (File[])result.toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public void deleteRecursively(File file) {
        if (file != null) {
            JavaUtils.deleteRecursively((File)file);
            ShutdownHookManager$.MODULE$.removeShutdownDeleteDir(file);
            return;
        }
    }

    public boolean doesDirectoryContainAnyNewFiles(File dir, long cutoff) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(dir).append(" is not a directory!").toString());
        }
        File[] filesAndDirs = dir.listFiles();
        long cutoffTimeInMillis = System.currentTimeMillis() - cutoff * 1000L;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs)).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$doesDirectoryContainAnyNewFiles$1(cutoffTimeInMillis, x$6))) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesAndDirs)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDirectory())))).exists((Function1 & Serializable & scala.Serializable)subdir -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.doesDirectoryContainAnyNewFiles(subdir, cutoff)));
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs((String)str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec((String)str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes((String)str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb((String)str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb((String)str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb((String)str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes((String)str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        return this.bytesToString(scala.package$.MODULE$.BigInt().apply(size));
    }

    public String bytesToString(BigInt size) {
        Tuple2 tuple2;
        long EiB = 0x1000000000000000L;
        long PiB = 0x4000000000000L;
        long TiB = 0x10000000000L;
        long GiB = 0x40000000L;
        long MiB = 0x100000L;
        long KiB = 1024L;
        if (size.$greater$eq((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EiB)))) {
            return new java.lang.StringBuilder(2).append(scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append(" B").toString();
        }
        Tuple2 tuple22 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * EiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EiB)), (Object)"EiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * PiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(PiB)), (Object)"PiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * TiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(TiB)), (Object)"TiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * GiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(GiB)), (Object)"GiB") : (size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * MiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(MiB)), (Object)"MiB") : (tuple2 = size.$greater$eq((Object)BigInt$.MODULE$.long2bigInt(2L * KiB)) ? new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(KiB)), (Object)"KiB") : new Tuple2((Object)scala.package$.MODULE$.BigDecimal().apply(size), (Object)"B"))))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal value = (BigDecimal)tuple2._1();
        String unit = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)value, (Object)unit);
        BigDecimal value2 = (BigDecimal)tuple23._1();
        String unit2 = (String)tuple23._2();
        return new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value2, unit2}));
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        if (l < (long)second) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)}));
        }
        if (l < (long)minute) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))}));
        }
        if (l < (long)hour) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))}));
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}));
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public Process executeCommand(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        java.util.Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$executeCommand$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return environment.put(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Process process = builder.start();
        if (redirectStderr) {
            String threadName = new java.lang.StringBuilder(28).append("redirect stderr for command ").append(command.apply(0)).toString();
            object = this.processStreamByLine(threadName, process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                this.log$1(s);
                return BoxedUnit.UNIT;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public Map<String, String> executeCommand$default$3() {
        return Map$.MODULE$.empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = new java.lang.StringBuilder(16).append("read stdout for ").append(command.apply(0)).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            Utils$.appendToOutput$1(s, output);
            return BoxedUnit.UNIT;
        });
        int exitCode = process.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("Process ").append(command).append(" exited with code ").append(exitCode).append(": ").append((CharSequence)output).toString());
            throw new SparkException(new java.lang.StringBuilder(26).append("Process ").append(command).append(" exited with code ").append(exitCode).toString());
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public Map<String, String> executeAndGetOutput$default$3() {
        return Map$.MODULE$.empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            private final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
                    anon.4.$anonfun$run$1(this, line);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(anon.4 $this, String line) {
                $this.processLine$1.apply((Object)line);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.spark.util.Utils$$anon$4 java.lang.String )}, serializedLambda);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.sparkUncaughtExceptionHandler().uncaughtException(throwable3);
            }
            throw throwable;
        }
    }

    public void tryOrStopSparkContext(SparkContext sc, Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                String currentThreadName = Thread.currentThread().getName();
                if (sc != null) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append("uncaught error in thread ").append(currentThreadName).append(", stopping SparkContext").toString(), throwable3);
                    sc.stopInNewThread();
                }
                if (!NonFatal$.MODULE$.apply(throwable3)) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("throw uncaught fatal error in thread ").append(currentThreadName).toString(), throwable3);
                    throw throwable3;
                }
            }
            throw throwable;
        }
    }

    public <T> T tryOrIOException(Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", e);
                throw new IOException(e);
            }
            throw throwable;
        }
        return (T)object;
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
            }
            throw throwable;
        }
    }

    public <T> T tryWithSafeFinally(Function0<T> block, Function0<BoxedUnit> finallyBlock) {
        Object object;
        Throwable originalThrowable = null;
        try {
            try {
                object = block.apply();
            }
            catch (Throwable t) {
                originalThrowable = t;
                throw originalThrowable;
            }
        }
        catch (Throwable throwable) {
            try {
                finallyBlock.apply$mcV$sp();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 != null) {
                    Throwable throwable4 = throwable3;
                    if (originalThrowable != null) {
                        Throwable throwable5 = originalThrowable;
                        Throwable throwable6 = throwable4;
                        if (throwable5 == null ? throwable6 != null : !throwable5.equals(throwable6)) {
                            originalThrowable.addSuppressed(throwable4);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable4.getMessage()).toString(), throwable4);
                            throw originalThrowable;
                        }
                    }
                }
                throw throwable2;
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable7 = throwable;
            if (throwable7 != null) {
                Throwable throwable8 = throwable7;
                if (originalThrowable != null) {
                    Throwable throwable9 = originalThrowable;
                    Throwable throwable10 = throwable8;
                    if (throwable9 == null ? throwable10 != null : !throwable9.equals(throwable10)) {
                        originalThrowable.addSuppressed(throwable8);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable4.getMessage()).toString(), throwable8);
                        throw originalThrowable;
                    }
                }
            }
            throw throwable;
        }
        return (T)object2;
    }

    public <T> T tryWithSafeFinallyAndFailureCallbacks(Function0<T> block, Function0<BoxedUnit> catchBlock, Function0<BoxedUnit> finallyBlock) {
        Object object;
        Throwable originalThrowable = null;
        try {
            try {
                object = block.apply();
            }
            catch (Throwable cause) {
                block18: {
                    originalThrowable = cause;
                    try {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Aborting task", originalThrowable);
                        if (TaskContext$.MODULE$.get() != null) {
                            TaskContext$.MODULE$.get().markTaskFailed(originalThrowable);
                        }
                        catchBlock.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        Throwable throwable = originalThrowable;
                        Throwable throwable2 = t;
                        if (!(throwable == null ? throwable2 != null : !throwable.equals(throwable2))) break block18;
                        originalThrowable.addSuppressed(t);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Suppressing exception in catch: ").append(t.getMessage()).toString(), t);
                    }
                }
                throw originalThrowable;
            }
        }
        catch (Throwable throwable) {
            try {
                finallyBlock.apply$mcV$sp();
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                if (throwable4 != null) {
                    Throwable throwable5 = throwable4;
                    if (originalThrowable != null) {
                        Throwable throwable6 = originalThrowable;
                        Throwable throwable7 = throwable5;
                        if (throwable6 == null ? throwable7 != null : !throwable6.equals(throwable7)) {
                            originalThrowable.addSuppressed(throwable5);
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable5.getMessage()).toString(), throwable5);
                            throw originalThrowable;
                        }
                    }
                }
                throw throwable3;
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            finallyBlock.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (throwable8 != null) {
                Throwable throwable9 = throwable8;
                if (originalThrowable != null) {
                    Throwable throwable10 = originalThrowable;
                    Throwable throwable11 = throwable9;
                    if (throwable10 == null ? throwable11 != null : !throwable10.equals(throwable11)) {
                        originalThrowable.addSuppressed(throwable9);
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("Suppressing exception in finally: ").append(throwable5.getMessage()).toString(), throwable9);
                        throw originalThrowable;
                    }
                }
            }
            throw throwable;
        }
        return (T)object2;
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$2(Function0<T> block) {
    }

    public <T> void tryWithSafeFinallyAndFailureCallbacks$default$3(Function0<T> block) {
    }

    private Regex SPARK_CORE_CLASS_REGEX() {
        return this.SPARK_CORE_CLASS_REGEX;
    }

    private Regex SPARK_SQL_CLASS_REGEX() {
        return this.SPARK_SQL_CLASS_REGEX;
    }

    private boolean sparkInternalExclusionFunction(String className) {
        String SCALA_CORE_CLASS_PREFIX = "scala";
        boolean isSparkClass = this.SPARK_CORE_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined() || this.SPARK_SQL_CLASS_REGEX().findFirstIn((CharSequence)className).isDefined();
        boolean isScalaClass = className.startsWith(SCALA_CORE_CLASS_PREFIX);
        return isSparkClass || isScalaClass;
    }

    public CallSite getCallSite(Function1<String, Object> skipClass) {
        ObjectRef lastSparkMethod = ObjectRef.create((Object)"<unknown>");
        ObjectRef firstUserFile = ObjectRef.create((Object)"<unknown>");
        IntRef firstUserLine = IntRef.create((int)0);
        BooleanRef insideSpark = BooleanRef.create((boolean)true);
        ArrayBuffer callStack = (ArrayBuffer)new ArrayBuffer().$colon$plus((Object)"<unknown>", ArrayBuffer$.MODULE$.canBuildFrom());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).foreach((Function1 & Serializable & scala.Serializable)ste -> {
            if (ste != null && ste.getMethodName() != null && !ste.getMethodName().contains("getStackTrace")) {
                if (insideSpark$1.elem) {
                    if (BoxesRunTime.unboxToBoolean((Object)skipClass.apply((Object)ste.getClassName()))) {
                        String string = ste.getMethodName();
                        String string2 = "<init>";
                        lastSparkMethod$1.elem = !(string != null ? !string.equals(string2) : string2 != null) ? ste.getClassName().substring(ste.getClassName().lastIndexOf(46) + 1) : ste.getMethodName();
                        callStack.update(0, (Object)ste.toString());
                        return BoxedUnit.UNIT;
                    }
                    if (ste.getFileName() != null) {
                        firstUserFile$1.elem = ste.getFileName();
                        if (ste.getLineNumber() >= 0) {
                            firstUserLine$1.elem = ste.getLineNumber();
                        }
                    }
                    callStack.$plus$eq((Object)ste.toString());
                    insideSpark$1.elem = false;
                    return BoxedUnit.UNIT;
                }
                return callStack.$plus$eq((Object)ste.toString());
            }
            return BoxedUnit.UNIT;
        });
        int callStackDepth = new StringOps(Predef$.MODULE$.augmentString(System.getProperty("spark.callstack.depth", "20"))).toInt();
        String string = (String)firstUserFile.elem;
        String string2 = "HiveSessionImpl.java";
        String shortForm = !(string != null ? !string.equals(string2) : string2 != null) ? "Spark JDBC Server Query" : new java.lang.StringBuilder(5).append((String)lastSparkMethod.elem).append(" at ").append((String)firstUserFile.elem).append(":").append(firstUserLine.elem).toString();
        String longForm = ((TraversableOnce)callStack.take(callStackDepth)).mkString("\n");
        return new CallSite(shortForm, longForm);
    }

    public Function1<String, Object> getCallSite$default$1() {
        return (Function1 & Serializable & scala.Serializable)className -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.sparkInternalExclusionFunction(className));
    }

    private LoadingCache<String, Long> compressedLogFileLengthCache() {
        return this.compressedLogFileLengthCache;
    }

    private void compressedLogFileLengthCache_$eq(LoadingCache<String, Long> x$1) {
        this.compressedLogFileLengthCache = x$1;
    }

    private synchronized LoadingCache<String, Long> getCompressedLogFileLengthCache(SparkConf sparkConf) {
        block0: {
            if (this.compressedLogFileLengthCache() != null) break block0;
            int compressedLogFileLengthCacheSize = BoxesRunTime.unboxToInt((Object)sparkConf.get(Worker$.MODULE$.UNCOMPRESSED_LOG_FILE_LENGTH_CACHE_SIZE_CONF()));
            this.compressedLogFileLengthCache_$eq((LoadingCache<String, Long>)CacheBuilder.newBuilder().maximumSize((long)compressedLogFileLengthCacheSize).build((CacheLoader)new CacheLoader<String, Long>(){

                public Long load(String path) {
                    return Predef$.MODULE$.long2Long(Utils$.MODULE$.org$apache$spark$util$Utils$$getCompressedFileLength(new File(path)));
                }
            }));
        }
        return this.compressedLogFileLengthCache();
    }

    public long getFileLength(File file, SparkConf workConf) {
        if (file.getName().endsWith(".gz")) {
            return Predef$.MODULE$.Long2long((Long)this.getCompressedLogFileLengthCache(workConf).get((Object)file.getAbsolutePath()));
        }
        return file.length();
    }

    /*
     * WARNING - void declaration
     */
    public long org$apache$spark$util$Utils$$getCompressedFileLength(File file) {
        void v0;
        try (GZIPInputStream gzInputStream = null;){
            try {
                void var3_3;
                long fileSize = 0L;
                gzInputStream = new GZIPInputStream(new FileInputStream(file));
                int bufSize = 1024;
                byte[] buf = new byte[bufSize];
                int numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                while (numBytes > 0) {
                    fileSize += (long)numBytes;
                    numBytes = ByteStreams.read((InputStream)gzInputStream, (byte[])buf, (int)0, (int)bufSize);
                }
                v0 = var3_3;
            }
            catch (Throwable e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Cannot get file length of ").append(file).toString(), e);
                throw e;
            }
        }
        return (long)v0;
    }

    public String offsetBytes(String path, long length, long start, long end) {
        File file = new File(path);
        long effectiveEnd = package$.MODULE$.min(length, end);
        long effectiveStart = package$.MODULE$.max(0L, start);
        byte[] buff = new byte[(int)(effectiveEnd - effectiveStart)];
        try (InputStream stream = path.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);){
            ByteStreams.skipFully((InputStream)stream, (long)effectiveStart);
            ByteStreams.readFully((InputStream)stream, (byte[])buff);
        }
        return Source$.MODULE$.fromBytes(buff, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String offsetBytes(Seq<File> files, Seq<Object> fileLengths, long start, long end) {
        Predef$.MODULE$.assert(files.length() == fileLengths.length());
        long startIndex = package$.MODULE$.max(start, 0L);
        long endIndex = package$.MODULE$.min(end, BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        scala.collection.immutable.Map<File, Object> fileToLength = org.apache.spark.util.collection.Utils$.MODULE$.toMap(files, fileLengths);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(12).append("Log files: \n").append(fileToLength.mkString("\n")).toString());
        StringBuffer stringBuffer = new StringBuffer((int)(endIndex - startIndex));
        LongRef sum = LongRef.create((long)0L);
        ((IterableLike)files.zip(fileLengths, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Utils$.$anonfun$offsetBytes$2(sum, fileToLength, endIndex, startIndex, stringBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
        return stringBuffer.toString();
    }

    public <T> T clone(T value, SerializerInstance serializer, ClassTag<T> evidence$2) {
        return serializer.deserialize(serializer.serialize(value, evidence$2), evidence$2);
    }

    private boolean isSpace(char c) {
        return " \t\r\n".indexOf(c) != -1;
    }

    public Seq<String> splitCommandString(String s) {
        ArrayBuffer buf;
        block14: {
            buf = new ArrayBuffer();
            boolean inWord = false;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            StringBuilder curWord = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                BoxedUnit boxedUnit;
                char nextChar = s.charAt(i);
                if (inDoubleQuote) {
                    if (nextChar == '\"') {
                        inDoubleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (nextChar == '\\') {
                        if (i < s.length() - 1) {
                            curWord.append(s.charAt(i + 1));
                            ++i;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (inSingleQuote) {
                    if (nextChar == '\'') {
                        inSingleQuote = false;
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = curWord.append(nextChar);
                    continue;
                }
                if (nextChar == '\"') {
                    inWord = true;
                    inDoubleQuote = true;
                } else if (nextChar == '\'') {
                    inWord = true;
                    inSingleQuote = true;
                } else if (!this.isSpace(nextChar)) {
                    curWord.append(nextChar);
                    inWord = true;
                } else if (inWord && this.isSpace(nextChar)) {
                    Utils$.endWord$1(buf, curWord);
                    inWord = false;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!inWord && !inDoubleQuote && !inSingleQuote) break block14;
            Utils$.endWord$1(buf, curWord);
        }
        return buf.toSeq();
    }

    public int nonNegativeMod(int x, int mod) {
        int rawMod;
        return rawMod + ((rawMod = x % mod) < 0 ? mod : 0);
    }

    public int nonNegativeHash(Object obj) {
        if (obj == null) {
            return 0;
        }
        int hash = obj.hashCode();
        int hashAbs = Integer.MIN_VALUE != hash ? package$.MODULE$.abs(hash) : 0;
        return hashAbs;
    }

    public Map<String, String> getSystemProperties() {
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)System.getProperty(key)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void times(int numIters, Function0<BoxedUnit> f) {
        for (int i = 0; i < numIters; ++i) {
            f.apply$mcV$sp();
        }
    }

    public long timeIt(int numIters, Function0<BoxedUnit> f, Option<Function0<BoxedUnit>> prepare) {
        if (prepare.isEmpty()) {
            long startNs = System.nanoTime();
            this.times(numIters, f);
            return System.nanoTime() - startNs;
        }
        long sum = 0L;
        for (int i = 0; i < numIters; ++i) {
            ((Function0)prepare.get()).apply$mcV$sp();
            long startNs = System.nanoTime();
            f.apply$mcV$sp();
            sum += System.nanoTime() - startNs;
        }
        return sum;
    }

    public Option<Function0<BoxedUnit>> timeIt$default$3(int numIters) {
        return None$.MODULE$;
    }

    public long getIteratorSize(Iterator<?> iterator) {
        return Iterators$.MODULE$.size(iterator);
    }

    public <T> Iterator<Tuple2<T, Object>> getIteratorZipWithIndex(Iterator<T> iter, long startIndex) {
        return new Iterator<Tuple2<T, Object>>(startIndex, iter){
            private long index;
            private final Iterator iter$1;

            public Iterator<Tuple2<T, Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Tuple2<T, Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Tuple2<T, Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Tuple2<T, Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Tuple2<T, Object>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Tuple2<T, Object>> filter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Tuple2<T, Object>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Tuple2<T, Object>> withFilter(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> filterNot(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Tuple2<T, Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Tuple2<T, Object>> takeWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> partition(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> span(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Tuple2<T, Object>> dropWhile(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Tuple2<T, Object>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Tuple2<T, Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Tuple2<T, Object>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Tuple2<T, Object>> find(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<T, Object>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Tuple2<T, Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Tuple2<T, Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Tuple2<T, Object>>, Iterator<Tuple2<T, Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Tuple2<T, Object>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Tuple2<T, Object>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Tuple2<T, Object>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Tuple2<T, Object>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Tuple2<T, Object>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Tuple2<T, Object>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Tuple2<T, Object>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Tuple2<T, Object>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<T, Object>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Tuple2<T, Object>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<T, Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Tuple2<T, Object>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Tuple2<T, Object>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Tuple2<T, Object>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Tuple2<T, Object>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Tuple2<T, Object>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Tuple2<T, Object>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<Tuple2<T, Object>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private long index() {
                return this.index;
            }

            private void index_$eq(long x$1) {
                this.index = x$1;
            }

            public boolean hasNext() {
                return this.iter$1.hasNext();
            }

            public Tuple2<T, Object> next() {
                this.index_$eq(this.index() + 1L);
                return new Tuple2(this.iter$1.next(), (Object)BoxesRunTime.boxToLong((long)this.index()));
            }
            {
                this.iter$1 = iter$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                Predef$.MODULE$.require(startIndex$2 >= 0L, (Function0 & Serializable & scala.Serializable)() -> "startIndex should be >= 0.");
                this.index = startIndex$2 - 1L;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1()}, serializedLambda);
            }
        };
    }

    public void symlink(File src, File dst) {
        if (!src.isAbsolute()) {
            throw new IOException("Source must be absolute");
        }
        if (dst.isAbsolute()) {
            throw new IOException("Destination must be relative");
        }
        java.nio.file.Files.createSymbolicLink(dst.toPath(), src.toPath(), new FileAttribute[0]);
    }

    public String getFormattedClassName(Object obj) {
        return this.getSimpleName(obj.getClass()).replace("$", "");
    }

    public FileSystem getHadoopFileSystem(URI path, org.apache.hadoop.conf.Configuration conf) {
        return FileSystem.get((URI)path, (org.apache.hadoop.conf.Configuration)conf);
    }

    public FileSystem getHadoopFileSystem(String path, org.apache.hadoop.conf.Configuration conf) {
        return this.getHadoopFileSystem(new URI(path), conf);
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isMacOnAppleSilicon() {
        return this.isMacOnAppleSilicon;
    }

    public boolean preferIPv6() {
        return this.preferIPv6;
    }

    public Regex windowsDrive() {
        return this.windowsDrive;
    }

    public boolean isTesting() {
        return System.getenv("SPARK_TESTING") != null || System.getProperty(Tests$.MODULE$.IS_TESTING().key()) != null;
    }

    public Option<Object> terminateProcess(Process process, long timeoutMs) {
        Process process2;
        process.destroy();
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        }
        try {
            process2 = process.destroyForcibly();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when attempting to kill process", e);
                process2 = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        if (process.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)process.exitValue()));
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting to forcibly kill process");
        return None$.MODULE$;
    }

    public Option<String> getStderr(Process process, long timeoutMs) {
        boolean terminated = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
        if (terminated) {
            return new Some((Object)Source$.MODULE$.fromInputStream(process.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n"));
        }
        return None$.MODULE$;
    }

    public <T> T logUncaughtExceptions(Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), throwable3);
                throw throwable3;
            }
            throw throwable;
        }
        return (T)object;
    }

    public <T> Try<T> tryLog(Function0<T> f) {
        Success success;
        try {
            Object res = f.apply();
            success = new Success(res);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), throwable3);
                success = new Failure(throwable3);
            }
            throw throwable;
        }
        return success;
    }

    public boolean isFatalError(Throwable e) {
        Throwable throwable = e;
        Option option = NonFatal$.MODULE$.unapply(throwable);
        return !(!option.isEmpty() ? true : (throwable instanceof InterruptedException ? true : (throwable instanceof NotImplementedError ? true : (throwable instanceof ControlThrowable ? true : throwable instanceof LinkageError))));
    }

    public URI resolveURI(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme() != null) {
                return uri;
            }
            if (uri.getFragment() != null) {
                URI absoluteURI = new File(uri.getPath()).getAbsoluteFile().toURI();
                return new URI(absoluteURI.getScheme(), absoluteURI.getHost(), absoluteURI.getPath(), uri.getFragment());
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        return new File(path).getCanonicalFile().toURI();
    }

    public String resolveURIs(String paths) {
        if (paths == null || paths.trim().isEmpty()) {
            return "";
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths.split(","))).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$resolveURIs$1(x$10))))).map((Function1 & Serializable & scala.Serializable)p -> MODULE$.resolveURI((String)p), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URI.class))))).mkString(",");
    }

    public boolean isAbsoluteURI(String path) {
        boolean bl;
        try {
            URI uri = new URI(path);
            bl = uri.isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            bl = false;
        }
        return bl;
    }

    public String[] nonLocalPaths(String paths, boolean testWindows) {
        boolean windows;
        boolean bl = windows = this.isWindows() || testWindows;
        if (paths == null || paths.trim().isEmpty()) {
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths.split(","))).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$nonLocalPaths$1(windows, p)));
    }

    public boolean nonLocalPaths$default$2() {
        return false;
    }

    public String loadDefaultSparkProperties(SparkConf conf, String filePath) {
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getDefaultPropertiesFile(MODULE$.getDefaultPropertiesFile$default$1()));
        Option$.MODULE$.apply((Object)path).foreach((Function1 & Serializable & scala.Serializable)confFile -> {
            Utils$.$anonfun$loadDefaultSparkProperties$2(conf, confFile);
            return BoxedUnit.UNIT;
        });
        return path;
    }

    public String loadDefaultSparkProperties$default$2() {
        return null;
    }

    public void updateSparkConfigFromProperties(SparkConf conf, Map<String, String> properties) {
        ((IterableLike)properties.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$updateSparkConfigFromProperties$1(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return conf.set(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String trimExceptCRLF(String str) {
        Function1 & Serializable & scala.Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        if (firstPos >= 0 && lastPos >= 0) {
            return str.substring(firstPos, lastPos + 1);
        }
        return "";
    }

    public Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Properties file ").append(file).append(" is not a normal file").toString());
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new SparkException(new java.lang.StringBuilder(42).append("Failed when loading Spark properties from ").append(filename).toString(), e);
            }
        }
        return map;
    }

    public String getDefaultPropertiesFile(Map<String, String> env) {
        return (String)env.get((Object)"SPARK_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"SPARK_HOME").map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)t -> new File(new java.lang.StringBuilder(19).append((String)t).append(File.separator).append("spark-defaults.conf").toString())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isFile())).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String exceptionString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private Utils.Lock Lock(LockInfo lock) {
        return new Utils.Lock(lock);
    }

    public ThreadStackTrace[] getThreadDump() {
        ThreadInfo[] threadInfos = (ThreadInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getThreadMXBean().dumpAllThreads(true, true))).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getThreadDump$1(x$13)));
        return (ThreadStackTrace[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfos)).sortWith((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getThreadDump$2(x0$1, x1$1))))).map((Function1 & Serializable & scala.Serializable)threadInfo -> MODULE$.threadInfoToThreadStackTrace((ThreadInfo)threadInfo), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ThreadStackTrace.class)));
    }

    public Option<ThreadStackTrace> getThreadDumpForThread(long threadId) {
        if (threadId <= 0L) {
            return None$.MODULE$;
        }
        Option threadInfo2 = Option$.MODULE$.apply((Object)ManagementFactory.getThreadMXBean().getThreadInfo(threadId, Integer.MAX_VALUE));
        return threadInfo2.map((Function1 & Serializable & scala.Serializable)threadInfo -> MODULE$.threadInfoToThreadStackTrace((ThreadInfo)threadInfo));
    }

    private ThreadStackTrace threadInfoToThreadStackTrace(ThreadInfo threadInfo) {
        scala.collection.immutable.Map monitors = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors())).map((Function1 & Serializable & scala.Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)m.getLockedStackFrame()), m), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        StackTrace stackTrace = new StackTrace((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getStackTrace())).map((Function1 & Serializable & scala.Serializable)frame -> {
            Option option = monitors.get(frame);
            if (option instanceof Some) {
                Some some = (Some)option;
                MonitorInfo monitor = (MonitorInfo)some.value();
                return new java.lang.StringBuilder(12).append(monitor.getLockedStackFrame().toString()).append(" => holding ").append(MODULE$.Lock(monitor).lockString()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return frame.toString();
            }
            throw new MatchError((Object)option);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        Set heldLocks = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedSynchronizers())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfo.getLockedMonitors())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LockInfo.class))))).map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.Lock((LockInfo)x$14).lockString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        return new ThreadStackTrace(threadInfo.getThreadId(), threadInfo.getThreadName(), threadInfo.getThreadState(), stackTrace, (Option<Object>)(threadInfo.getLockOwnerId() < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)threadInfo.getLockOwnerId()))), (String)Option$.MODULE$.apply((Object)threadInfo.getLockInfo()).map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.Lock((LockInfo)x$15).lockString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Seq<String>)heldLocks.toSeq());
    }

    public Seq<String> sparkJavaOpts(SparkConf conf, Function1<String, Object> filterKey) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$sparkJavaOpts$1(filterKey, x0$1))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new java.lang.StringBuilder(3).append("-D").append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Function1<String, Object> sparkJavaOpts$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$sparkJavaOpts$default$2$1(x$16));
    }

    public int portMaxRetries(SparkConf conf) {
        Option maxRetries = conf.getOption("spark.port.maxRetries").map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)Utils$.$anonfun$portMaxRetries$1(x$17)));
        if (conf.contains(Tests$.MODULE$.IS_TESTING())) {
            return BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 100));
        }
        return BoxesRunTime.unboxToInt((Object)maxRetries.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 16));
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, SparkConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable & scala.Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            String serviceString = serviceName.isEmpty() ? "" : new java.lang.StringBuilder(3).append(" '").append(serviceName).append("'").toString();
            int maxRetries = this.portMaxRetries(conf);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
                int tryPort = startPort == 0 ? startPort : MODULE$.userPort(startPort, offset);
                try {
                    Tuple2 tuple2 = (Tuple2)startService.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object service = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                    Object service2 = tuple22._1();
                    int port2 = tuple22._2$mcI$sp();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Successfully started service").append(serviceString).append(" on port ").append(port2).append(".").toString());
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                }
                catch (Throwable throwable) {
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= maxRetries) {
                            String exceptionMessage = startPort == 0 ? new java.lang.StringBuilder(195).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (on a random free port)! ").append("Consider explicitly setting the appropriate binding address for ").append("the service").append(serviceString).append(" (for example ").append(org.apache.spark.internal.config.package$.MODULE$.DRIVER_BIND_ADDRESS().key()).append(" ").append("for SparkDriver) to the correct binding address.").toString() : new java.lang.StringBuilder(212).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (starting from ").append(startPort).append(")! Consider explicitly setting ").append("the appropriate port for the service").append(serviceString).append(" (for example spark.ui.port ").append("for SparkUI) to an available port or increasing spark.port.maxRetries.").toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                        if (startPort == 0) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(111).append("Service").append(serviceString).append(" could not bind on a random free port. ").append("You may check whether configuring an appropriate binding address.").toString());
                        } else {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Service").append(serviceString).append(" could not bind on port ").append(tryPort).append(". ").append("Attempting port ").append(tryPort + 1).append(".").toString());
                        }
                    } else {
                        throw throwable;
                    }
                    return;
                }
            });
            throw new SparkException(new java.lang.StringBuilder(32).append("Failed to start service").append(serviceString).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public boolean isBindCollision(Throwable exception2) {
        while (true) {
            Throwable throwable;
            if ((throwable = exception2) instanceof BindException) {
                BindException bindException = (BindException)throwable;
                if (bindException.getMessage() != null) {
                    return true;
                }
                exception2 = bindException.getCause();
                continue;
            }
            if (throwable instanceof MultiException) {
                MultiException multiException = (MultiException)throwable;
                return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(multiException.getThrowables()).asScala()).exists((Function1 & Serializable & scala.Serializable)exception -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isBindCollision(exception)));
            }
            if (throwable instanceof Errors.NativeIoException) {
                Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                    exception2 = nativeIoException.getCause();
                    continue;
                }
                return true;
            }
            if (!(throwable instanceof Exception)) break;
            Exception exception3 = (Exception)throwable;
            exception2 = exception3.getCause();
        }
        return false;
    }

    public void setLogLevel(Level l) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(l);
        ctx.updateLoggers();
        Logging$.MODULE$.sparkShellThresholdLevel_$eq(null);
    }

    public String libraryPathEnvName() {
        if (this.isWindows()) {
            return "PATH";
        }
        if (this.isMac()) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public String libraryPathEnvPrefix(Seq<String> libraryPaths) {
        String libraryPathScriptVar = this.isWindows() ? new java.lang.StringBuilder(2).append("%").append(this.libraryPathEnvName()).append("%").toString() : new java.lang.StringBuilder(1).append("$").append(this.libraryPathEnvName()).toString();
        String libraryPath = ((TraversableOnce)libraryPaths.$colon$plus((Object)libraryPathScriptVar, Seq$.MODULE$.canBuildFrom())).mkString("\"", File.pathSeparator, "\"");
        String ampersand = this.isWindows() ? " &" : "";
        return new java.lang.StringBuilder(1).append(this.libraryPathEnvName()).append("=").append(libraryPath).append(ampersand).toString();
    }

    public String getSparkOrYarnConfig(SparkConf conf, String key, String string) {
        if (conf.contains(key)) {
            return conf.get(key, string);
        }
        String string2 = conf.get("spark.master", null);
        String string3 = "yarn";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new YarnConfiguration(SparkHadoopUtil$.MODULE$.get().newConfiguration(conf)).get(key, string);
        }
        return string;
    }

    public Tuple2<String, Object> extractHostPortFromSparkUrl(String sparkUrl) throws SparkException {
        Tuple2 tuple2;
        try {
            int port;
            String host;
            block5: {
                block4: {
                    URI uri = new URI(sparkUrl);
                    host = uri.getHost();
                    port = uri.getPort();
                    String string = uri.getScheme();
                    String string2 = "spark";
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                    if (host != null && port >= 0 && (uri.getPath() == null || uri.getPath().isEmpty()) && uri.getFragment() == null && uri.getQuery() == null && uri.getUserInfo() == null) break block5;
                }
                throw new SparkException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(sparkUrl).toString());
            }
            tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        }
        catch (URISyntaxException e) {
            throw new SparkException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(sparkUrl).toString(), e);
        }
        return tuple2;
    }

    public String getCurrentUserName() {
        return (String)Option$.MODULE$.apply((Object)System.getenv("SPARK_USER")).getOrElse((Function0 & Serializable & scala.Serializable)() -> UserGroupInformation.getCurrentUser().getShortUserName());
    }

    public Set<String> EMPTY_USER_GROUPS() {
        return this.EMPTY_USER_GROUPS;
    }

    public Set<String> getCurrentUserGroups(SparkConf sparkConf, String username) {
        String groupProviderClassName;
        String string = groupProviderClassName = sparkConf.get(UI$.MODULE$.USER_GROUPS_MAPPING());
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            try {
                GroupMappingServiceProvider groupMappingServiceProvider = (GroupMappingServiceProvider)this.classForName(groupProviderClassName, this.classForName$default$2(), this.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
                Set<String> currentUserGroups = groupMappingServiceProvider.getGroups(username);
                return currentUserGroups;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Error getting groups for user=").append(username).toString(), e);
            }
        }
        return this.EMPTY_USER_GROUPS();
    }

    public String[] parseStandaloneMasterUrls(String masterUrls) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(masterUrls)).stripPrefix("spark://").split(","))).map((Function1 & Serializable & scala.Serializable)x$19 -> new java.lang.StringBuilder(8).append("spark://").append((String)x$19).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String BACKUP_STANDALONE_MASTER_PREFIX() {
        return this.BACKUP_STANDALONE_MASTER_PREFIX;
    }

    public boolean responseFromBackup(String msg) {
        return msg.startsWith(this.BACKUP_STANDALONE_MASTER_PREFIX());
    }

    public <T> T withDummyCallSite(SparkContext sc, Function0<T> body2) {
        Object object;
        String oldShortCallSite = sc.getLocalProperty(CallSite$.MODULE$.SHORT_FORM());
        String oldLongCallSite = sc.getLocalProperty(CallSite$.MODULE$.LONG_FORM());
        try {
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), "");
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), "");
            object = body2.apply();
        }
        finally {
            sc.setLocalProperty(CallSite$.MODULE$.SHORT_FORM(), oldShortCallSite);
            sc.setLocalProperty(CallSite$.MODULE$.LONG_FORM(), oldLongCallSite);
        }
        return (T)object;
    }

    public boolean isInDirectory(File parent, File child) {
        while (child != null && parent != null) {
            if (!(child.exists() && parent.exists() && parent.isDirectory())) {
                return false;
            }
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public boolean isLocalMaster(SparkConf conf) {
        String master;
        String string = master = conf.get("spark.master", "");
        String string2 = "local";
        return !(string == null ? string2 != null : !string.equals(string2)) || master.startsWith("local[");
    }

    /*
     * Unable to fully structure code
     */
    public boolean isPushBasedShuffleEnabled(SparkConf conf, boolean isDriver, boolean checkSerializer) {
        block3: {
            pushBasedShuffleEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.PUSH_BASED_SHUFFLE_ENABLED()));
            if (!pushBasedShuffleEnabled) break block3;
            serializerIsSupported$lzy = new LazyBoolean();
            isTesting = BoxesRunTime.unboxToBoolean((Object)((Option)conf.get(Tests$.MODULE$.IS_TESTING())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$isPushBasedShuffleEnabled$1(), ()Z)()));
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) ** GOTO lbl-1000
            v0 = conf.get("spark.master", null);
            var9_7 = "yarn";
            if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            isShuffleServiceAndYarn = v1;
            ioEncryptionDisabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED())) == false;
            v2 = canDoPushBasedShuffle = (isShuffleServiceAndYarn != false || isTesting != false) && ioEncryptionDisabled != false && Utils$.serializerIsSupported$1(serializerIsSupported$lzy, checkSerializer, conf, isDriver) != false;
            if (!canDoPushBasedShuffle) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$isPushBasedShuffleEnabled$5(), ()Ljava/lang/String;)());
            }
            return canDoPushBasedShuffle;
        }
        return false;
    }

    public boolean isPushBasedShuffleEnabled$default$3() {
        return true;
    }

    public <T> T instantiateSerializerOrShuffleManager(String className, SparkConf conf, boolean isDriver) {
        Object c;
        Class cls = this.classForName(className, this.classForName$default$2(), this.classForName$default$3());
        try {
            c = cls.getConstructor(SparkConf.class, Boolean.TYPE).newInstance(conf, isDriver);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                c = cls.getConstructor(SparkConf.class).newInstance(conf);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                c = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        return (T)c;
    }

    public <T> T instantiateSerializerFromConf(ConfigEntry<String> propertyName, SparkConf conf, boolean isDriver) {
        return this.instantiateSerializerOrShuffleManager(conf.get(propertyName), conf, isDriver);
    }

    public boolean isDynamicAllocationEnabled(SparkConf conf) {
        boolean dynamicAllocationEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_ENABLED()));
        return dynamicAllocationEnabled && (!this.isLocalMaster(conf) || BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_TESTING())));
    }

    public boolean isStreamingDynamicAllocationEnabled(SparkConf conf) {
        boolean streamingDynamicAllocationEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_ENABLED()));
        return streamingDynamicAllocationEnabled && (!this.isLocalMaster(conf) || BoxesRunTime.unboxToBoolean((Object)conf.get(Streaming$.MODULE$.STREAMING_DYN_ALLOCATION_TESTING())));
    }

    public int getDynamicAllocationInitialExecutors(SparkConf conf) {
        if (BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(73).append(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key()).append(" less than ").append(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()).append(" is invalid, ignoring its setting, ").append("please update your configs.").toString());
        }
        if (BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) < BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(73).append(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()).append(" less than ").append(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()).append(" is invalid, ignoring its setting, ").append("please update your configs.").toString());
        }
        int initialExecutors = BoxesRunTime.unboxToInt((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS())), BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS())), BoxesRunTime.unboxToInt((Object)((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))}))).max((Ordering)Ordering.Int$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append("Using initial executors = ").append(initialExecutors).append(", max of ").append(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_INITIAL_EXECUTORS().key()).append(", ").append(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS().key()).append(" and ").append(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key()).toString());
        return initialExecutors;
    }

    public <R extends Closeable, T> T tryWithResource(Function0<R> createResource, Function1<R, T> f) {
        Object object;
        try (Closeable resource = (Closeable)createResource.apply();){
            object = f.apply((Object)resource);
        }
        return (T)object;
    }

    public File tempFileWith(File path) {
        return new File(new java.lang.StringBuilder(1).append(path.getAbsolutePath()).append(".").append(UUID.randomUUID()).toString());
    }

    public String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    public void initDaemon(Logger log) {
        log.info(new java.lang.StringBuilder(34).append("Started daemon with process name: ").append(this.getProcessName()).toString());
        SignalUtils$.MODULE$.registerLogger(log);
    }

    public Seq<String> getUserJars(SparkConf conf) {
        return (Seq)((TraversableLike)conf.get(org.apache.spark.internal.config.package$.MODULE$.JARS())).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getUserJars$1(x$22)));
    }

    public Seq<String> getLocalUserJarsForShell(SparkConf conf) {
        Option<String> localJars = conf.getOption("spark.repl.local.jars");
        return (Seq)Option$.MODULE$.option2Iterable(localJars.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.split(",")).map((Function1 & Serializable & scala.Serializable)x$24 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$24)).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$getLocalUserJarsForShell$3(x$25))))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
    }

    public String REDACTION_REPLACEMENT_TEXT() {
        return this.REDACTION_REPLACEMENT_TEXT;
    }

    public Seq<Tuple2<String, String>> redact(SparkConf conf, Seq<Tuple2<String, String>> kvs) {
        Regex redactionPattern = conf.get(org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN());
        return this.redact(redactionPattern, kvs);
    }

    public <K, V> Seq<Tuple2<K, V>> redact(Option<Regex> regex, Seq<Tuple2<K, V>> kvs) {
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            return kvs;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            return this.redact(r, kvs);
        }
        throw new MatchError(option);
    }

    public String redact(Option<Regex> regex, String text) {
        Option<Regex> option = regex;
        if (None$.MODULE$.equals(option)) {
            return text;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex r = (Regex)some.value();
            if (text == null || text.isEmpty()) {
                return text;
            }
            return r.replaceAllIn((CharSequence)text, this.REDACTION_REPLACEMENT_TEXT());
        }
        throw new MatchError(option);
    }

    private <K, V> Seq<Tuple2<K, V>> redact(Regex redactionPattern, Seq<Tuple2<K, V>> kvs) {
        return (Seq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (key instanceof String) {
                    String string = (String)key;
                    if (value instanceof String) {
                        String string2 = (String)value;
                        return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).orElse((Function0 & Serializable & scala.Serializable)() -> redactionPattern.findFirstIn((CharSequence)string2)).map((Function1 & Serializable & scala.Serializable)x$26 -> new Tuple2((Object)string, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)string, (Object)string2));
                    }
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                if (value instanceof String) {
                    String string = (String)value;
                    return (Tuple2)redactionPattern.findFirstIn((CharSequence)string).map((Function1 & Serializable & scala.Serializable)x$27 -> new Tuple2(key, (Object)MODULE$.REDACTION_REPLACEMENT_TEXT())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(key, (Object)string));
                }
            }
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return new Tuple2(key, value);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<String, String>> redact(Map<String, String> kvs) {
        Regex redactionPattern = new StringOps(Predef$.MODULE$.augmentString((String)kvs.getOrElse((Object)org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().key(), (Function0 & Serializable & scala.Serializable)() -> org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN().defaultValueString()))).r();
        return this.redact(redactionPattern, (Seq)Predef$.MODULE$.wrapRefArray((Object[])kvs.toArray(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public Seq<String> redactCommandLineArgs(SparkConf conf, Seq<String> commands) {
        Regex redactionPattern = conf.get(org.apache.spark.internal.config.package$.MODULE$.SECRET_REDACTION_PATTERN());
        return (Seq)commands.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Option option = MODULE$.PATTERN_FOR_COMMAND_LINE_ARG().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String value;
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                Tuple2 tuple2 = (Tuple2)MODULE$.redact(redactionPattern, (Seq)new .colon.colon((Object)new Tuple2((Object)key, (Object)(value = (String)((LinearSeqOptimized)option.get()).apply(1))), (List)Nil$.MODULE$)).head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String newValue = (String)tuple2._2();
                String newValue2 = newValue;
                return new java.lang.StringBuilder(3).append("-D").append(key).append("=").append(newValue2).toString();
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split(","))).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$stringToSeq$2(x$29))));
    }

    public <T> Seq<T> loadExtensions(Class<T> extClass, Seq<String> classes, SparkConf conf) {
        return (Seq)classes.flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Iterable iterable;
            try {
                Object object;
                Class klass = MODULE$.classForName((String)name, MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                Predef$.MODULE$.require(extClass.isAssignableFrom(klass), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append((String)name).append(" is not a subclass of ").append(extClass.getName()).append(".").toString());
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> klass.getConstructor(SparkConf.class));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Constructor ctor = (Constructor)success.value();
                    object = ctor.newInstance(conf);
                } else if (try_ instanceof Failure) {
                    object = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    throw new MatchError((Object)try_);
                }
                Object ext = object;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(ext));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SparkException(new java.lang.StringBuilder(412).append((String)name).append(" did not have a zero-argument constructor or a").append(" single-argument constructor that accepts SparkConf. Note: if the class is").append(" defined inside of another Scala class, then its constructors may accept an").append(" implicit parameter that references the enclosing class; in this case, you must").append(" define the class as a top-level class in order to prevent this extra").append(" parameter from breaking Spark's ability to find a valid constructor.").toString());
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof UnsupportedOperationException) {
                    UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("Extension ").append((String)name).append(" not being initialized.").toString(), unsupportedOperationException);
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("Extension ").append((String)name).append(" not being initialized.").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                if (throwable == null) {
                    throw e;
                }
                throw throwable;
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public String checkAndGetK8sMasterUrl(String rawMasterURL) {
        Predef$.MODULE$.require(rawMasterURL.startsWith("k8s://"), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$1(), ()Ljava/lang/String;)());
        masterWithoutK8sPrefix = rawMasterURL.substring("k8s://".length());
        if (!masterWithoutK8sPrefix.contains("://")) {
            resolvedURL = new java.lang.StringBuilder(8).append("https://").append(masterWithoutK8sPrefix).toString();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$2(java.lang.String ), ()Ljava/lang/String;)((String)resolvedURL));
            return new java.lang.StringBuilder(6).append("k8s://").append(resolvedURL).toString();
        }
        masterScheme = new URI(masterWithoutK8sPrefix).getScheme();
        var7_5 = false;
        var8_6 = null;
        var9_7 = Option$.MODULE$.apply((Object)masterScheme).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = (Some)var9_7;
        var10_8 = (String)var8_6.value();
        if ("https".equals(var10_8)) {
            v0 = masterWithoutK8sPrefix;
        } else if (var7_5 && "http".equals(var11_9 = (String)var8_6.value())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkAndGetK8sMasterUrl$4(), ()Ljava/lang/String;)());
            v0 = masterWithoutK8sPrefix;
        } else {
            throw new IllegalArgumentException(new java.lang.StringBuilder(49).append("Invalid Kubernetes master scheme: ").append(masterScheme).append(" found in URL: ").append(masterWithoutK8sPrefix).toString());
        }
        resolvedURL = v0;
        return new java.lang.StringBuilder(6).append("k8s://").append(resolvedURL).toString();
    }

    public String substituteAppNExecIds(String opt, String appId, String execId) {
        return opt.replace("{{APP_ID}}", appId).replace("{{EXECUTOR_ID}}", execId);
    }

    public String substituteAppId(String opt, String appId) {
        return opt.replace("{{APP_ID}}", appId);
    }

    public String createSecret(SparkConf conf) {
        int bits = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.AUTH_SECRET_BIT_LENGTH()));
        SecureRandom rnd = new SecureRandom();
        byte[] secretBytes = new byte[bits / 8];
        rnd.nextBytes(secretBytes);
        return Hex.encodeHexString((byte[])secretBytes);
    }

    public boolean isMemberClass(Class<?> cls) {
        boolean bl;
        block3: {
            try {
                bl = cls.isMemberClass();
            }
            catch (InternalError internalError) {
                if (cls.getEnclosingMethod() == null && cls.getEnclosingClass() != null) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public String getSimpleName(Class<?> cls) {
        String string;
        try {
            string = cls.getSimpleName();
        }
        catch (InternalError internalError) {
            string = this.stripDollars(this.stripPackages(cls.getName()));
        }
        return string;
    }

    private String stripPackages(String fullyQualifiedName) {
        return ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullyQualifiedName.split("\\."))).takeRight(1))[0];
    }

    public String stripDollars(String s) {
        Option option;
        while (true) {
            int lastDollarIndex;
            if ((lastDollarIndex = s.lastIndexOf(36)) < s.length() - 1) {
                if (lastDollarIndex == -1 || !s.contains("$iw")) {
                    return s;
                }
                return s.substring(lastDollarIndex + 1);
            }
            Option lastNonDollarChar = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s)).reverse())).find((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$stripDollars$1(BoxesRunTime.unboxToChar((Object)x$31))));
            option = lastNonDollarChar;
            if (None$.MODULE$.equals(option)) {
                return s;
            }
            if (!(option instanceof Some)) break;
            Some some = (Some)option;
            char c = BoxesRunTime.unboxToChar((Object)some.value());
            int lastNonDollarIndex = s.lastIndexOf(c);
            if (lastNonDollarIndex == -1) {
                return s;
            }
            s = s.substring(0, lastNonDollarIndex + 1);
        }
        throw new MatchError((Object)option);
    }

    private Regex fullWidthRegex() {
        return this.fullWidthRegex;
    }

    public int stringHalfWidth(String str) {
        if (str == null) {
            return 0;
        }
        return str.length() + this.fullWidthRegex().findAllIn((CharSequence)str).size();
    }

    public String sanitizeDirName(String str) {
        return str.replaceAll("[ :/]", "-").replaceAll("[.${}'\"]", "_").toLowerCase(Locale.ROOT);
    }

    public boolean isClientMode(SparkConf conf) {
        return "client".equals(conf.get("spark.submit.deployMode", "client"));
    }

    public boolean isLocalUri(String uri) {
        return uri.startsWith(new java.lang.StringBuilder(1).append(this.LOCAL_SCHEME()).append(":").toString());
    }

    public boolean isFileSplittable(Path path, CompressionCodecFactory codecFactory) {
        CompressionCodec codec = codecFactory.getCodec(path);
        return codec == null || codec instanceof SplittableCompressionCodec;
    }

    public Properties cloneProperties(Properties props) {
        if (props == null) {
            return props;
        }
        Properties resultProps = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> resultProps.put(k, v)));
        return resultProps;
    }

    public String buildLocationMetadata(Seq<Path> paths, int stopAppendingThreshold) {
        BoxedUnit boxedUnit;
        int index;
        StringBuilder metadata = new StringBuilder(new java.lang.StringBuilder(9).append("(").append(paths.length()).append(" paths)[").toString());
        for (index = 0; index < paths.length() && metadata.length() < stopAppendingThreshold; ++index) {
            Object object = index > 0 ? metadata.append(", ") : BoxedUnit.UNIT;
            metadata.append(((Path)paths.apply(index)).toString());
        }
        if (paths.length() > index) {
            Object object = index > 0 ? metadata.append(", ") : BoxedUnit.UNIT;
            boxedUnit = metadata.append("...");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        metadata.append("]");
        return metadata.toString();
    }

    public int executorOffHeapMemorySizeAsMb(SparkConf sparkConf) {
        int sizeInMB = this.memoryStringToMb(sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE()).toString());
        return (int)this.checkOffHeapEnabled(sparkConf, sizeInMB);
    }

    public long checkOffHeapEnabled(SparkConf sparkConf, long offHeapSize) {
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED()))) {
            Predef$.MODULE$.require(offHeapSize > 0L, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_SIZE().key()).append(" must be > 0 when ").append(org.apache.spark.internal.config.package$.MODULE$.MEMORY_OFFHEAP_ENABLED().key()).append(" == true").toString());
            return offHeapSize;
        }
        return 0L;
    }

    public String createFailedToGetTokenMessage(String serviceName, Throwable e) {
        String message = "Failed to get token from service %s due to %s. If %s is not used, set spark.security.credentials.%s.enabled to false.";
        return new StringOps(Predef$.MODULE$.augmentString(message)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceName, e, serviceName, serviceName}));
    }

    public Seq<File> unzipFilesFromFile(FileSystem fs, Path dfsZipFile, File localDir) {
        ArrayBuffer files = new ArrayBuffer();
        ZipInputStream in = new ZipInputStream((InputStream)fs.open(dfsZipFile));
        FileOutputStream out = null;
        try {
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String fileName = ((Object)localDir.toPath().resolve(entry.getName()).getFileName()).toString();
                    File outFile = new File(localDir, fileName);
                    files.$plus$eq((Object)outFile);
                    out = new FileOutputStream(outFile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    in.closeEntry();
                }
                entry = in.getNextEntry();
            }
            in.close();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(16).append("Unzipped from ").append(dfsZipFile).append("\n\t").append(files.mkString("\n\t")).toString());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
        }
        return files.toSeq();
    }

    public long median(long[] sizes, boolean alreadySorted) {
        int len = sizes.length;
        long[] sortedSize = alreadySorted ? sizes : (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(sizes)).sorted((Ordering)Ordering.Long$.MODULE$);
        int n = len;
        switch (n) {
            default: 
        }
        if (len % 2 == 0) {
            return package$.MODULE$.max((sortedSize[len / 2] + sortedSize[len / 2 - 1]) / 2L, 1L);
        }
        return package$.MODULE$.max(sortedSize[len / 2], 1L);
    }

    private boolean isG1GC$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isG1GC = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Class clazz = MODULE$.classForName("com.sun.management.HotSpotDiagnosticMXBean", MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                    Class vmOptionClazz = MODULE$.classForName("com.sun.management.VMOption", MODULE$.classForName$default$2(), MODULE$.classForName$default$3());
                    Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
                    Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
                    Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
                    Object useG1GCObject = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseG1GC");
                    String useG1GC = (String)valueMethod.invoke(useG1GCObject, new Object[0]);
                    return "true".equals(useG1GC);
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isG1GC;
    }

    public boolean isG1GC() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.isG1GC$lzycompute();
        }
        return this.isG1GC;
    }

    public static final /* synthetic */ ByteBuffer $anonfun$copyStreamUpTo$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$copyStreamUpTo$2(long maxSize$1, LongRef count$1, InputStream in$2, ChunkedByteBufferOutputStream out$4) {
        long bufSize = Math.min(8192L, maxSize$1);
        byte[] buf = new byte[(int)bufSize];
        int n = 0;
        while (n != -1 && count$1.elem < maxSize$1) {
            n = in$2.read(buf, 0, (int)Math.min(maxSize$1 - count$1.elem, bufSize));
            if (n == -1) continue;
            out$4.write(buf, 0, n);
            count$1.elem += (long)n;
        }
        return count$1.elem < maxSize$1;
    }

    public static final /* synthetic */ void $anonfun$copyFileStreamNIO$2(long bytesToCopy$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long expectedPos;
            long initialPos = tuple2._1$mcJ$sp();
            FileChannel outputFileChannel = (FileChannel)tuple2._2();
            long finalPos = outputFileChannel.position();
            Predef$.MODULE$.assert(finalPos == (expectedPos = initialPos + bytesToCopy$1), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(340).append("\n           |Current position ").append(finalPos).append(" do not equal to expected position ").append(expectedPos).append("\n           |after transferTo, please check your kernel version to see if it is 2.6.32,\n           |this is a kernel bug which will lead to unexpected behavior when using transferTo.\n           |You can set spark.file.transferTo = false to disable this NIO feature.\n         ").toString())).stripMargin());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$filesEqualRecursive$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            File f1 = (File)tuple2._1();
            File f2 = (File)tuple2._2();
            return MODULE$.filesEqualRecursive(f1, f2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getOrCreateLocalRootDirsImpl$1(String root) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new URI(root).getScheme() != null).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$3) {
        return x$3 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey1$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(80).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address$1.getHostAddress()).append("; using ").append(strippedAddress.getHostAddress()).append(" instead (on interface ").append(ni.getName()).append(")").toString());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set SPARK_LOCAL_IP if you need to bind to another address");
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)strippedAddress);
        }
    }

    private final Tuple2 setDefaultPortValue$1(String hostPort$2) {
        Tuple2 retval = new Tuple2((Object)hostPort$2, (Object)BoxesRunTime.boxToInteger((int)0));
        this.hostPortParseResults().put(hostPort$2, (Tuple2<String, Object>)retval);
        return retval;
    }

    public static final /* synthetic */ boolean $anonfun$doesDirectoryContainAnyNewFiles$1(long cutoffTimeInMillis$1, File x$6) {
        return x$6.lastModified() > cutoffTimeInMillis$1;
    }

    public static final /* synthetic */ boolean $anonfun$executeCommand$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final void log$1(String s) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> s);
    }

    private static final void appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    public static final /* synthetic */ void $anonfun$offsetBytes$2(LongRef sum$1, scala.collection.immutable.Map fileToLength$1, long endIndex$1, long startIndex$1, StringBuffer stringBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object object;
            File file = (File)tuple2._1();
            long fileLength = tuple2._2$mcJ$sp();
            long startIndexOfFile = sum$1.elem;
            long endIndexOfFile = sum$1.elem + BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("Processing file ").append(file).append(", ").append("with start index = ").append(startIndexOfFile).append(", end index = ").append(endIndex$1).toString());
            if (startIndex$1 <= startIndexOfFile && endIndex$1 >= endIndexOfFile) {
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, 0L, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file))));
            } else if (startIndex$1 > startIndexOfFile && startIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = startIndex$1 - startIndexOfFile;
                long effectiveEndIndex = package$.MODULE$.min(endIndex$1 - startIndexOfFile, BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file)));
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else if (endIndex$1 > startIndexOfFile && endIndex$1 < endIndexOfFile) {
                long effectiveStartIndex = package$.MODULE$.max(startIndex$1 - startIndexOfFile, 0L);
                long effectiveEndIndex = endIndex$1 - startIndexOfFile;
                object = stringBuffer$1.append(MODULE$.offsetBytes(file.getAbsolutePath(), fileLength, effectiveStartIndex, effectiveEndIndex));
            } else {
                object = BoxedUnit.UNIT;
            }
            sum$1.elem += BoxesRunTime.unboxToLong((Object)fileToLength$1.apply((Object)file));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(40).append("After processing file ").append(file).append(", string built is ").append(stringBuffer$1.toString()).toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void endWord$1(ArrayBuffer buf$1, StringBuilder curWord$1) {
        buf$1.$plus$eq((Object)curWord$1.toString());
        curWord$1.clear();
    }

    public static final /* synthetic */ boolean $anonfun$resolveURIs$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$nonLocalPaths$1(boolean windows$1, String p) {
        URI uri = MODULE$.resolveURI(p);
        String string = (String)Option$.MODULE$.apply((Object)uri.getScheme()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "file");
        Option option = MODULE$.windowsDrive().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && windows$1) {
            return false;
        }
        return !("local".equals(string) ? true : "file".equals(string));
    }

    public static final /* synthetic */ boolean $anonfun$loadDefaultSparkProperties$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadDefaultSparkProperties$2(SparkConf conf$2, String confFile) {
        ((IterableLike)MODULE$.getPropertiesFromFile(confFile).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$loadDefaultSparkProperties$3(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                conf$2.setIfMissing(k, v);
                return (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0 & Serializable & scala.Serializable)() -> v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateSparkConfigFromProperties$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("spark.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    public static final /* synthetic */ boolean $anonfun$getThreadDump$1(ThreadInfo x$13) {
        return x$13 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getThreadDump$2(ThreadInfo x0$1, ThreadInfo x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            boolean v2;
            ThreadInfo threadTrace1 = (ThreadInfo)tuple2._1();
            ThreadInfo threadTrace2 = (ThreadInfo)tuple2._2();
            boolean v1 = threadTrace1.getThreadName().contains("Executor task launch");
            boolean bl = v2 = threadTrace2.getThreadName().contains("Executor task launch");
            if (v1 == v2) {
                String name2;
                String name1 = threadTrace1.getThreadName().toLowerCase(Locale.ROOT);
                int nameCmpRes = name1.compareTo(name2 = threadTrace2.getThreadName().toLowerCase(Locale.ROOT));
                if (nameCmpRes == 0) {
                    return threadTrace1.getThreadId() < threadTrace2.getThreadId();
                }
                return nameCmpRes < 0;
            }
            return v1 > v2;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$sparkJavaOpts$1(Function1 filterKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return BoxesRunTime.unboxToBoolean((Object)filterKey$1.apply((Object)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$sparkJavaOpts$default$2$1(String x$16) {
        return true;
    }

    public static final /* synthetic */ int $anonfun$portMaxRetries$1(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$isPushBasedShuffleEnabled$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$isPushBasedShuffleEnabled$3(Serializer x$21) {
        return x$21 != null;
    }

    private static final /* synthetic */ boolean serializerIsSupported$lzycompute$1(LazyBoolean serializerIsSupported$lzy$1, boolean checkSerializer$1, SparkConf conf$4, boolean isDriver$1) {
        boolean bl;
        LazyBoolean lazyBoolean = serializerIsSupported$lzy$1;
        synchronized (lazyBoolean) {
            bl = serializerIsSupported$lzy$1.initialized() ? serializerIsSupported$lzy$1.value() : serializerIsSupported$lzy$1.initialize(checkSerializer$1 ? ((Serializer)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.serializer()).filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$isPushBasedShuffleEnabled$3(x$21))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Serializer)MODULE$.instantiateSerializerFromConf(org.apache.spark.internal.config.package$.MODULE$.SERIALIZER(), conf$4, isDriver$1))).supportsRelocationOfSerializedObjects() : true);
        }
        return bl;
    }

    private static final boolean serializerIsSupported$1(LazyBoolean serializerIsSupported$lzy$1, boolean checkSerializer$1, SparkConf conf$4, boolean isDriver$1) {
        if (serializerIsSupported$lzy$1.initialized()) {
            return serializerIsSupported$lzy$1.value();
        }
        return Utils$.serializerIsSupported$lzycompute$1(serializerIsSupported$lzy$1, checkSerializer$1, conf$4, isDriver$1);
    }

    public static final /* synthetic */ String $anonfun$isPushBasedShuffleEnabled$5() {
        return "Push-based shuffle can only be enabled when the application is submitted to run in YARN mode, with external shuffle service enabled, IO encryption disabled, and relocation of serialized objects supported.";
    }

    public static final /* synthetic */ boolean $anonfun$getUserJars$1(String x$22) {
        return new StringOps(Predef$.MODULE$.augmentString(x$22)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getLocalUserJarsForShell$3(String x$25) {
        return new StringOps(Predef$.MODULE$.augmentString(x$25)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$stringToSeq$2(String x$29) {
        return new StringOps(Predef$.MODULE$.augmentString(x$29)).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$1() {
        return "Kubernetes master URL must start with k8s://.";
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$2(String resolvedURL$1) {
        return new java.lang.StringBuilder(88).append("No scheme specified for kubernetes master URL, so defaulting to https. Resolved ").append("URL is ").append(resolvedURL$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$3(String x$30) {
        return x$30.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ String $anonfun$checkAndGetK8sMasterUrl$4() {
        return "Kubernetes master URL uses HTTP instead of HTTPS.";
    }

    public static final /* synthetic */ boolean $anonfun$stripDollars$1(char x$31) {
        return x$31 != '$';
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.random = new Random();
        this.sparkUncaughtExceptionHandler = new SparkUncaughtExceptionHandler(SparkUncaughtExceptionHandler$.MODULE$.$lessinit$greater$default$1());
        this.cachedLocalDir = "";
        this.DEFAULT_DRIVER_MEM_MB = (int)1024L;
        this.MAX_DIR_CREATION_ATTEMPTS = 10;
        this.localRootDirs = null;
        this.LOCAL_SCHEME = "local";
        this.weakStringInterner = Interners.newWeakInterner();
        this.PATTERN_FOR_COMMAND_LINE_ARG = new StringOps(Predef$.MODULE$.augmentString("-D(.+?)=(.+)")).r();
        this.COPY_BUFFER_LEN = 1024;
        this.copyBuffer = ThreadLocal.withInitial(() -> new byte[MODULE$.COPY_BUFFER_LEN()]);
        this.customHostname = scala.sys.package$.MODULE$.env().get((Object)"SPARK_LOCAL_HOSTNAME");
        this.hostPortParseResults = new ConcurrentHashMap();
        this.SPARK_CORE_CLASS_REGEX = new StringOps(Predef$.MODULE$.augmentString("^org\\.apache\\.spark(\\.api\\.java)?(\\.util)?(\\.rdd)?(\\.broadcast)?\\.[A-Z]")).r();
        this.SPARK_SQL_CLASS_REGEX = new StringOps(Predef$.MODULE$.augmentString("^org\\.apache\\.spark\\.sql.*")).r();
        this.compressedLogFileLengthCache = null;
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.isMacOnAppleSilicon = SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64");
        this.preferIPv6 = "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
        this.windowsDrive = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z])")).r();
        this.EMPTY_USER_GROUPS = Predef$.MODULE$.Set().empty();
        this.BACKUP_STANDALONE_MASTER_PREFIX = "Current state is not alive";
        this.REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
        this.fullWidthRegex = new StringOps(Predef$.MODULE$.augmentString("[\u1100-\u115f\u2e80-\ua4cf\uac00-\ud7a3\uf900-\ufaff\ufe10-\ufe19\ufe30-\ufe6f\uff00-\uff60\uffe0-\uffe6]")).r();
    }
}

