/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrivilegedOperationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PrivilegedOperationExecutor.class);
    private static volatile PrivilegedOperationExecutor instance;
    private String containerExecutorExe;

    public static String getContainerExecutorExecutablePath(Configuration conf) {
        String yarnHomeEnvVar = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
        File hadoopBin = new File(yarnHomeEnvVar, "bin");
        String defaultPath = new File(hadoopBin, "container-executor").getAbsolutePath();
        return null == conf ? defaultPath : conf.get("yarn.nodemanager.linux-container-executor.path", defaultPath);
    }

    private void init(Configuration conf) {
        this.containerExecutorExe = PrivilegedOperationExecutor.getContainerExecutorExecutablePath(conf);
    }

    private PrivilegedOperationExecutor(Configuration conf) {
        this.init(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrivilegedOperationExecutor getInstance(Configuration conf) {
        if (instance != null) return instance;
        Class<PrivilegedOperationExecutor> clazz = PrivilegedOperationExecutor.class;
        synchronized (PrivilegedOperationExecutor.class) {
            if (instance != null) return instance;
            instance = new PrivilegedOperationExecutor(conf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String[] getPrivilegedOperationExecutionCommand(List<String> prefixCommands, PrivilegedOperation operation) {
        ArrayList<String> fullCommand = new ArrayList<String>();
        if (prefixCommands != null && !prefixCommands.isEmpty()) {
            fullCommand.addAll(prefixCommands);
        }
        fullCommand.add(this.containerExecutorExe);
        String cliSwitch = operation.getOperationType().getOption();
        if (!cliSwitch.isEmpty()) {
            fullCommand.add(cliSwitch);
        }
        fullCommand.addAll(operation.getArguments());
        Object[] fullCommandArray = fullCommand.toArray(new String[fullCommand.size()]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Privileged Execution Command Array: " + Arrays.toString(fullCommandArray));
        }
        return fullCommandArray;
    }

    public String executePrivilegedOperation(List<String> prefixCommands, PrivilegedOperation operation, File workingDir, Map<String, String> env, boolean grabOutput, boolean inheritParentEnv) throws PrivilegedOperationException {
        Object[] fullCommandArray = this.getPrivilegedOperationExecutionCommand(prefixCommands, operation);
        Shell.ShellCommandExecutor exec = new Shell.ShellCommandExecutor((String[])fullCommandArray, workingDir, env, 0L, inheritParentEnv);
        try {
            exec.execute();
            if (LOG.isDebugEnabled()) {
                LOG.debug("command array:");
                LOG.debug(Arrays.toString(fullCommandArray));
                LOG.debug("Privileged Execution Operation Output:");
                LOG.debug(exec.getOutput());
            }
        }
        catch (Shell.ExitCodeException e) {
            if (operation.isFailureLoggingEnabled()) {
                StringBuilder logBuilder = new StringBuilder("Shell execution returned exit code: ").append(exec.getExitCode()).append(". Privileged Execution Operation Stderr: ").append(System.lineSeparator()).append(e.getMessage()).append(System.lineSeparator()).append("Stdout: " + exec.getOutput()).append(System.lineSeparator());
                logBuilder.append("Full command array for failed execution: ").append(System.lineSeparator());
                logBuilder.append(Arrays.toString(fullCommandArray));
                LOG.warn(logBuilder.toString());
            }
            throw new PrivilegedOperationException(e, e.getExitCode(), exec.getOutput(), e.getMessage());
        }
        catch (IOException e) {
            LOG.warn("IOException executing command: ", (Throwable)e);
            throw new PrivilegedOperationException(e);
        }
        if (grabOutput) {
            return exec.getOutput();
        }
        return null;
    }

    public String executePrivilegedOperation(PrivilegedOperation operation, boolean grabOutput) throws PrivilegedOperationException {
        return this.executePrivilegedOperation(null, operation, null, null, grabOutput, false);
    }

    public IOStreamPair executePrivilegedInteractiveOperation(List<String> prefixCommands, PrivilegedOperation operation) throws PrivilegedOperationException, InterruptedException {
        InputStream stdout;
        OutputStream stdin;
        Object[] fullCommandArray = this.getPrivilegedOperationExecutionCommand(prefixCommands, operation);
        ProcessBuilder pb = new ProcessBuilder((String[])fullCommandArray);
        try {
            pb.redirectErrorStream(true);
            Process p = pb.start();
            stdin = p.getOutputStream();
            stdout = p.getInputStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("command array:");
                LOG.debug(Arrays.toString(fullCommandArray));
            }
        }
        catch (Shell.ExitCodeException e) {
            if (operation.isFailureLoggingEnabled()) {
                StringBuilder logBuilder = new StringBuilder("Interactive Shell execution returned exit code: ").append(e.getExitCode()).append(". Privileged Interactive Operation Stderr: ").append(System.lineSeparator()).append(e.getMessage()).append(System.lineSeparator());
                logBuilder.append("Full command array for failed execution: ").append(System.lineSeparator());
                logBuilder.append(Arrays.toString(fullCommandArray));
                LOG.warn(logBuilder.toString());
            }
            throw new PrivilegedOperationException(e, e.getExitCode(), pb.redirectError().toString(), e.getMessage());
        }
        catch (IOException e) {
            LOG.warn("IOException executing command: ", (Throwable)e);
            throw new PrivilegedOperationException(e);
        }
        return new IOStreamPair(stdout, stdin);
    }

    public static PrivilegedOperation squashCGroupOperations(List<PrivilegedOperation> ops) throws PrivilegedOperationException {
        if (ops.size() == 0) {
            return null;
        }
        StringBuffer finalOpArg = new StringBuffer("cgroups=");
        boolean noTasks = true;
        for (PrivilegedOperation op : ops) {
            if (!op.getOperationType().equals((Object)PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP)) {
                LOG.warn("Unsupported operation type: " + (Object)((Object)op.getOperationType()));
                throw new PrivilegedOperationException("Unsupported operation type:" + (Object)((Object)op.getOperationType()));
            }
            List<String> args = op.getArguments();
            if (args.size() != 1) {
                LOG.warn("Invalid number of args: " + args.size());
                throw new PrivilegedOperationException("Invalid number of args: " + args.size());
            }
            String arg = args.get(0);
            String tasksFile = StringUtils.substringAfter((String)arg, (String)"cgroups=");
            if (tasksFile == null || tasksFile.isEmpty()) {
                LOG.warn("Invalid argument: " + arg);
                throw new PrivilegedOperationException("Invalid argument: " + arg);
            }
            if (tasksFile.equals("none")) continue;
            if (!noTasks) {
                finalOpArg.append('%');
                finalOpArg.append(tasksFile);
                continue;
            }
            finalOpArg.append(tasksFile);
            noTasks = false;
        }
        if (noTasks) {
            finalOpArg.append("none");
        }
        PrivilegedOperation finalOp = new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, finalOpArg.toString());
        return finalOp;
    }
}

