/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.runc;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.codehaus.jackson.annotate.JsonRawValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@InterfaceStability.Unstable
public class RuncContainerExecutorConfig {
    private final String version;
    private final String runAsUser;
    private final String username;
    private final String containerId;
    private final String applicationId;
    private final String pidFile;
    private final String containerScriptPath;
    private final String containerCredentialsPath;
    private final int https;
    private final String keystorePath;
    private final String truststorePath;
    private final List<String> localDirs;
    private final List<String> logDirs;
    private final List<OCILayer> layers;
    private final int reapLayerKeepCount;
    private final OCIRuntimeConfig ociRuntimeConfig;

    public String getVersion() {
        return this.version;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public String getUsername() {
        return this.username;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getPidFile() {
        return this.pidFile;
    }

    public String getContainerScriptPath() {
        return this.containerScriptPath;
    }

    public String getContainerCredentialsPath() {
        return this.containerCredentialsPath;
    }

    public int getHttps() {
        return this.https;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public List<String> getLocalDirs() {
        return this.localDirs;
    }

    public List<String> getLogDirs() {
        return this.logDirs;
    }

    public List<OCILayer> getLayers() {
        return this.layers;
    }

    public int getReapLayerKeepCount() {
        return this.reapLayerKeepCount;
    }

    public OCIRuntimeConfig getOciRuntimeConfig() {
        return this.ociRuntimeConfig;
    }

    public RuncContainerExecutorConfig() {
        this(null, null, null, null, null, null, null, null, 0, null, null, null, null, null, 0, null);
    }

    public RuncContainerExecutorConfig(String runAsUser, String username, String containerId, String applicationId, String pidFile, String containerScriptPath, String containerCredentialsPath, int https, String keystorePath, String truststorePath, List<String> localDirs, List<String> logDirs, List<OCILayer> layers, int reapLayerKeepCount, OCIRuntimeConfig ociRuntimeConfig) {
        this("0.1", runAsUser, username, containerId, applicationId, pidFile, containerScriptPath, containerCredentialsPath, https, keystorePath, truststorePath, localDirs, logDirs, layers, reapLayerKeepCount, ociRuntimeConfig);
    }

    public RuncContainerExecutorConfig(String version, String runAsUser, String username, String containerId, String applicationId, String pidFile, String containerScriptPath, String containerCredentialsPath, int https, String keystorePath, String truststorePath, List<String> localDirs, List<String> logDirs, List<OCILayer> layers, int reapLayerKeepCount, OCIRuntimeConfig ociRuntimeConfig) {
        this.version = version;
        this.runAsUser = runAsUser;
        this.username = username;
        this.containerId = containerId;
        this.applicationId = applicationId;
        this.pidFile = pidFile;
        this.containerScriptPath = containerScriptPath;
        this.containerCredentialsPath = containerCredentialsPath;
        this.https = https;
        this.keystorePath = keystorePath;
        this.truststorePath = truststorePath;
        this.localDirs = localDirs;
        this.logDirs = logDirs;
        this.layers = layers;
        this.reapLayerKeepCount = reapLayerKeepCount;
        this.ociRuntimeConfig = ociRuntimeConfig;
    }

    @InterfaceStability.Unstable
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public static class OCIRuntimeConfig {
        private final OCIRootConfig root;
        private final List<OCIMount> mounts;
        private final OCIProcessConfig process;
        private final OCIHooksConfig hooks;
        private final OCIAnnotationsConfig annotations;
        private final OCILinuxConfig linux;
        private final String hostname;

        public OCIRootConfig getRoot() {
            return this.root;
        }

        public List<OCIMount> getMounts() {
            return this.mounts;
        }

        public OCIProcessConfig getProcess() {
            return this.process;
        }

        public String getHostname() {
            return this.hostname;
        }

        public OCIHooksConfig getHooks() {
            return this.hooks;
        }

        public OCIAnnotationsConfig getAnnotations() {
            return this.annotations;
        }

        public OCILinuxConfig getLinux() {
            return this.linux;
        }

        public OCIRuntimeConfig() {
            this(null, null, null, null, null, null, null);
        }

        public OCIRuntimeConfig(OCIRootConfig root, List<OCIMount> mounts, OCIProcessConfig process, String hostname, OCIHooksConfig hooks, OCIAnnotationsConfig annotations, OCILinuxConfig linux) {
            this.root = root;
            this.mounts = mounts;
            this.process = process;
            this.hostname = hostname;
            this.hooks = hooks;
            this.annotations = annotations;
            this.linux = linux;
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
        public static class OCILinuxConfig {
            private final List<Namespace> namespaces;
            private final List<IDMapping> uidMappings;
            private final List<IDMapping> gidMappings;
            private final List<Device> devices;
            private final String cgroupsPath;
            private final Resources resources;
            private final IntelRdt intelRdt;
            private final Sysctl sysctl;
            @JsonRawValue
            private final String seccomp;
            private final String rootfsPropagation;
            private final List<String> maskedPaths;
            private final List<String> readonlyPaths;
            private final String mountLabel;

            public List<Namespace> getNamespaces() {
                return this.namespaces;
            }

            public List<IDMapping> getUidMappings() {
                return this.uidMappings;
            }

            public List<IDMapping> getGidMappings() {
                return this.gidMappings;
            }

            public List<Device> getDevices() {
                return this.devices;
            }

            public String getCgroupsPath() {
                return this.cgroupsPath;
            }

            public Resources getResources() {
                return this.resources;
            }

            public IntelRdt getIntelRdt() {
                return this.intelRdt;
            }

            public Sysctl getSysctl() {
                return this.sysctl;
            }

            public String getSeccomp() {
                return this.seccomp;
            }

            public String getRootfsPropagation() {
                return this.rootfsPropagation;
            }

            public List<String> getMaskedPaths() {
                return this.maskedPaths;
            }

            public List<String> getReadonlyPaths() {
                return this.readonlyPaths;
            }

            public String getMountLabel() {
                return this.mountLabel;
            }

            public OCILinuxConfig(List<Namespace> namespaces, List<IDMapping> uidMappings, List<IDMapping> gidMappings, List<Device> devices, String cgroupsPath, Resources resources, IntelRdt intelRdt, Sysctl sysctl, String seccomp, String rootfsPropagation, List<String> maskedPaths, List<String> readonlyPaths, String mountLabel) {
                this.namespaces = namespaces;
                this.uidMappings = uidMappings;
                this.gidMappings = gidMappings;
                this.devices = devices;
                this.cgroupsPath = cgroupsPath;
                this.resources = resources;
                this.intelRdt = intelRdt;
                this.sysctl = sysctl;
                this.seccomp = seccomp;
                this.rootfsPropagation = rootfsPropagation;
                this.maskedPaths = maskedPaths;
                this.readonlyPaths = readonlyPaths;
                this.mountLabel = mountLabel;
            }

            public OCILinuxConfig() {
                this(null, null, null, null, null, null, null, null, null, null, null, null, null);
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class Seccomp {
                private final String defaultAction;
                private final List<String> architectures;
                private final List<Syscall> syscalls;

                public String getDefaultAction() {
                    return this.defaultAction;
                }

                public List<String> getArchitectures() {
                    return this.architectures;
                }

                public List<Syscall> getSyscalls() {
                    return this.syscalls;
                }

                public Seccomp(String defaultAction, List<String> architectures, List<Syscall> syscalls) {
                    this.defaultAction = defaultAction;
                    this.architectures = architectures;
                    this.syscalls = syscalls;
                }

                public Seccomp() {
                    this(null, null, null);
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class Syscall {
                    private final List<String> names;
                    private final String action;
                    private final List<SeccompArg> args;

                    public List<String> getNames() {
                        return this.names;
                    }

                    public String getAction() {
                        return this.action;
                    }

                    public List<SeccompArg> getArgs() {
                        return this.args;
                    }

                    public Syscall(List<String> names, String action, List<SeccompArg> args) {
                        this.names = names;
                        this.action = action;
                        this.args = args;
                    }

                    public Syscall() {
                        this(null, null, null);
                    }

                    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                    public static class SeccompArg {
                        private final int index;
                        private final long value;
                        private final long valueTwo;
                        private final String op;

                        public int getIndex() {
                            return this.index;
                        }

                        public long getValue() {
                            return this.value;
                        }

                        public long getValueTwo() {
                            return this.valueTwo;
                        }

                        public String getOp() {
                            return this.op;
                        }

                        public SeccompArg(int index, long value, long valueTwo, String op) {
                            this.index = index;
                            this.value = value;
                            this.valueTwo = valueTwo;
                            this.op = op;
                        }

                        public SeccompArg() {
                            this(0, 0L, 0L, null);
                        }
                    }
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class Sysctl {
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class IntelRdt {
                private final String closID;
                private final String l3CacheSchema;
                private final String memBwSchema;

                public String getClosID() {
                    return this.closID;
                }

                public String getL3CacheSchema() {
                    return this.l3CacheSchema;
                }

                public String getMemBwSchema() {
                    return this.memBwSchema;
                }

                public IntelRdt(String closID, String l3CacheSchema, String memBwSchema) {
                    this.closID = closID;
                    this.l3CacheSchema = l3CacheSchema;
                    this.memBwSchema = memBwSchema;
                }

                public IntelRdt() {
                    this(null, null, null);
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class Resources {
                private final List<Device> device;
                private final Memory memory;
                private final CPU cpu;
                private final BlockIO blockIO;
                private final List<HugePageLimits> hugePageLimits;
                private final Network network;
                private final PID pid;
                private final RDMA rdma;

                public List<Device> getDevice() {
                    return this.device;
                }

                public Memory getMemory() {
                    return this.memory;
                }

                public CPU getCPU() {
                    return this.cpu;
                }

                public BlockIO getBlockIO() {
                    return this.blockIO;
                }

                public List<HugePageLimits> getHugePageLimits() {
                    return this.hugePageLimits;
                }

                public Network getNetwork() {
                    return this.network;
                }

                public PID getPID() {
                    return this.pid;
                }

                public RDMA getRDMA() {
                    return this.rdma;
                }

                public Resources(List<Device> device, Memory memory, CPU cpu, BlockIO blockIO, List<HugePageLimits> hugePageLimits, Network network, PID pid, RDMA rdma) {
                    this.device = device;
                    this.memory = memory;
                    this.cpu = cpu;
                    this.blockIO = blockIO;
                    this.hugePageLimits = hugePageLimits;
                    this.network = network;
                    this.pid = pid;
                    this.rdma = rdma;
                }

                public Resources() {
                    this(null, null, null, null, null, null, null, null);
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class RDMA {
                    private final int hcaHandles;
                    private final int hcaObjects;

                    public int getHcaHandles() {
                        return this.hcaHandles;
                    }

                    public int getHcaObjects() {
                        return this.hcaObjects;
                    }

                    public RDMA(int hcaHandles, int hcaObjects) {
                        this.hcaHandles = hcaHandles;
                        this.hcaObjects = hcaObjects;
                    }

                    public RDMA() {
                        this(0, 0);
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class PID {
                    private final long limit;

                    public long getLimit() {
                        return this.limit;
                    }

                    public PID(long limit) {
                        this.limit = limit;
                    }

                    public PID() {
                        this(0L);
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class Network {
                    private final int classID;
                    private final List<NetworkPriority> priorities;

                    public int getClassID() {
                        return this.classID;
                    }

                    public List<NetworkPriority> getPriorities() {
                        return this.priorities;
                    }

                    public Network(int classID, List<NetworkPriority> priorities) {
                        this.classID = classID;
                        this.priorities = priorities;
                    }

                    public Network() {
                        this(0, null);
                    }

                    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                    public static class NetworkPriority {
                        private final String name;
                        private final int priority;

                        public String getName() {
                            return this.name;
                        }

                        public int getPriority() {
                            return this.priority;
                        }

                        public NetworkPriority(String name, int priority) {
                            this.name = name;
                            this.priority = priority;
                        }

                        public NetworkPriority() {
                            this(null, 0);
                        }
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class HugePageLimits {
                    private final String pageSize;
                    private final long limit;

                    public String getPageSize() {
                        return this.pageSize;
                    }

                    public long getLimit() {
                        return this.limit;
                    }

                    public HugePageLimits(String pageSize, long limit) {
                        this.pageSize = pageSize;
                        this.limit = limit;
                    }

                    public HugePageLimits() {
                        this(null, 0L);
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class BlockIO {
                    private final int weight;
                    private final int leafWeight;
                    private final List<WeightDevice> weightDevices;
                    private final List<ThrottleDevice> throttleReadBpsDevice;
                    private final List<ThrottleDevice> throttleWriteBpsDevice;
                    private final List<ThrottleDevice> throttleReadIOPSDevice;
                    private final List<ThrottleDevice> throttleWriteIOPSDevice;

                    public int getWeight() {
                        return this.weight;
                    }

                    public int getLeafWeight() {
                        return this.leafWeight;
                    }

                    public List<WeightDevice> getWeightDevices() {
                        return this.weightDevices;
                    }

                    public List<ThrottleDevice> getThrottleReadBpsDevice() {
                        return this.throttleReadBpsDevice;
                    }

                    public List<ThrottleDevice> getThrottleWriteBpsDevice() {
                        return this.throttleWriteBpsDevice;
                    }

                    public List<ThrottleDevice> getThrottleReadIOPSDevice() {
                        return this.throttleReadIOPSDevice;
                    }

                    public List<ThrottleDevice> getThrottleWriteIOPSDevice() {
                        return this.throttleWriteIOPSDevice;
                    }

                    public BlockIO(int weight, int leafWeight, List<WeightDevice> weightDevices, List<ThrottleDevice> throttleReadBpsDevice, List<ThrottleDevice> throttleWriteBpsDevice, List<ThrottleDevice> throttleReadIOPSDevice, List<ThrottleDevice> throttleWriteIOPSDevice) {
                        this.weight = weight;
                        this.leafWeight = leafWeight;
                        this.weightDevices = weightDevices;
                        this.throttleReadBpsDevice = throttleReadBpsDevice;
                        this.throttleWriteBpsDevice = throttleWriteBpsDevice;
                        this.throttleReadIOPSDevice = throttleReadIOPSDevice;
                        this.throttleWriteIOPSDevice = throttleWriteIOPSDevice;
                    }

                    public BlockIO() {
                        this(0, 0, null, null, null, null, null);
                    }

                    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                    public static class ThrottleDevice {
                        private final long major;
                        private final long minor;
                        private final long rate;

                        public long getMajor() {
                            return this.major;
                        }

                        public long getMinor() {
                            return this.minor;
                        }

                        public long getRate() {
                            return this.rate;
                        }

                        public ThrottleDevice(long major, long minor, long rate) {
                            this.major = major;
                            this.minor = minor;
                            this.rate = rate;
                        }

                        public ThrottleDevice() {
                            this(0L, 0L, 0L);
                        }
                    }

                    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                    public static class WeightDevice {
                        private final long major;
                        private final long minor;
                        private final int weight;
                        private final int leafWeight;

                        public long getMajor() {
                            return this.major;
                        }

                        public long getMinor() {
                            return this.minor;
                        }

                        public int getWeight() {
                            return this.weight;
                        }

                        public int getLeafWeight() {
                            return this.leafWeight;
                        }

                        public WeightDevice(long major, long minor, int weight, int leafWeight) {
                            this.major = major;
                            this.minor = minor;
                            this.weight = weight;
                            this.leafWeight = leafWeight;
                        }

                        public WeightDevice() {
                            this(0L, 0L, 0, 0);
                        }
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class CPU {
                    private final long quota;
                    private final long period;
                    private final long realtimeRuntime;
                    private final long realtimePeriod;
                    private final String cpus;
                    private final String mems;
                    private final long shares;

                    public long getShares() {
                        return this.shares;
                    }

                    public long getQuota() {
                        return this.quota;
                    }

                    public long getPeriod() {
                        return this.period;
                    }

                    public long getRealtimeRuntime() {
                        return this.realtimeRuntime;
                    }

                    public long getRealtimePeriod() {
                        return this.realtimePeriod;
                    }

                    public String getCpus() {
                        return this.cpus;
                    }

                    public String getMems() {
                        return this.mems;
                    }

                    public CPU(long shares, long quota, long period, long realtimeRuntime, long realtimePeriod, String cpus, String mems) {
                        this.shares = shares;
                        this.quota = quota;
                        this.period = period;
                        this.realtimeRuntime = realtimeRuntime;
                        this.realtimePeriod = realtimePeriod;
                        this.cpus = cpus;
                        this.mems = mems;
                    }

                    public CPU() {
                        this(0L, 0L, 0L, 0L, 0L, null, null);
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class Memory {
                    private final long limit;
                    private final long reservation;
                    private final long swap;
                    private final long kernel;
                    private final long kernelTCP;
                    private final long swappiness;
                    private final boolean disableOOMKiller;

                    public long getLimit() {
                        return this.limit;
                    }

                    public long getReservation() {
                        return this.reservation;
                    }

                    public long getSwap() {
                        return this.swap;
                    }

                    public long getKernel() {
                        return this.kernel;
                    }

                    public long getKernelTCP() {
                        return this.kernelTCP;
                    }

                    public long getSwappiness() {
                        return this.swappiness;
                    }

                    public boolean isDisableOOMKiller() {
                        return this.disableOOMKiller;
                    }

                    public Memory(long limit, long reservation, long swap, long kernel, long kernelTCP, long swappiness, boolean disableOOMKiller) {
                        this.limit = limit;
                        this.reservation = reservation;
                        this.swap = swap;
                        this.kernel = kernel;
                        this.kernelTCP = kernelTCP;
                        this.swappiness = swappiness;
                        this.disableOOMKiller = disableOOMKiller;
                    }

                    public Memory() {
                        this(0L, 0L, 0L, 0L, 0L, 0L, false);
                    }
                }

                @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
                public static class Device {
                    private final boolean allow;
                    private final String type;
                    private final long major;
                    private final long minor;
                    private final String access;

                    public boolean isAllow() {
                        return this.allow;
                    }

                    public String getType() {
                        return this.type;
                    }

                    public long getMajor() {
                        return this.major;
                    }

                    public long getMinor() {
                        return this.minor;
                    }

                    public String getAccess() {
                        return this.access;
                    }

                    public Device(boolean allow, String type, long major, long minor, String access) {
                        this.allow = allow;
                        this.type = type;
                        this.major = major;
                        this.minor = minor;
                        this.access = access;
                    }

                    public Device() {
                        this(false, null, 0L, 0L, null);
                    }
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class Device {
                private final String type;
                private final String path;
                private final long major;
                private final long minor;
                private final int fileMode;
                private final int uid;
                private final int gid;

                public String getType() {
                    return this.type;
                }

                public String getPath() {
                    return this.path;
                }

                public long getMajor() {
                    return this.major;
                }

                public long getMinor() {
                    return this.minor;
                }

                public int getFileMode() {
                    return this.fileMode;
                }

                public int getUid() {
                    return this.uid;
                }

                public int getGid() {
                    return this.gid;
                }

                public Device(String type, String path, long major, long minor, int fileMode, int uid, int gid) {
                    this.type = type;
                    this.path = path;
                    this.major = major;
                    this.minor = minor;
                    this.fileMode = fileMode;
                    this.uid = uid;
                    this.gid = gid;
                }

                public Device() {
                    this(null, null, 0L, 0L, 0, 0, 0);
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class IDMapping {
                private final int containerID;
                private final int hostID;
                private final int size;

                public int getContainerID() {
                    return this.containerID;
                }

                public int getHostID() {
                    return this.hostID;
                }

                public int getSize() {
                    return this.size;
                }

                public IDMapping(int containerID, int hostID, int size) {
                    this.containerID = containerID;
                    this.hostID = hostID;
                    this.size = size;
                }

                public IDMapping() {
                    this(0, 0, 0);
                }
            }

            public static class Namespace {
                private final String type;
                private final String path;

                public Namespace(String type, String path) {
                    this.type = type;
                    this.path = path;
                }

                public Namespace() {
                    this(null, null);
                }
            }
        }

        public static class OCIAnnotationsConfig {
            private final Map<String, String> annotations;

            public OCIAnnotationsConfig(Map<String, String> annotations) {
                this.annotations = annotations;
            }

            public Map<String, String> getAnnotations() {
                return this.annotations;
            }

            public OCIAnnotationsConfig() {
                this(null);
            }
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
        public static class OCIHooksConfig {
            private final List<HookType> prestart;
            private final List<HookType> poststart;
            private final List<HookType> poststop;

            public List<HookType> getPrestart() {
                return this.prestart;
            }

            public List<HookType> getPoststart() {
                return this.poststart;
            }

            public List<HookType> getPoststop() {
                return this.poststop;
            }

            public OCIHooksConfig(List<HookType> prestart, List<HookType> poststart, List<HookType> poststop) {
                this.prestart = prestart;
                this.poststart = poststart;
                this.poststop = poststop;
            }

            public OCIHooksConfig() {
                this(null, null, null);
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class HookType {
                private final String path;
                private final List<String> args;
                private final List<String> env;
                private final int timeout;

                public String getPath() {
                    return this.path;
                }

                public List<String> getArgs() {
                    return this.args;
                }

                public List<String> getEnv() {
                    return this.env;
                }

                public int getTimeout() {
                    return this.timeout;
                }

                public HookType(String path, List<String> args, List<String> env, int timeout) {
                    this.path = path;
                    this.args = args;
                    this.env = env;
                    this.timeout = timeout;
                }

                public HookType() {
                    this(null, null, null, 0);
                }
            }
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
        public static class OCIProcessConfig {
            private final boolean terminal;
            private final ConsoleSize consoleSize;
            private final String cwd;
            private final List<String> env;
            private final List<String> args;
            private final RLimits rlimits;
            private final String apparmorProfile;
            private final Capabilities capabilities;
            private final boolean noNewPrivileges;
            private final int oomScoreAdj;
            private final String selinuxLabel;
            private final User user;

            public boolean isTerminal() {
                return this.terminal;
            }

            public ConsoleSize getConsoleSize() {
                return this.consoleSize;
            }

            public String getCwd() {
                return this.cwd;
            }

            public List<String> getEnv() {
                return this.env;
            }

            public List<String> getArgs() {
                return this.args;
            }

            public RLimits getRlimits() {
                return this.rlimits;
            }

            public String getApparmorProfile() {
                return this.apparmorProfile;
            }

            public Capabilities getCapabilities() {
                return this.capabilities;
            }

            public boolean isNoNewPrivileges() {
                return this.noNewPrivileges;
            }

            public int getOomScoreAdj() {
                return this.oomScoreAdj;
            }

            public String getSelinuxLabel() {
                return this.selinuxLabel;
            }

            public User getUser() {
                return this.user;
            }

            public OCIProcessConfig(boolean terminal, ConsoleSize consoleSize, String cwd, List<String> env, List<String> args, RLimits rlimits, String apparmorProfile, Capabilities capabilities, boolean noNewPrivileges, int oomScoreAdj, String selinuxLabel, User user) {
                this.terminal = terminal;
                this.consoleSize = consoleSize;
                this.cwd = cwd;
                this.env = env;
                this.args = args;
                this.rlimits = rlimits;
                this.apparmorProfile = apparmorProfile;
                this.capabilities = capabilities;
                this.noNewPrivileges = noNewPrivileges;
                this.oomScoreAdj = oomScoreAdj;
                this.selinuxLabel = selinuxLabel;
                this.user = user;
            }

            public OCIProcessConfig() {
                this(false, null, null, null, null, null, null, null, false, 0, null, null);
            }

            public static class User {
                private final int uid;
                private final int gid;
                private final List<Integer> additionalGids;

                public User(int uid, int gid, List<Integer> additionalGids) {
                    this.uid = uid;
                    this.gid = gid;
                    this.additionalGids = additionalGids;
                }

                public User() {
                    this(0, 0, null);
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class Capabilities {
                private final List<String> effective;
                private final List<String> bounding;
                private final List<String> inheritable;
                private final List<String> permitted;
                private final List<String> ambient;

                public List<String> getEffective() {
                    return this.effective;
                }

                public List<String> getBounding() {
                    return this.bounding;
                }

                public List<String> getInheritable() {
                    return this.inheritable;
                }

                public List<String> getPermitted() {
                    return this.permitted;
                }

                public List<String> getAmbient() {
                    return this.ambient;
                }

                public Capabilities(List<String> effective, List<String> bounding, List<String> inheritable, List<String> permitted, List<String> ambient) {
                    this.effective = effective;
                    this.bounding = bounding;
                    this.inheritable = inheritable;
                    this.permitted = permitted;
                    this.ambient = ambient;
                }

                public Capabilities() {
                    this(null, null, null, null, null);
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class RLimits {
                private final String type;
                private final long soft;
                private final long hard;

                public String getType() {
                    return this.type;
                }

                public long getSoft() {
                    return this.soft;
                }

                public long getHard() {
                    return this.hard;
                }

                public RLimits(String type, long soft, long hard) {
                    this.type = type;
                    this.soft = soft;
                    this.hard = hard;
                }

                public RLimits() {
                    this(null, 0L, 0L);
                }
            }

            @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
            public static class ConsoleSize {
                private final int height;
                private final int width;

                public int getHeight() {
                    return this.height;
                }

                public int getWidth() {
                    return this.width;
                }

                public ConsoleSize(int height, int width) {
                    this.height = height;
                    this.width = width;
                }

                public ConsoleSize() {
                    this(0, 0);
                }
            }
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
        public static class OCIMount {
            private final String destination;
            private final String type;
            private final String source;
            private final List<String> options;

            public String getDestination() {
                return this.destination;
            }

            public String getType() {
                return this.type;
            }

            public String getSource() {
                return this.source;
            }

            public List<String> getOptions() {
                return this.options;
            }

            public OCIMount(String destination, String type, String source, List<String> options) {
                this.destination = destination;
                this.type = type;
                this.source = source;
                this.options = options;
            }

            public OCIMount(String destination, String source, List<String> options) {
                this.destination = destination;
                this.type = null;
                this.source = source;
                this.options = options;
            }

            public OCIMount() {
                this(null, null, null, null);
            }
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
        public static class OCIRootConfig {
            private final String path;
            private final boolean readonly;

            public String getPath() {
                return this.path;
            }

            public boolean isReadonly() {
                return this.readonly;
            }

            public OCIRootConfig(String path, boolean readonly) {
                this.path = path;
                this.readonly = readonly;
            }

            public OCIRootConfig() {
                this(null, false);
            }
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    @InterfaceStability.Unstable
    public static class OCILayer {
        private final String mediaType;
        private final String path;

        public String getMediaType() {
            return this.mediaType;
        }

        public String getPath() {
            return this.path;
        }

        public OCILayer(String mediaType, String path) {
            this.mediaType = mediaType;
            this.path = path;
        }

        public OCILayer() {
            this(null, null);
        }
    }
}

