/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import org.apache.hadoop.yarn.exceptions.YarnException;

public final class GpuDeviceSpecificationException
extends YarnException {
    private static final String VALID_FORMAT_MESSAGE = "The valid format should be: index:minor_number";

    private GpuDeviceSpecificationException(String message) {
        super(message);
    }

    private GpuDeviceSpecificationException(String message, Exception cause) {
        super(message, (Throwable)cause);
    }

    public static GpuDeviceSpecificationException createWithEmptyValueSpecified() {
        return new GpuDeviceSpecificationException("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices is set to an empty value! Please specify auto to enable auto-discovery or please enter the GPU device IDs manually! The valid format should be: index:minor_number");
    }

    public static GpuDeviceSpecificationException createWithWrongValueSpecified(String device, String configValue, Exception cause) {
        String message = GpuDeviceSpecificationException.createIllegalFormatMessage(device, configValue);
        return new GpuDeviceSpecificationException(message, cause);
    }

    public static GpuDeviceSpecificationException createWithWrongValueSpecified(String device, String configValue) {
        String message = GpuDeviceSpecificationException.createIllegalFormatMessage(device, configValue);
        return new GpuDeviceSpecificationException(message);
    }

    public static GpuDeviceSpecificationException createWithDuplicateValueSpecified(String device, String configValue) {
        String message = GpuDeviceSpecificationException.createDuplicateFormatMessage(device, configValue);
        return new GpuDeviceSpecificationException(message);
    }

    private static String createIllegalFormatMessage(String device, String configValue) {
        return String.format("Illegal format of individual GPU device: %s, the whole config value was: '%s'! The valid format should be: index:minor_number", device, configValue);
    }

    private static String createDuplicateFormatMessage(String device, String configValue) {
        return String.format("GPU device %s has a duplicate definition! Please double-check the configuration yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices! Current value of the configuration is: %s", device, configValue);
    }
}

