/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.metrics;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeFloat;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Resource;

@Metrics(about="Metrics for node manager", context="yarn")
public class NodeManagerMetrics {
    @Metric
    MutableCounterInt containersLaunched;
    @Metric
    MutableCounterInt containersCompleted;
    @Metric
    MutableCounterInt containersFailed;
    @Metric
    MutableCounterInt containersKilled;
    @Metric
    MutableCounterInt containersRolledBackOnFailure;
    @Metric(value={"# of reInitializing containers"})
    MutableGaugeInt containersReIniting;
    @Metric(value={"# of initializing containers"})
    MutableGaugeInt containersIniting;
    @Metric
    MutableGaugeInt containersRunning;
    @Metric(value={"# of paused containers"})
    MutableGaugeInt containersPaused;
    @Metric(value={"Current allocated memory in GB"})
    MutableGaugeInt allocatedGB;
    @Metric(value={"Current # of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric
    MutableGaugeInt availableGB;
    @Metric(value={"Current allocated Virtual Cores"})
    MutableGaugeInt allocatedVCores;
    @Metric
    MutableGaugeInt availableVCores;
    @Metric(value={"Container launch duration"})
    MutableRate containerLaunchDuration;
    @Metric(value={"Containers queued (Guaranteed)"})
    MutableGaugeInt containersGuaranteedQueued;
    @Metric(value={"Containers queued (Opportunistic)"})
    MutableGaugeInt containersOpportunisticQueued;
    @Metric(value={"# of bad local dirs"})
    MutableGaugeInt badLocalDirs;
    @Metric(value={"# of bad log dirs"})
    MutableGaugeInt badLogDirs;
    @Metric(value={"Disk utilization % on good local dirs"})
    MutableGaugeInt goodLocalDirsDiskUtilizationPerc;
    @Metric(value={"Disk utilization % on good log dirs"})
    MutableGaugeInt goodLogDirsDiskUtilizationPerc;
    @Metric(value={"Current allocated memory by opportunistic containers in GB"})
    MutableGaugeLong allocatedOpportunisticGB;
    @Metric(value={"Current allocated Virtual Cores by opportunistic containers"})
    MutableGaugeInt allocatedOpportunisticVCores;
    @Metric(value={"# of running opportunistic containers"})
    MutableGaugeInt runningOpportunisticContainers;
    @Metric(value={"Local cache size (public and private) before clean (Bytes)"})
    MutableGaugeLong cacheSizeBeforeClean;
    @Metric(value={"# of total bytes deleted from the public and private local cache"})
    MutableGaugeLong totalBytesDeleted;
    @Metric(value={"# of bytes deleted from the public local cache"})
    MutableGaugeLong publicBytesDeleted;
    @Metric(value={"# of bytes deleted from the private local cache"})
    MutableGaugeLong privateBytesDeleted;
    @Metric(value={"Current used physical memory by all containers in GB"})
    MutableGaugeInt containerUsedMemGB;
    @Metric(value={"Current used virtual memory by all containers in GB"})
    MutableGaugeInt containerUsedVMemGB;
    @Metric(value={"Aggregated CPU utilization of all containers"})
    MutableGaugeFloat containerCpuUtilization;
    @Metric(value={"Current used memory by this node in GB"})
    MutableGaugeInt nodeUsedMemGB;
    @Metric(value={"Current used virtual memory by this node in GB"})
    MutableGaugeInt nodeUsedVMemGB;
    @Metric(value={"Current CPU utilization"})
    MutableGaugeFloat nodeCpuUtilization;
    @Metric(value={"Current GPU utilization"})
    MutableGaugeFloat nodeGpuUtilization;
    @Metric(value={"Current running apps"})
    MutableGaugeInt applicationsRunning;
    @Metric(value={"Missed localization requests in bytes"})
    MutableCounterLong localizedCacheMissBytes;
    @Metric(value={"Cached localization requests in bytes"})
    MutableCounterLong localizedCacheHitBytes;
    @Metric(value={"Localization cache hit ratio (bytes)"})
    MutableGaugeInt localizedCacheHitBytesRatio;
    @Metric(value={"Missed localization requests (files)"})
    MutableCounterLong localizedCacheMissFiles;
    @Metric(value={"Cached localization requests (files)"})
    MutableCounterLong localizedCacheHitFiles;
    @Metric(value={"Localization cache hit ratio (files)"})
    MutableGaugeInt localizedCacheHitFilesRatio;
    @Metric(value={"Container localization time in milliseconds"})
    MutableRate localizationDurationMillis;
    private JvmMetrics jvmMetrics = null;
    private long allocatedMB;
    private long availableMB;
    private long allocatedOpportunisticMB;

    private NodeManagerMetrics(JvmMetrics jvmMetrics) {
        this.jvmMetrics = jvmMetrics;
    }

    public static NodeManagerMetrics create() {
        return NodeManagerMetrics.create(DefaultMetricsSystem.instance());
    }

    private static NodeManagerMetrics create(MetricsSystem ms) {
        JvmMetrics jm = JvmMetrics.initSingleton((String)"NodeManager", null);
        return (NodeManagerMetrics)ms.register((Object)new NodeManagerMetrics(jm));
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void launchedContainer() {
        this.containersLaunched.incr();
    }

    public void completedContainer() {
        this.containersCompleted.incr();
    }

    public void rollbackContainerOnFailure() {
        this.containersRolledBackOnFailure.incr();
    }

    public void failedContainer() {
        this.containersFailed.incr();
    }

    public void killedContainer() {
        this.containersKilled.incr();
    }

    public void initingContainer() {
        this.containersIniting.incr();
    }

    public void endInitingContainer() {
        this.containersIniting.decr();
    }

    public void runningContainer() {
        this.containersRunning.incr();
    }

    public void endRunningContainer() {
        this.containersRunning.decr();
    }

    public void reInitingContainer() {
        this.containersReIniting.incr();
    }

    public void endReInitingContainer() {
        this.containersReIniting.decr();
    }

    public void runningApplication() {
        this.applicationsRunning.incr();
    }

    public void endRunningApplication() {
        this.applicationsRunning.decr();
    }

    public void pausedContainer() {
        this.containersPaused.incr();
    }

    public void endPausedContainer() {
        this.containersPaused.decr();
    }

    public void allocateContainer(Resource res) {
        this.allocatedContainers.incr();
        this.allocatedMB += res.getMemorySize();
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB -= res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.incr(res.getVirtualCores());
        this.availableVCores.decr(res.getVirtualCores());
    }

    public void releaseContainer(Resource res) {
        this.allocatedContainers.decr();
        this.allocatedMB -= res.getMemorySize();
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB += res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.decr(res.getVirtualCores());
        this.availableVCores.incr(res.getVirtualCores());
    }

    public void changeContainer(Resource before, Resource now) {
        long deltaMB = now.getMemorySize() - before.getMemorySize();
        int deltaVCores = now.getVirtualCores() - before.getVirtualCores();
        this.allocatedMB += deltaMB;
        this.allocatedGB.set((int)Math.ceil((double)this.allocatedMB / 1024.0));
        this.availableMB -= deltaMB;
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.allocatedVCores.incr(deltaVCores);
        this.availableVCores.decr(deltaVCores);
    }

    public void startOpportunisticContainer(Resource res) {
        this.runningOpportunisticContainers.incr();
        this.allocatedOpportunisticMB += res.getMemorySize();
        this.allocatedOpportunisticGB.set((long)((int)Math.ceil((double)this.allocatedOpportunisticMB / 1024.0)));
        this.allocatedOpportunisticVCores.incr(res.getVirtualCores());
    }

    public void completeOpportunisticContainer(Resource res) {
        this.runningOpportunisticContainers.decr();
        this.allocatedOpportunisticMB -= res.getMemorySize();
        this.allocatedOpportunisticGB.set((long)((int)Math.ceil((double)this.allocatedOpportunisticMB / 1024.0)));
        this.allocatedOpportunisticVCores.decr(res.getVirtualCores());
    }

    public void setQueuedContainers(int opportunisticCount, int guaranteedCount) {
        this.containersOpportunisticQueued.set(opportunisticCount);
        this.containersGuaranteedQueued.set(guaranteedCount);
    }

    public void addResource(Resource res) {
        this.availableMB += res.getMemorySize();
        this.availableGB.set((int)Math.floor((double)this.availableMB / 1024.0));
        this.availableVCores.incr(res.getVirtualCores());
    }

    public void addContainerLaunchDuration(long value) {
        this.containerLaunchDuration.add(value);
    }

    public void setBadLocalDirs(int badLocalDirs) {
        this.badLocalDirs.set(badLocalDirs);
    }

    public void setBadLogDirs(int badLogDirs) {
        this.badLogDirs.set(badLogDirs);
    }

    public void setGoodLocalDirsDiskUtilizationPerc(int goodLocalDirsDiskUtilizationPerc) {
        this.goodLocalDirsDiskUtilizationPerc.set(goodLocalDirsDiskUtilizationPerc);
    }

    public void setGoodLogDirsDiskUtilizationPerc(int goodLogDirsDiskUtilizationPerc) {
        this.goodLogDirsDiskUtilizationPerc.set(goodLogDirsDiskUtilizationPerc);
    }

    public void setCacheSizeBeforeClean(long cacheSizeBeforeClean) {
        this.cacheSizeBeforeClean.set(cacheSizeBeforeClean);
    }

    public void setTotalBytesDeleted(long totalBytesDeleted) {
        this.totalBytesDeleted.set(totalBytesDeleted);
    }

    public void setPublicBytesDeleted(long publicBytesDeleted) {
        this.publicBytesDeleted.set(publicBytesDeleted);
    }

    public void setPrivateBytesDeleted(long privateBytesDeleted) {
        this.privateBytesDeleted.set(privateBytesDeleted);
    }

    public int getRunningContainers() {
        return this.containersRunning.value();
    }

    public int getPausedContainers() {
        return this.containersPaused.value();
    }

    @VisibleForTesting
    public int getKilledContainers() {
        return this.containersKilled.value();
    }

    @VisibleForTesting
    public int getFailedContainers() {
        return this.containersFailed.value();
    }

    @VisibleForTesting
    public int getCompletedContainers() {
        return this.containersCompleted.value();
    }

    @VisibleForTesting
    public int getBadLogDirs() {
        return this.badLogDirs.value();
    }

    @VisibleForTesting
    public int getBadLocalDirs() {
        return this.badLocalDirs.value();
    }

    @VisibleForTesting
    public int getGoodLogDirsDiskUtilizationPerc() {
        return this.goodLogDirsDiskUtilizationPerc.value();
    }

    @VisibleForTesting
    public int getGoodLocalDirsDiskUtilizationPerc() {
        return this.goodLocalDirsDiskUtilizationPerc.value();
    }

    @VisibleForTesting
    public int getReInitializingContainer() {
        return this.containersReIniting.value();
    }

    @VisibleForTesting
    public int getContainersRolledbackOnFailure() {
        return this.containersRolledBackOnFailure.value();
    }

    public long getAllocatedOpportunisticGB() {
        return this.allocatedOpportunisticGB.value();
    }

    public int getAllocatedOpportunisticVCores() {
        return this.allocatedOpportunisticVCores.value();
    }

    public int getRunningOpportunisticContainers() {
        return this.runningOpportunisticContainers.value();
    }

    @VisibleForTesting
    public int getQueuedOpportunisticContainers() {
        return this.containersOpportunisticQueued.value();
    }

    @VisibleForTesting
    public int getQueuedGuaranteedContainers() {
        return this.containersGuaranteedQueued.value();
    }

    public long getCacheSizeBeforeClean() {
        return this.cacheSizeBeforeClean.value();
    }

    public long getTotalBytesDeleted() {
        return this.totalBytesDeleted.value();
    }

    public long getPublicBytesDeleted() {
        return this.publicBytesDeleted.value();
    }

    public long getPrivateBytesDeleted() {
        return this.privateBytesDeleted.value();
    }

    public void setContainerUsedMemGB(long usedMem) {
        this.containerUsedMemGB.set((int)Math.floor((double)usedMem / 1024.0));
    }

    public int getContainerUsedMemGB() {
        return this.containerUsedMemGB.value();
    }

    public void setContainerUsedVMemGB(long usedVMem) {
        this.containerUsedVMemGB.set((int)Math.floor((double)usedVMem / 1024.0));
    }

    public int getContainerUsedVMemGB() {
        return this.containerUsedVMemGB.value();
    }

    public void setContainerCpuUtilization(float cpuUtilization) {
        this.containerCpuUtilization.set(cpuUtilization);
    }

    public float getContainerCpuUtilization() {
        return this.containerCpuUtilization.value();
    }

    public void setNodeUsedMemGB(long totalUsedMemGB) {
        this.nodeUsedMemGB.set((int)Math.floor((double)totalUsedMemGB / 1024.0));
    }

    public int getNodeUsedMemGB() {
        return this.nodeUsedMemGB.value();
    }

    public void setNodeUsedVMemGB(long totalUsedVMemGB) {
        this.nodeUsedVMemGB.set((int)Math.floor((double)totalUsedVMemGB / 1024.0));
    }

    public int getNodeUsedVMemGB() {
        return this.nodeUsedVMemGB.value();
    }

    public float getNodeCpuUtilization() {
        return this.nodeCpuUtilization.value();
    }

    public void setNodeCpuUtilization(float cpuUtilization) {
        this.nodeCpuUtilization.set(cpuUtilization);
    }

    public void setNodeGpuUtilization(float nodeGpuUtilization) {
        this.nodeGpuUtilization.set(nodeGpuUtilization);
    }

    public float getNodeGpuUtilization() {
        return this.nodeGpuUtilization.value();
    }

    private void updateLocalizationHitRatios() {
        NodeManagerMetrics.updateLocalizationHitRatio(this.localizedCacheHitBytes, this.localizedCacheMissBytes, this.localizedCacheHitBytesRatio);
        NodeManagerMetrics.updateLocalizationHitRatio(this.localizedCacheHitFiles, this.localizedCacheMissFiles, this.localizedCacheHitFilesRatio);
    }

    private static void updateLocalizationHitRatio(MutableCounterLong hitCounter, MutableCounterLong missedCounter, MutableGaugeInt ratioGauge) {
        long misses;
        long hits = hitCounter.value();
        long total = hits + (misses = missedCounter.value());
        if (total > 0L) {
            ratioGauge.set((int)(100L * hits / total));
        }
    }

    public void localizationCacheHitMiss(long size) {
        if (size > 0L) {
            this.localizedCacheMissBytes.incr(size);
            this.localizedCacheMissFiles.incr();
            this.updateLocalizationHitRatios();
        } else if (size < 0L) {
            this.localizedCacheHitBytes.incr(-size);
            this.localizedCacheHitFiles.incr();
            this.updateLocalizationHitRatios();
        }
    }

    public void localizationComplete(long downloadMillis) {
        this.localizationDurationMillis.add(downloadMillis);
    }
}

