/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.nodelabels.NodeLabelUtil;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeAttributesProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeDescriptorsScriptRunner;

public class ScriptBasedNodeAttributesProvider
extends NodeAttributesProvider {
    private static final String NODE_ATTRIBUTE_PATTERN = "NODE_ATTRIBUTE:";
    private static final String NODE_ATTRIBUTE_DELIMITER = ",";
    private NodeAttributeScriptRunner runner;

    public ScriptBasedNodeAttributesProvider() {
        super(ScriptBasedNodeAttributesProvider.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        String nodeAttributeProviderScript = conf.get("yarn.nodemanager.node-attributes.provider.script.path");
        long scriptTimeout = conf.getLong("yarn.nodemanager.node-attributes.provider.fetch-timeout-ms", 1200000L);
        String[] scriptArgs = conf.getStrings("yarn.nodemanager.node-attributes.provider.script.opts", new String[0]);
        this.verifyConfiguredScript(nodeAttributeProviderScript);
        long intervalTime = conf.getLong("yarn.nodemanager.node-attributes.provider.fetch-interval-ms", 600000L);
        this.setIntervalTime(intervalTime);
        this.runner = new NodeAttributeScriptRunner(nodeAttributeProviderScript, scriptArgs, scriptTimeout, this);
    }

    @Override
    protected void cleanUp() throws Exception {
        this.runner.cleanUp();
    }

    @Override
    public TimerTask createTimerTask() {
        return this.runner;
    }

    private static class NodeAttributeScriptRunner
    extends NodeDescriptorsScriptRunner<NodeAttribute> {
        NodeAttributeScriptRunner(String scriptPath, String[] scriptArgs, long scriptTimeout, ScriptBasedNodeAttributesProvider provider) {
            super(scriptPath, scriptArgs, scriptTimeout, provider);
        }

        @Override
        Set<NodeAttribute> parseOutput(String scriptOutput) throws IOException {
            String[] splits;
            HashSet<NodeAttribute> attributeSet = new HashSet<NodeAttribute>();
            for (String line : splits = scriptOutput.split("\n")) {
                String trimmedLine = line.trim();
                if (!trimmedLine.startsWith(ScriptBasedNodeAttributesProvider.NODE_ATTRIBUTE_PATTERN)) continue;
                String nodeAttribute = trimmedLine.substring(ScriptBasedNodeAttributesProvider.NODE_ATTRIBUTE_PATTERN.length());
                String[] attributeStrs = nodeAttribute.split(ScriptBasedNodeAttributesProvider.NODE_ATTRIBUTE_DELIMITER);
                if (attributeStrs.length != 3) {
                    throw new IOException("Malformed output, expecting format NODE_ATTRIBUTE::ATTRIBUTE_NAME,ATTRIBUTE_TYPE,ATTRIBUTE_VALUE; but get " + nodeAttribute);
                }
                if (attributeStrs[0].contains("/")) {
                    throw new IOException("Node attributes reported by script should not contain any prefix.");
                }
                NodeAttribute na = NodeAttribute.newInstance((String)"nm.yarn.io", (String)attributeStrs[0], (NodeAttributeType)NodeAttributeType.valueOf((String)attributeStrs[1]), (String)attributeStrs[2]);
                if (attributeSet.add(na)) continue;
                throw new IOException("Ambiguous node attribute is found: " + na.toString() + ", a same attribute already exists");
            }
            try {
                NodeLabelUtil.validateNodeAttributes(attributeSet);
            }
            catch (IOException e) {
                throw new IOException("Node attributes collected by the script contains some invalidate entries. Detail message: " + e.getMessage());
            }
            return attributeSet;
        }
    }
}

