/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.Metrics2ThriftMetrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.metrics.ThriftMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;

public class MetricsFactory {
    private final boolean useOldMetrics;
    private final MetricsSystem metricsSystem;

    public MetricsFactory(AccumuloConfiguration conf) {
        this(conf.getBoolean(Property.GENERAL_LEGACY_METRICS));
    }

    public MetricsFactory(boolean useOldMetrics) {
        this.useOldMetrics = useOldMetrics;
        this.metricsSystem = useOldMetrics ? null : MetricsSystemHelper.getInstance();
    }

    public Metrics createThriftMetrics(String serverName, String threadName) {
        if (this.useOldMetrics) {
            return new ThriftMetrics(serverName, threadName);
        }
        return new Metrics2ThriftMetrics(this.metricsSystem, serverName, threadName);
    }
}

