/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.KerberosAuthorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKPermHandler;

public class KerberosPermissionHandler
implements PermissionHandler {
    private final ZKPermHandler zkPermissionHandler = new ZKPermHandler();

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.zkPermissionHandler.initialize(instanceId, initialize);
    }

    @Override
    public boolean validSecurityHandlers(Authenticator authent, Authorizor author) {
        return authent instanceof KerberosAuthenticator && author instanceof KerberosAuthorizor;
    }

    @Override
    public void initializeSecurity(TCredentials credentials, String rootuser) throws AccumuloSecurityException, ThriftSecurityException {
        this.zkPermissionHandler.initializeSecurity(credentials, Base64.getEncoder().encodeToString(rootuser.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean hasSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        return this.zkPermissionHandler.hasSystemPermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), permission);
    }

    @Override
    public boolean hasCachedSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        return this.zkPermissionHandler.hasCachedSystemPermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), permission);
    }

    @Override
    public boolean hasTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        return this.zkPermissionHandler.hasTablePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), table, permission);
    }

    @Override
    public boolean hasCachedTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        return this.zkPermissionHandler.hasCachedTablePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), table, permission);
    }

    @Override
    public boolean hasNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException, NamespaceNotFoundException {
        return this.zkPermissionHandler.hasNamespacePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), namespace, permission);
    }

    @Override
    public boolean hasCachedNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException, NamespaceNotFoundException {
        return this.zkPermissionHandler.hasCachedNamespacePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), namespace, permission);
    }

    @Override
    public void grantSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        this.zkPermissionHandler.grantSystemPermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), permission);
    }

    @Override
    public void revokeSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        this.zkPermissionHandler.revokeSystemPermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), permission);
    }

    @Override
    public void grantTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        this.zkPermissionHandler.grantTablePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), table, permission);
    }

    @Override
    public void revokeTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        this.zkPermissionHandler.revokeTablePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), table, permission);
    }

    @Override
    public void grantNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException, NamespaceNotFoundException {
        this.zkPermissionHandler.grantNamespacePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), namespace, permission);
    }

    @Override
    public void revokeNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException, NamespaceNotFoundException {
        this.zkPermissionHandler.revokeNamespacePermission(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)), namespace, permission);
    }

    @Override
    public void cleanTablePermissions(String table) throws AccumuloSecurityException, TableNotFoundException {
        this.zkPermissionHandler.cleanTablePermissions(table);
    }

    @Override
    public void cleanNamespacePermissions(String namespace) throws AccumuloSecurityException, NamespaceNotFoundException {
        this.zkPermissionHandler.cleanNamespacePermissions(namespace);
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        this.zkPermissionHandler.initUser(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void initTable(String table) throws AccumuloSecurityException {
        this.zkPermissionHandler.initTable(table);
    }

    @Override
    public void cleanUser(String user) throws AccumuloSecurityException {
        this.zkPermissionHandler.cleanUser(Base64.getEncoder().encodeToString(user.getBytes(StandardCharsets.UTF_8)));
    }
}

