/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.NamespaceInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.slf4j.LoggerFactory;

class FinishCreateNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    public FinishCreateNamespace(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long id, Master env) throws Exception {
        Utils.unreserveNamespace(this.namespaceInfo.namespaceId, id, true);
        env.getEventCoordinator().event("Created namespace %s ", this.namespaceInfo.namespaceName);
        LoggerFactory.getLogger(FinishCreateNamespace.class).debug("Created table " + this.namespaceInfo.namespaceId + " " + this.namespaceInfo.namespaceName);
        return null;
    }

    @Override
    public String getReturn() {
        return this.namespaceInfo.namespaceId;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
    }
}

