/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.TestRegionServerNoMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.log4j.Level;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicasClient {
    private static final Log LOG = LogFactory.getLog(TestReplicasClient.class);
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hriPrimary;
    private static HRegionInfo hriSecondary;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;
    private static final int REFRESH_PERIOD = 1000;

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        HTU.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        ConnectionUtils.setupMasterlessConnection((Configuration)HTU.getConfiguration());
        HTU.startMiniCluster(1);
        HTableDescriptor hdt = HTU.createTableDescriptor(TestReplicasClient.class.getSimpleName());
        hdt.addCoprocessor(SlowMeCopro.class.getName());
        table = HTU.createTable(hdt, (byte[][])new byte[][]{f}, HTU.getConfiguration());
        hriPrimary = table.getRegionLocation(row, false).getRegionInfo();
        hriSecondary = new HRegionInfo(hriPrimary.getTable(), hriPrimary.getStartKey(), hriPrimary.getEndKey(), hriPrimary.isSplit(), hriPrimary.getRegionId(), 1);
        LOG.info((Object)"Master is going to be stopped");
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
        Configuration c = new Configuration(HTU.getConfiguration());
        c.setInt("hbase.client.retries.number", 1);
        LOG.info((Object)"Master has stopped");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (table != null) {
            table.close();
        }
        HTU.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        HTU.getHBaseAdmin().getConnection().clearRegionCache();
        try {
            this.openRegion(hriPrimary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.openRegion(hriSecondary);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @After
    public void after() throws IOException, KeeperException {
        try {
            this.closeRegion(hriSecondary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeRegion(hriPrimary);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hriPrimary);
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hriSecondary);
        HTU.getHBaseAdmin().getConnection().clearRegionCache();
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private void openRegion(HRegionInfo hri) throws Exception {
        try {
            if (this.isRegionOpened(hri)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)this.getRS().getServerName());
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)this.getRS().getServerName(), (HRegionInfo)hri, (int)0, null, null);
        AdminProtos.OpenRegionResponse responseOpen = this.getRS().getRSRpcServices().openRegion(null, orr);
        Assert.assertEquals((long)responseOpen.getOpeningStateCount(), (long)1L);
        Assert.assertEquals((Object)responseOpen.getOpeningState(0), (Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED);
        this.checkRegionIsOpened(hri);
    }

    private void closeRegion(HRegionInfo hri) throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)this.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)this.getRS().getServerName(), (String)hri.getEncodedName(), (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = this.getRS().getRSRpcServices().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        this.checkRegionIsClosed(hri.getEncodedName());
        ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), null);
    }

    private void checkRegionIsOpened(HRegionInfo hri) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)ZKAssign.deleteOpenedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), null));
    }

    private boolean isRegionOpened(HRegionInfo hri) throws Exception {
        return this.getRS().getRegionByEncodedName(hri.getEncodedName()).isAvailable();
    }

    private void checkRegionIsClosed(String encodedRegionName) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        try {
            Assert.assertFalse((boolean)this.getRS().getRegionByEncodedName(encodedRegionName).isAvailable());
        }
        catch (NotServingRegionException notServingRegionException) {
            // empty catch block
        }
    }

    private void flushRegion(HRegionInfo regionInfo) throws IOException {
        TestRegionServerNoMaster.flushRegion(HTU, regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseRegionWithoutReplica() throws Exception {
        byte[] b1 = "testUseRegionWithoutReplica".getBytes();
        this.openRegion(hriSecondary);
        SlowMeCopro.getCdl().set(new CountDownLatch(0));
        try {
            Get g = new Get(b1);
            Result r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocations() throws Exception {
        byte[] b1 = "testLocations".getBytes();
        this.openRegion(hriSecondary);
        ClusterConnection hc = (ClusterConnection)HTU.getHBaseAdmin().getConnection();
        try {
            hc.clearRegionCache();
            RegionLocations rl = hc.locateRegion(table.getName(), b1, false, false);
            Assert.assertEquals((long)2L, (long)rl.size());
            rl = hc.locateRegion(table.getName(), b1, true, false);
            Assert.assertEquals((long)2L, (long)rl.size());
            hc.clearRegionCache();
            rl = hc.locateRegion(table.getName(), b1, true, false);
            Assert.assertEquals((long)2L, (long)rl.size());
            rl = hc.locateRegion(table.getName(), b1, false, false);
            Assert.assertEquals((long)2L, (long)rl.size());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultNoStaleRegionWithReplica() throws Exception {
        byte[] b1 = "testGetNoResultNoStaleRegionWithReplica".getBytes();
        this.openRegion(hriSecondary);
        try {
            Get g = new Get(b1);
            Result r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultStaleRegionWithReplica() throws Exception {
        byte[] b1 = "testGetNoResultStaleRegionWithReplica".getBytes();
        this.openRegion(hriSecondary);
        SlowMeCopro.getCdl().set(new CountDownLatch(1));
        try {
            Get g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            Result r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.getCdl().get().countDown();
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNoResultNotStaleSleepRegionWithReplica() throws Exception {
        byte[] b1 = "testGetNoResultNotStaleSleepRegionWithReplica".getBytes();
        this.openRegion(hriSecondary);
        try {
            SlowMeCopro.sleepTime.set(2000L);
            Get g = new Get(b1);
            Result r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
        }
        finally {
            SlowMeCopro.sleepTime.set(0L);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushTable() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
            Put p = new Put(row);
            p.add(f, row, row);
            table.put(p);
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
        }
        finally {
            Delete d = new Delete(row);
            table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushPrimary() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriPrimary);
            Put p = new Put(row);
            p.add(f, row, row);
            table.put(p);
            this.flushRegion(hriPrimary);
        }
        finally {
            Delete d = new Delete(row);
            table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushSecondary() throws Exception {
        this.openRegion(hriSecondary);
        try {
            this.flushRegion(hriSecondary);
            Put p = new Put(row);
            p.add(f, row, row);
            table.put(p);
            this.flushRegion(hriSecondary);
        }
        catch (TableNotFoundException d) {
        }
        finally {
            Delete d = new Delete(row);
            table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseRegionWithReplica() throws Exception {
        byte[] b1 = "testUseRegionWithReplica".getBytes();
        this.openRegion(hriSecondary);
        try {
            Put p = new Put(b1);
            p.add(f, b1, b1);
            table.put(p);
            LOG.info((Object)"Put done");
            Get g = new Get(b1);
            Result r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            LOG.info((Object)"get works and is not stale done");
            SlowMeCopro.sleepTime.set(2000L);
            g = new Get(b1);
            r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertFalse((boolean)r.getColumnCells(f, b1).isEmpty());
            SlowMeCopro.sleepTime.set(0L);
            LOG.info((Object)"sleep and is not stale done");
            SlowMeCopro.getCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getColumnCells(f, b1).isEmpty());
            SlowMeCopro.getCdl().get().countDown();
            LOG.info((Object)"stale done");
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            r = table.get(g);
            Assert.assertFalse((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getExists());
            LOG.info((Object)"exists not stale done");
            SlowMeCopro.getCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertFalse((String)"The secondary has stale data", (boolean)r.getExists());
            SlowMeCopro.getCdl().get().countDown();
            LOG.info((Object)"exists stale before flush done");
            this.flushRegion(hriPrimary);
            this.flushRegion(hriSecondary);
            LOG.info((Object)"flush done");
            Thread.sleep(3000L);
            SlowMeCopro.getCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertFalse((boolean)r.isEmpty());
            SlowMeCopro.getCdl().get().countDown();
            LOG.info((Object)"stale done");
            SlowMeCopro.getCdl().set(new CountDownLatch(1));
            g = new Get(b1);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            r = table.get(g);
            Assert.assertTrue((boolean)r.isStale());
            Assert.assertTrue((boolean)r.getExists());
            SlowMeCopro.getCdl().get().countDown();
            LOG.info((Object)"exists stale after flush done");
        }
        finally {
            SlowMeCopro.getCdl().get().countDown();
            SlowMeCopro.sleepTime.set(0L);
            Delete d = new Delete(b1);
            table.delete(d);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelOfMultiGet() throws Exception {
        byte[] b1;
        this.openRegion(hriSecondary);
        try {
            ArrayList<Put> puts = new ArrayList<Put>(2);
            b1 = Bytes.toBytes((String)"testCancelOfMultiGet0");
            Put p = new Put(b1);
            p.add(f, b1, b1);
            puts.add(p);
            byte[] b2 = Bytes.toBytes((String)"testCancelOfMultiGet1");
            p = new Put(b2);
            p.add(f, b2, b2);
            puts.add(p);
            table.put(puts);
            LOG.debug((Object)"PUT done");
            this.flushRegion(hriPrimary);
            LOG.info((Object)"flush done");
            Thread.sleep(3000L);
            AsyncProcess ap = ((ClusterConnection)HTU.getHBaseAdmin().getConnection()).getAsyncProcess();
            SlowMeCopro.getCdl().set(new CountDownLatch(1));
            ArrayList<Get> gets = new ArrayList<Get>();
            Get g = new Get(b1);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            gets.add(g);
            g = new Get(b2);
            g.setCheckExistenceOnly(true);
            g.setConsistency(Consistency.TIMELINE);
            gets.add(g);
            Object[] results = new Object[2];
            AsyncProcess.AsyncRequestFuture reqs = ap.submitAll(table.getPool(), table.getName(), gets, null, results);
            reqs.waitUntilDone();
            for (Object r : results) {
                Assert.assertTrue((boolean)((Result)r).isStale());
                Assert.assertTrue((boolean)((Result)r).getExists());
            }
            Set set = ((AsyncProcess.AsyncRequestFutureImpl)reqs).getCallsInProgress();
            Assert.assertTrue((!set.isEmpty() ? 1 : 0) != 0);
            for (MultiServerCallable m : set) {
                Assert.assertTrue((boolean)m.isCancelled());
            }
        }
        finally {
            SlowMeCopro.getCdl().get().countDown();
            SlowMeCopro.sleepTime.set(0L);
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
            for (int i = 0; i < 2; ++i) {
                b1 = Bytes.toBytes((String)("testCancelOfMultiGet" + i));
                Delete d = new Delete(b1);
                table.delete(d);
            }
            this.closeRegion(hriSecondary);
        }
    }

    @Test
    public void testScanWithReplicas() throws Exception {
        this.runMultipleScansOfOneType(false, false);
    }

    @Test
    public void testSmallScanWithReplicas() throws Exception {
        this.runMultipleScansOfOneType(false, true);
    }

    @Test
    public void testReverseScanWithReplicas() throws Exception {
        this.runMultipleScansOfOneType(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelOfScan() throws Exception {
        byte[] b1;
        int i;
        this.openRegion(hriSecondary);
        int NUMROWS = 100;
        try {
            for (i = 0; i < NUMROWS; ++i) {
                b1 = Bytes.toBytes((String)("testUseRegionWithReplica" + i));
                Put p = new Put(b1);
                p.add(f, b1, b1);
                table.put(p);
            }
            LOG.debug((Object)"PUT done");
            int caching = 20;
            byte[] start = Bytes.toBytes((String)"testUseRegionWithReplica0");
            this.flushRegion(hriPrimary);
            LOG.info((Object)"flush done");
            Thread.sleep(3000L);
            SlowMeCopro.slowDownNext.set(true);
            SlowMeCopro.countOfNext.set(0);
            SlowMeCopro.sleepTime.set(5000L);
            Scan scan = new Scan(start);
            scan.setCaching(caching);
            scan.setConsistency(Consistency.TIMELINE);
            ResultScanner scanner = table.getScanner(scan);
            Iterator iter = scanner.iterator();
            iter.next();
            Assert.assertTrue((boolean)((ClientScanner)scanner).isAnyRPCcancelled());
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
        }
        finally {
            ((CountDownLatch)SlowMeCopro.cdl.get()).countDown();
            SlowMeCopro.sleepTime.set(0L);
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
            for (i = 0; i < NUMROWS; ++i) {
                b1 = Bytes.toBytes((String)("testUseRegionWithReplica" + i));
                Delete d = new Delete(b1);
                table.delete(d);
            }
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMultipleScansOfOneType(boolean reversed, boolean small) throws Exception {
        int i;
        this.openRegion(hriSecondary);
        int NUMROWS = 100;
        int NUMCOLS = 10;
        try {
            for (i = 0; i < NUMROWS; ++i) {
                byte[] b1 = Bytes.toBytes((String)("testUseRegionWithReplica" + i));
                for (int col = 0; col < NUMCOLS; ++col) {
                    Put p = new Put(b1);
                    String qualifier = "qualifer" + col;
                    KeyValue kv = new KeyValue(b1, f, qualifier.getBytes());
                    p.add((Cell)kv);
                    table.put(p);
                }
            }
            LOG.debug((Object)"PUT done");
            int caching = 20;
            long maxResultSize = Long.MAX_VALUE;
            byte[] start = reversed ? Bytes.toBytes((String)("testUseRegionWithReplica" + (NUMROWS - 1))) : Bytes.toBytes((String)"testUseRegionWithReplica0");
            this.scanWithReplicas(reversed, small, Consistency.TIMELINE, caching, maxResultSize, start, NUMROWS, NUMCOLS, false, false);
            SlowMeCopro.sleepTime.set(5000L);
            this.scanWithReplicas(reversed, small, Consistency.STRONG, caching, maxResultSize, start, NUMROWS, NUMCOLS, false, false);
            SlowMeCopro.sleepTime.set(0L);
            this.flushRegion(hriPrimary);
            LOG.info((Object)"flush done");
            Thread.sleep(3000L);
            SlowMeCopro.sleepTime.set(5000L);
            this.scanWithReplicas(reversed, small, Consistency.TIMELINE, caching, maxResultSize, start, NUMROWS, NUMCOLS, true, false);
            SlowMeCopro.sleepTime.set(0L);
            SlowMeCopro.slowDownNext.set(true);
            SlowMeCopro.countOfNext.set(0);
            this.scanWithReplicas(reversed, small, Consistency.TIMELINE, caching, maxResultSize, start, NUMROWS, NUMCOLS, true, true);
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
            SlowMeCopro.sleepTime.set(5000L);
            this.scanWithReplicas(reversed, small, Consistency.STRONG, caching, maxResultSize, start, NUMROWS, NUMCOLS, false, false);
            SlowMeCopro.sleepTime.set(0L);
            maxResultSize = 1L;
            SlowMeCopro.slowDownNext.set(true);
            SlowMeCopro.countOfNext.set(0);
            this.scanWithReplicas(reversed, small, Consistency.TIMELINE, caching, maxResultSize, start, NUMROWS, NUMCOLS, true, true);
            maxResultSize = Long.MAX_VALUE;
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
        }
        finally {
            SlowMeCopro.getCdl().get().countDown();
            SlowMeCopro.sleepTime.set(0L);
            SlowMeCopro.slowDownNext.set(false);
            SlowMeCopro.countOfNext.set(0);
            for (i = 0; i < NUMROWS; ++i) {
                byte[] b1 = Bytes.toBytes((String)("testUseRegionWithReplica" + i));
                Delete d = new Delete(b1);
                table.delete(d);
            }
            this.closeRegion(hriSecondary);
        }
    }

    private void scanWithReplicas(boolean reversed, boolean small, Consistency consistency, int caching, long maxResultSize, byte[] startRow, int numRows, int numCols, boolean staleExpected, boolean slowNext) throws Exception {
        Scan scan = new Scan(startRow);
        scan.setCaching(caching);
        scan.setMaxResultSize(maxResultSize);
        scan.setReversed(reversed);
        scan.setSmall(small);
        scan.setConsistency(consistency);
        ResultScanner scanner = table.getScanner(scan);
        Iterator iter = scanner.iterator();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        int rowCount = 0;
        int cellCount = 0;
        int countOfStale = 0;
        while (iter.hasNext()) {
            ++rowCount;
            Result r = (Result)iter.next();
            String row = new String(r.getRow());
            if (map.containsKey(row)) {
                throw new Exception("Unexpected scan result. Repeated row " + Bytes.toString((byte[])r.getRow()));
            }
            map.put(row, true);
            for (Cell cell : r.rawCells()) {
                ++cellCount;
            }
            if (!slowNext) {
                Assert.assertTrue((r.isStale() == staleExpected ? 1 : 0) != 0);
            }
            if (!r.isStale()) continue;
            ++countOfStale;
        }
        Assert.assertTrue((String)("Count of rows " + rowCount + " num rows expected " + numRows), (rowCount == numRows ? 1 : 0) != 0);
        Assert.assertTrue((String)("Count of cells: " + cellCount + " cells expected: " + numRows * numCols), (cellCount == numRows * numCols ? 1 : 0) != 0);
        if (slowNext) {
            LOG.debug((Object)("Count of Stale " + countOfStale));
            Assert.assertTrue((countOfStale > 1 ? 1 : 0) != 0);
            if (maxResultSize != Long.MAX_VALUE) {
                Assert.assertTrue((countOfStale <= numRows ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((countOfStale < numRows ? 1 : 0) != 0);
            }
        }
    }

    static {
        ((Log4JLogger)RpcRetryingCaller.LOG).getLogger().setLevel(Level.ALL);
        table = null;
        row = TestReplicasClient.class.getName().getBytes();
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }

    public static class SlowMeCopro
    extends BaseRegionObserver {
        static final AtomicLong sleepTime = new AtomicLong(0L);
        static final AtomicBoolean slowDownNext = new AtomicBoolean(false);
        static final AtomicInteger countOfNext = new AtomicInteger(0);
        private static final AtomicReference<CountDownLatch> cdl = new AtomicReference<CountDownLatch>(new CountDownLatch(0));
        Random r = new Random();

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            this.slowdownCode(e);
        }

        public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            this.slowdownCode(e);
            return s;
        }

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            if (slowDownNext.get() && countOfNext.incrementAndGet() == 2) {
                sleepTime.set(2000L);
                this.slowdownCode(e);
            }
            return true;
        }

        private void slowdownCode(ObserverContext<RegionCoprocessorEnvironment> e) {
            if (((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getReplicaId() == 0) {
                CountDownLatch latch = SlowMeCopro.getCdl().get();
                try {
                    if (sleepTime.get() > 0L) {
                        LOG.info((Object)("Sleeping for " + sleepTime.get() + " ms"));
                        Thread.sleep(sleepTime.get());
                    } else if (latch.getCount() > 0L) {
                        LOG.info((Object)"Waiting for the counterCountDownLatch");
                        latch.await(2L, TimeUnit.MINUTES);
                        if (latch.getCount() > 0L) {
                            throw new RuntimeException("Can't wait more");
                        }
                    }
                }
                catch (InterruptedException e1) {
                    LOG.error((Object)e1);
                }
            } else {
                LOG.info((Object)"We're not the primary replicas.");
            }
        }

        public static AtomicReference<CountDownLatch> getCdl() {
            return cdl;
        }
    }
}

