/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestStripeCompactor {
    private static final byte[] NAME_OF_THINGS = Bytes.toBytes((String)"foo");
    private static final TableName TABLE_NAME = TableName.valueOf((byte[])NAME_OF_THINGS, (byte[])NAME_OF_THINGS);
    private static final byte[] KEY_B = Bytes.toBytes((String)"bbb");
    private static final byte[] KEY_C = Bytes.toBytes((String)"ccc");
    private static final byte[] KEY_D = Bytes.toBytes((String)"ddd");
    private static final KeyValue KV_A = TestStripeCompactor.kvAfter(Bytes.toBytes((String)"aaa"));
    private static final KeyValue KV_B = TestStripeCompactor.kvAfter(KEY_B);
    private static final KeyValue KV_C = TestStripeCompactor.kvAfter(KEY_C);
    private static final KeyValue KV_D = TestStripeCompactor.kvAfter(KEY_D);

    private static KeyValue kvAfter(byte[] key) {
        return new KeyValue(Arrays.copyOf(key, key.length + 1), 0L);
    }

    private static <T> T[] a(T ... a) {
        return a;
    }

    private static KeyValue[] e() {
        return TestStripeCompactor.a(new KeyValue[0]);
    }

    @Test
    public void testBoundaryCompactions() throws Exception {
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_B, KV_B, KV_C, KV_D), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A), TestStripeCompactor.a(KV_B, KV_B, KV_C), TestStripeCompactor.a(KV_D)));
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B, KV_C), (byte[][])TestStripeCompactor.a(KEY_B, KEY_C, KEY_D), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C)));
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B, KV_C), (byte[][])TestStripeCompactor.a(KEY_B, KEY_D), new KeyValue[][]{TestStripeCompactor.a(KV_B, KV_C)});
    }

    @Test
    public void testBoundaryCompactionEmptyFiles() throws Exception {
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_B), (byte[][])TestStripeCompactor.a(KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), null, null), null, null, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A, KV_C), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), null, TestStripeCompactor.a(KV_C)), null, null, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, null, TestStripeCompactor.e()), null, null, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, TestStripeCompactor.e(), null), KEY_B, KEY_C, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.e(), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.e(), TestStripeCompactor.e(), null), StripeStoreFileManager.OPEN_KEY, KEY_C, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_A), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.e(), TestStripeCompactor.e(), null), KEY_B, KEY_D, false);
        TestStripeCompactor.verifyBoundaryCompaction(TestStripeCompactor.a(KV_C), (byte[][])TestStripeCompactor.a(StripeStoreFileManager.OPEN_KEY, KEY_B, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY), (KeyValue[][])TestStripeCompactor.a(null, null, TestStripeCompactor.a(KV_C), TestStripeCompactor.e()), KEY_C, StripeStoreFileManager.OPEN_KEY, false);
    }

    public static void verifyBoundaryCompaction(KeyValue[] input, byte[][] boundaries, KeyValue[][] output) throws Exception {
        TestStripeCompactor.verifyBoundaryCompaction(input, boundaries, output, null, null, true);
    }

    public static void verifyBoundaryCompaction(KeyValue[] input, byte[][] boundaries, KeyValue[][] output, byte[] majorFrom, byte[] majorTo, boolean allFiles) throws Exception {
        StoreFileWritersCapture writers = new StoreFileWritersCapture();
        StripeCompactor sc = TestStripeCompactor.createCompactor(writers, input);
        List paths = sc.compact(TestStripeCompactor.createDummyRequest(), Arrays.asList(boundaries), majorFrom, majorTo, (CompactionThroughputController)NoLimitCompactionThroughputController.INSTANCE);
        writers.verifyKvs(output, allFiles, true);
        if (allFiles) {
            Assert.assertEquals((long)output.length, (long)paths.size());
            writers.verifyBoundaries(boundaries);
        }
    }

    @Test
    public void testSizeCompactions() throws Exception {
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_B, KV_C, KV_D), 3, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A), TestStripeCompactor.a(KV_B, KV_C), TestStripeCompactor.a(KV_D)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), 4, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C), TestStripeCompactor.a(KV_D)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_B, KV_C), 2, 1L, KEY_B, KEY_D, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_B), TestStripeCompactor.a(KV_C)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_A, KV_A, KV_C, KV_D), 3, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_A, KV_A), TestStripeCompactor.a(KV_C, KV_D)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_B, KV_C), 3, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B, KV_B), TestStripeCompactor.a(KV_C)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), 2, 1L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A), TestStripeCompactor.a(KV_B, KV_C, KV_D)));
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C), 1, Long.MAX_VALUE, StripeStoreFileManager.OPEN_KEY, KEY_D, new KeyValue[][]{TestStripeCompactor.a(KV_A, KV_B, KV_C)});
        TestStripeCompactor.verifySizeCompaction(TestStripeCompactor.a(KV_A, KV_B, KV_C, KV_D), Integer.MAX_VALUE, 2L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, (KeyValue[][])TestStripeCompactor.a(TestStripeCompactor.a(KV_A, KV_B), TestStripeCompactor.a(KV_C, KV_D)));
    }

    public static void verifySizeCompaction(KeyValue[] input, int targetCount, long targetSize, byte[] left, byte[] right, KeyValue[][] output) throws Exception {
        StoreFileWritersCapture writers = new StoreFileWritersCapture();
        StripeCompactor sc = TestStripeCompactor.createCompactor(writers, input);
        List paths = sc.compact(TestStripeCompactor.createDummyRequest(), targetCount, targetSize, left, right, null, null, (CompactionThroughputController)NoLimitCompactionThroughputController.INSTANCE);
        Assert.assertEquals((long)output.length, (long)paths.size());
        writers.verifyKvs(output, true, true);
        ArrayList<byte[]> boundaries = new ArrayList<byte[]>();
        boundaries.add(left);
        for (int i = 1; i < output.length; ++i) {
            boundaries.add(output[i][0].getRow());
        }
        boundaries.add(right);
        writers.verifyBoundaries((byte[][])boundaries.toArray((T[])new byte[0][]));
    }

    private static StripeCompactor createCompactor(StoreFileWritersCapture writers, KeyValue[] input) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        final Scanner scanner = new Scanner(input);
        HColumnDescriptor col = new HColumnDescriptor(NAME_OF_THINGS);
        ScanInfo si = new ScanInfo(conf, col, Long.MAX_VALUE, 0L, new KeyValue.KVComparator());
        Store store = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)store.getFamily()).thenReturn((Object)col);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)si);
        Mockito.when((Object)store.areWritesEnabled()).thenReturn((Object)true);
        Mockito.when((Object)store.getFileSystem()).thenReturn(Mockito.mock(FileSystem.class));
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)new HRegionInfo(TABLE_NAME));
        Mockito.when((Object)store.createWriterInTmp(Matchers.anyLong(), (Compression.Algorithm)Matchers.any(Compression.Algorithm.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenAnswer((Answer)writers);
        Mockito.when((Object)store.getComparator()).thenReturn((Object)new KeyValue.KVComparator());
        return new StripeCompactor(conf, store){

            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
                return scanner;
            }

            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
                return scanner;
            }
        };
    }

    private static CompactionRequest createDummyRequest() throws Exception {
        StoreFile sf = (StoreFile)Mockito.mock(StoreFile.class);
        StoreFile.Reader r = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        Mockito.when((Object)r.length()).thenReturn((Object)1L);
        Mockito.when((Object)r.getBloomFilterType()).thenReturn((Object)BloomType.NONE);
        Mockito.when((Object)r.getHFileReader()).thenReturn(Mockito.mock(HFile.Reader.class));
        Mockito.when((Object)r.getStoreFileScanner(Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong())).thenReturn(Mockito.mock(StoreFileScanner.class));
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.createReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.createReader(Matchers.anyBoolean())).thenReturn((Object)r);
        return new CompactionRequest(Arrays.asList(sf));
    }

    public static class StoreFileWritersCapture
    implements Answer<StoreFile.Writer>,
    StripeMultiFileWriter.WriterFactory {
        private List<Writer> writers = new ArrayList<Writer>();

        public StoreFile.Writer createWriter() throws IOException {
            final Writer realWriter = new Writer();
            this.writers.add(realWriter);
            StoreFile.Writer writer = (StoreFile.Writer)Mockito.mock(StoreFile.Writer.class);
            ((StoreFile.Writer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    return realWriter.kvs.add((KeyValue)invocation.getArguments()[0]);
                }
            }).when((Object)writer)).append((Cell)Matchers.any(KeyValue.class));
            ((StoreFile.Writer)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    Object[] args = invocation.getArguments();
                    return realWriter.data.put((byte[])args[0], (byte[])args[1]);
                }
            }).when((Object)writer)).appendFileInfo((byte[])Matchers.any(byte[].class), (byte[])Matchers.any(byte[].class));
            return writer;
        }

        public StoreFile.Writer answer(InvocationOnMock invocation) throws Throwable {
            return this.createWriter();
        }

        public void verifyKvs(KeyValue[][] kvss, boolean allFiles, boolean requireMetadata) {
            if (allFiles) {
                Assert.assertEquals((long)kvss.length, (long)this.writers.size());
            }
            int skippedWriters = 0;
            for (int i = 0; i < kvss.length; ++i) {
                KeyValue[] kvs = kvss[i];
                if (kvs != null) {
                    Writer w = this.writers.get(i - skippedWriters);
                    if (requireMetadata) {
                        Assert.assertNotNull((Object)w.data.get(StripeStoreFileManager.STRIPE_START_KEY));
                        Assert.assertNotNull((Object)w.data.get(StripeStoreFileManager.STRIPE_END_KEY));
                    } else {
                        Assert.assertNull((Object)w.data.get(StripeStoreFileManager.STRIPE_START_KEY));
                        Assert.assertNull((Object)w.data.get(StripeStoreFileManager.STRIPE_END_KEY));
                    }
                    Assert.assertEquals((long)kvs.length, (long)w.kvs.size());
                    for (int j = 0; j < kvs.length; ++j) {
                        Assert.assertEquals((Object)kvs[j], (Object)w.kvs.get(j));
                    }
                    continue;
                }
                Assert.assertFalse((boolean)allFiles);
                ++skippedWriters;
            }
        }

        public void verifyBoundaries(byte[][] boundaries) {
            Assert.assertEquals((long)(boundaries.length - 1), (long)this.writers.size());
            for (int i = 0; i < this.writers.size(); ++i) {
                Assert.assertArrayEquals((String)("i = " + i), (byte[])boundaries[i], (byte[])this.writers.get((int)i).data.get(StripeStoreFileManager.STRIPE_START_KEY));
                Assert.assertArrayEquals((String)("i = " + i), (byte[])boundaries[i + 1], (byte[])this.writers.get((int)i).data.get(StripeStoreFileManager.STRIPE_END_KEY));
            }
        }

        public static class Writer {
            public ArrayList<KeyValue> kvs = new ArrayList();
            public TreeMap<byte[], byte[]> data = new TreeMap(Bytes.BYTES_COMPARATOR);
        }
    }

    private static class Scanner
    implements InternalScanner {
        private final ArrayList<KeyValue> kvs;

        public Scanner(KeyValue ... kvs) {
            this.kvs = new ArrayList<KeyValue>(Arrays.asList(kvs));
        }

        public boolean next(List<Cell> results) throws IOException {
            if (this.kvs.isEmpty()) {
                return false;
            }
            results.add((Cell)this.kvs.remove(0));
            return !this.kvs.isEmpty();
        }

        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.next(result);
        }

        public void close() throws IOException {
        }
    }
}

