/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.PTFRollingPartition;
import org.apache.hadoop.hive.ql.exec.persistence.PTFRowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class PTFPartition {
    protected static Log LOG = LogFactory.getLog(PTFPartition.class);
    SerDe serDe;
    StructObjectInspector inputOI;
    StructObjectInspector outputOI;
    private final PTFRowContainer<List<Object>> elems;

    protected PTFPartition(Configuration cfg, SerDe serDe, StructObjectInspector inputOI, StructObjectInspector outputOI) throws HiveException {
        this(cfg, serDe, inputOI, outputOI, true);
    }

    protected PTFPartition(Configuration cfg, SerDe serDe, StructObjectInspector inputOI, StructObjectInspector outputOI, boolean createElemContainer) throws HiveException {
        this.serDe = serDe;
        this.inputOI = inputOI;
        this.outputOI = outputOI;
        if (createElemContainer) {
            int containerNumRows = HiveConf.getIntVar((Configuration)cfg, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEJOINCACHESIZE);
            this.elems = new PTFRowContainer(containerNumRows, cfg, null);
            this.elems.setSerDe(serDe, (ObjectInspector)outputOI);
            this.elems.setTableDesc(PTFRowContainer.createTableDesc(inputOI));
        } else {
            this.elems = null;
        }
    }

    public void reset() throws HiveException {
        this.elems.clearRows();
    }

    public SerDe getSerDe() {
        return this.serDe;
    }

    public StructObjectInspector getInputOI() {
        return this.inputOI;
    }

    public StructObjectInspector getOutputOI() {
        return this.outputOI;
    }

    public Object getAt(int i) throws HiveException {
        return this.elems.getAt(i);
    }

    public void append(Object o) throws HiveException {
        if (this.elems.rowCount() == Integer.MAX_VALUE) {
            throw new HiveException(String.format("Cannot add more than %d elements to a PTFPartition", Integer.MAX_VALUE));
        }
        List l = (List)ObjectInspectorUtils.copyToStandardObject((Object)o, (ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.elems.addRow(l);
    }

    public int size() {
        return this.elems.rowCount();
    }

    public PTFPartitionIterator<Object> iterator() throws HiveException {
        this.elems.first();
        return new PItr(0, this.size());
    }

    public PTFPartitionIterator<Object> range(int start, int end) {
        assert (start >= 0);
        assert (end <= this.size());
        assert (start <= end);
        return new PItr(start, end);
    }

    public void close() {
        try {
            this.elems.close();
        }
        catch (HiveException e) {
            LOG.error((Object)e.toString(), (Throwable)e);
        }
    }

    public static PTFPartition create(Configuration cfg, SerDe serDe, StructObjectInspector inputOI, StructObjectInspector outputOI) throws HiveException {
        return new PTFPartition(cfg, serDe, inputOI, outputOI);
    }

    public static PTFRollingPartition createRolling(Configuration cfg, SerDe serDe, StructObjectInspector inputOI, StructObjectInspector outputOI, int precedingSpan, int followingSpan) throws HiveException {
        return new PTFRollingPartition(cfg, serDe, inputOI, outputOI, precedingSpan, followingSpan);
    }

    public static StructObjectInspector setupPartitionOutputOI(SerDe serDe, StructObjectInspector tblFnOI) throws SerDeException {
        return (StructObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)tblFnOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
    }

    public static interface PTFPartitionIterator<T>
    extends Iterator<T> {
        public int getIndex();

        public T lead(int var1) throws HiveException;

        public T lag(int var1) throws HiveException;

        public Object resetToIndex(int var1) throws HiveException;

        public PTFPartition getPartition();

        public void reset() throws HiveException;
    }

    class PItr
    implements PTFPartitionIterator<Object> {
        int idx;
        final int start;
        final int end;
        final int createTimeSz;

        PItr(int start, int end) {
            this.idx = start;
            this.start = start;
            this.end = end;
            this.createTimeSz = PTFPartition.this.size();
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.idx < this.end;
        }

        @Override
        public Object next() {
            this.checkForComodification();
            try {
                return PTFPartition.this.getAt(this.idx++);
            }
            catch (HiveException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        final void checkForComodification() {
            if (this.createTimeSz != PTFPartition.this.size()) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int getIndex() {
            return this.idx;
        }

        private Object getAt(int i) throws HiveException {
            return PTFPartition.this.getAt(i);
        }

        @Override
        public Object lead(int amt) throws HiveException {
            int i = this.idx + amt;
            i = i >= this.end ? this.end - 1 : i;
            return this.getAt(i);
        }

        @Override
        public Object lag(int amt) throws HiveException {
            int i = this.idx - amt;
            i = i < this.start ? this.start : i;
            return this.getAt(i);
        }

        @Override
        public Object resetToIndex(int idx) throws HiveException {
            if (idx < this.start || idx >= this.end) {
                return null;
            }
            Object o = this.getAt(idx);
            this.idx = idx + 1;
            return o;
        }

        @Override
        public PTFPartition getPartition() {
            return PTFPartition.this;
        }

        @Override
        public void reset() {
            this.idx = this.start;
        }
    }
}

