/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcFileKeyWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcFileValueWrapper;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class OrcFileStripeMergeRecordReader
implements RecordReader<OrcFileKeyWrapper, OrcFileValueWrapper> {
    private final Reader reader;
    private final Path path;
    protected Iterator<StripeInformation> iter;
    protected List<OrcProto.StripeStatistics> stripeStatistics;
    private int stripeIdx;
    private long start;
    private long end;
    private boolean skipFile;

    public OrcFileStripeMergeRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.path = split.getPath();
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        FileSystem fs = this.path.getFileSystem(conf);
        this.reader = OrcFile.createReader(this.path, OrcFile.readerOptions(conf).filesystem(fs));
        this.iter = this.reader.getStripes().iterator();
        this.stripeIdx = 0;
        this.stripeStatistics = ((ReaderImpl)this.reader).getOrcProtoStripeStatistics();
    }

    public Class<?> getKeyClass() {
        return OrcFileKeyWrapper.class;
    }

    public Class<?> getValueClass() {
        return OrcFileValueWrapper.class;
    }

    public OrcFileKeyWrapper createKey() {
        return new OrcFileKeyWrapper();
    }

    public OrcFileValueWrapper createValue() {
        return new OrcFileValueWrapper();
    }

    public boolean next(OrcFileKeyWrapper key, OrcFileValueWrapper value) throws IOException {
        if (this.skipFile) {
            return false;
        }
        return this.nextStripe(key, value);
    }

    protected boolean nextStripe(OrcFileKeyWrapper keyWrapper, OrcFileValueWrapper valueWrapper) throws IOException {
        if ((this.stripeStatistics == null || this.stripeStatistics.isEmpty()) && this.reader.getNumberOfRows() > 0L) {
            keyWrapper.setInputPath(this.path);
            keyWrapper.setIsIncompatFile(true);
            this.skipFile = true;
            return true;
        }
        while (this.iter.hasNext()) {
            StripeInformation si = this.iter.next();
            if (si.getOffset() >= this.start && si.getOffset() < this.end) {
                valueWrapper.setStripeStatistics(this.stripeStatistics.get(this.stripeIdx++));
                valueWrapper.setStripeInformation(si);
                if (!this.iter.hasNext()) {
                    valueWrapper.setLastStripeInFile(true);
                    valueWrapper.setUserMetadata(((ReaderImpl)this.reader).getOrcProtoUserMetadata());
                }
            } else {
                ++this.stripeIdx;
                continue;
            }
            keyWrapper.setInputPath(this.path);
            keyWrapper.setCompression(this.reader.getCompression());
            keyWrapper.setCompressBufferSize(this.reader.getCompressionSize());
            keyWrapper.setVersion(this.reader.getFileVersion());
            keyWrapper.setRowIndexStride(this.reader.getRowIndexStride());
            keyWrapper.setTypes(this.reader.getTypes());
            return true;
        }
        return false;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    protected void seek(long pos) throws IOException {
    }

    public long getStart() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

