/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class GlobalLimitOptimizer
implements Transform {
    private final Log LOG = LogFactory.getLog((String)GlobalLimitOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        TableScanOperator ts;
        Integer tempGlobalLimit;
        Context ctx = pctx.getContext();
        HashMap<String, Operator<? extends OperatorDesc>> topOps = pctx.getTopOps();
        GlobalLimitCtx globalLimitCtx = pctx.getGlobalLimitCtx();
        HashMap<TableScanOperator, ExprNodeDesc> opToPartPruner = pctx.getOpToPartPruner();
        HashMap<String, SplitSample> nameToSplitSample = pctx.getNameToSplitSample();
        if (ctx.getTryCount() == 0 && topOps.size() == 1 && !globalLimitCtx.ifHasTransformOrUDTF() && nameToSplitSample.isEmpty() && (tempGlobalLimit = GlobalLimitOptimizer.checkQbpForGlobalLimit(ts = (TableScanOperator)topOps.values().toArray()[0])) != null && tempGlobalLimit != 0) {
            String alias;
            PrunedPartitionList partsList;
            Table tab = ((TableScanDesc)ts.getConf()).getTableMetadata();
            Set<FilterOperator> filterOps = OperatorUtils.findOperators(ts, FilterOperator.class);
            if (!tab.isPartitioned()) {
                if (filterOps.size() == 0) {
                    globalLimitCtx.enableOpt(tempGlobalLimit);
                }
            } else if (this.onlyContainsPartnCols(tab, filterOps) && !(partsList = pctx.getPrunedPartitions(alias = (String)topOps.keySet().toArray()[0], ts)).hasUnknownPartitions()) {
                globalLimitCtx.enableOpt(tempGlobalLimit);
            }
            if (globalLimitCtx.isEnable()) {
                this.LOG.info((Object)("Qualify the optimize that reduces input size for 'limit' for limit " + globalLimitCtx.getGlobalLimit()));
            }
        }
        return pctx;
    }

    private boolean onlyContainsPartnCols(Table table, Set<FilterOperator> filters) {
        for (FilterOperator filter : filters) {
            if (PartitionPruner.onlyContainsPartnCols(table, ((FilterDesc)filter.getConf()).getPredicate())) continue;
            return false;
        }
        return true;
    }

    private static Integer checkQbpForGlobalLimit(TableScanOperator ts) {
        ImmutableSet searchedClasses = new ImmutableSet.Builder().add(ReduceSinkOperator.class).add(GroupByOperator.class).add(FilterOperator.class).add(LimitOperator.class).build();
        Multimap<Class<? extends Operator<?>>, Operator<?>> ops = OperatorUtils.classifyOperators(ts, searchedClasses);
        for (Operator op : ops.get(ReduceSinkOperator.class)) {
            ReduceSinkDesc reduceSinkConf = (ReduceSinkDesc)((ReduceSinkOperator)op).getConf();
            if (!reduceSinkConf.isOrdering() && !reduceSinkConf.isPartitioning()) continue;
            return null;
        }
        for (Operator op : ops.get(GroupByOperator.class)) {
            GroupByDesc groupByConf = (GroupByDesc)((GroupByOperator)op).getConf();
            if (!groupByConf.isAggregate() && !groupByConf.isDistinct()) continue;
            return null;
        }
        for (Operator op : ops.get(FilterOperator.class)) {
            FilterDesc filterConf = (FilterDesc)((FilterOperator)op).getConf();
            if (!filterConf.getIsSamplingPred()) continue;
            return null;
        }
        Collection limitOps = ops.get(LimitOperator.class);
        if (limitOps.size() == 1) {
            return ((LimitDesc)((LimitOperator)limitOps.iterator().next()).getConf()).getLimit();
        }
        if (limitOps.size() == 0) {
            return 0;
        }
        return null;
    }
}

