/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class CrossProductCheck
implements PhysicalPlanResolver,
Dispatcher {
    protected static final transient Log LOG = LogFactory.getLog(CrossProductCheck.class);

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        TaskGraphWalker ogw = new TaskGraphWalker(this);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
        Task currTask = (Task)nd;
        if (currTask instanceof MapRedTask) {
            MapRedTask mrTsk = (MapRedTask)currTask;
            MapredWork mrWrk = (MapredWork)mrTsk.getWork();
            this.checkMapJoins(mrTsk);
            this.checkMRReducer(currTask.toString(), mrWrk);
        } else if (currTask instanceof ConditionalTask) {
            List<Task<? extends Serializable>> taskListInConditionalTask = ((ConditionalTask)currTask).getListTasks();
            for (Task<? extends Serializable> tsk : taskListInConditionalTask) {
                this.dispatch(tsk, stack, nodeOutputs);
            }
        } else if (currTask instanceof TezTask) {
            TezTask tzTask = (TezTask)currTask;
            TezWork tzWrk = (TezWork)tzTask.getWork();
            this.checkMapJoins(tzWrk);
            this.checkTezReducer(tzWrk);
        }
        return null;
    }

    private void warn(String msg) {
        SessionState.getConsole().getInfoStream().println(String.format("Warning: %s", msg));
    }

    private void checkMapJoins(MapRedTask mrTsk) throws SemanticException {
        ReduceWork redWork;
        MapredWork mrWrk = (MapredWork)mrTsk.getWork();
        MapWork mapWork = mrWrk.getMapWork();
        List<String> warnings = new MapJoinCheck(mrTsk.toString()).analyze(mapWork);
        if (!warnings.isEmpty()) {
            for (String w : warnings) {
                this.warn(w);
            }
        }
        if ((redWork = mrWrk.getReduceWork()) != null && !(warnings = new MapJoinCheck(mrTsk.toString()).analyze(redWork)).isEmpty()) {
            for (String w : warnings) {
                this.warn(w);
            }
        }
    }

    private void checkMapJoins(TezWork tzWrk) throws SemanticException {
        for (BaseWork wrk : tzWrk.getAllWork()) {
            List<String> warnings;
            if (wrk instanceof MergeJoinWork) {
                wrk = ((MergeJoinWork)wrk).getMainWork();
            }
            if ((warnings = new MapJoinCheck(wrk.getName()).analyze(wrk)).isEmpty()) continue;
            for (String w : warnings) {
                this.warn(w);
            }
        }
    }

    private void checkTezReducer(TezWork tzWrk) throws SemanticException {
        for (BaseWork wrk : tzWrk.getAllWork()) {
            if (wrk instanceof MergeJoinWork) {
                wrk = ((MergeJoinWork)wrk).getMainWork();
            }
            if (!(wrk instanceof ReduceWork)) continue;
            ReduceWork rWork = (ReduceWork)wrk;
            Operator<?> reducer = ((ReduceWork)wrk).getReducer();
            if (!(reducer instanceof JoinOperator) && !(reducer instanceof CommonMergeJoinOperator)) continue;
            HashMap<Integer, ExtractReduceSinkInfo.Info> rsInfo = new HashMap<Integer, ExtractReduceSinkInfo.Info>();
            for (Map.Entry<Integer, String> e : rWork.getTagToInput().entrySet()) {
                rsInfo.putAll(this.getReducerInfo(tzWrk, rWork.getName(), e.getValue()));
            }
            this.checkForCrossProduct(rWork.getName(), reducer, rsInfo);
        }
    }

    private void checkMRReducer(String taskName, MapredWork mrWrk) throws SemanticException {
        ReduceWork rWrk = mrWrk.getReduceWork();
        if (rWrk == null) {
            return;
        }
        Operator<?> reducer = rWrk.getReducer();
        if (reducer instanceof JoinOperator || reducer instanceof CommonMergeJoinOperator) {
            MapWork prntWork = mrWrk.getMapWork();
            this.checkForCrossProduct(taskName, reducer, new ExtractReduceSinkInfo(null).analyze(prntWork));
        }
    }

    private void checkForCrossProduct(String taskName, Operator<? extends OperatorDesc> reducer, Map<Integer, ExtractReduceSinkInfo.Info> rsInfo) {
        if (rsInfo.isEmpty()) {
            return;
        }
        Iterator<ExtractReduceSinkInfo.Info> it = rsInfo.values().iterator();
        ExtractReduceSinkInfo.Info info = it.next();
        if (info.keyCols.size() == 0) {
            ArrayList<String> iAliases = new ArrayList<String>();
            iAliases.addAll(info.inputAliases);
            while (it.hasNext()) {
                info = it.next();
                iAliases.addAll(info.inputAliases);
            }
            String warning = String.format("Shuffle Join %s[tables = %s] in Stage '%s' is a cross product", reducer.toString(), iAliases, taskName);
            this.warn(warning);
        }
    }

    private Map<Integer, ExtractReduceSinkInfo.Info> getReducerInfo(TezWork tzWrk, String vertex, String prntVertex) throws SemanticException {
        BaseWork prntWork = tzWrk.getWorkMap().get(prntVertex);
        return new ExtractReduceSinkInfo(vertex).analyze(prntWork);
    }

    static class NoopProcessor
    implements NodeProcessor {
        NoopProcessor() {
        }

        @Override
        public final Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return nd;
        }
    }

    public static class ExtractReduceSinkInfo
    implements NodeProcessor,
    NodeProcessorCtx {
        final String outputTaskName;
        final Map<Integer, Info> reduceSinkInfo;

        ExtractReduceSinkInfo(String parentTaskName) {
            this.outputTaskName = parentTaskName;
            this.reduceSinkInfo = new HashMap<Integer, Info>();
        }

        Map<Integer, Info> analyze(BaseWork work) throws SemanticException {
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%"), this);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new NoopProcessor(), opRules, this);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(work.getAllRootOperators());
            ogw.startWalking(topNodes, null);
            return this.reduceSinkInfo;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            String rOutputName;
            ReduceSinkOperator rsOp = (ReduceSinkOperator)nd;
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)rsOp.getConf();
            if (!(this.outputTaskName == null || (rOutputName = rsDesc.getOutputName()) != null && this.outputTaskName.equals(rOutputName))) {
                return null;
            }
            this.reduceSinkInfo.put(rsDesc.getTag(), new Info(rsDesc.getKeyCols(), rsOp.getInputAliases()));
            return null;
        }

        static class Info {
            List<ExprNodeDesc> keyCols;
            List<String> inputAliases;

            Info(List<ExprNodeDesc> keyCols, List<String> inputAliases) {
                this.keyCols = keyCols;
                this.inputAliases = inputAliases == null ? new ArrayList() : inputAliases;
            }

            Info(List<ExprNodeDesc> keyCols, String[] inputAliases) {
                this.keyCols = keyCols;
                this.inputAliases = inputAliases == null ? new ArrayList() : Arrays.asList(inputAliases);
            }
        }
    }

    public static class MapJoinCheck
    implements NodeProcessor,
    NodeProcessorCtx {
        final List<String> warnings;
        final String taskName;

        MapJoinCheck(String taskName) {
            this.taskName = taskName;
            this.warnings = new ArrayList<String>();
        }

        List<String> analyze(BaseWork work) throws SemanticException {
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", MapJoinOperator.getOperatorName() + "%"), this);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new NoopProcessor(), opRules, this);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(work.getAllRootOperators());
            ogw.startWalking(topNodes, null);
            return this.warnings;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator mjOp = (AbstractMapJoinOperator)nd;
            MapJoinDesc mjDesc = (MapJoinDesc)mjOp.getConf();
            String bigTablAlias = mjDesc.getBigTableAlias();
            if (bigTablAlias == null) {
                Operator<OperatorDesc> parent = null;
                for (Operator<OperatorDesc> op : mjOp.getParentOperators()) {
                    if (!(op instanceof TableScanOperator)) continue;
                    parent = op;
                }
                if (parent != null) {
                    TableScanDesc tDesc = (TableScanDesc)((TableScanOperator)parent).getConf();
                    bigTablAlias = tDesc.getAlias();
                }
            }
            bigTablAlias = bigTablAlias == null ? "?" : bigTablAlias;
            List<ExprNodeDesc> joinExprs = mjDesc.getKeys().values().iterator().next();
            if (joinExprs.size() == 0) {
                this.warnings.add(String.format("Map Join %s[bigTable=%s] in task '%s' is a cross product", mjOp.toString(), bigTablAlias, this.taskName));
            }
            return null;
        }
    }
}

