/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivilegeType;
import org.apache.thrift.TException;

public class SQLAuthorizationUtils {
    private static final String[] SUPPORTED_PRIVS = new String[]{"INSERT", "UPDATE", "DELETE", "SELECT"};
    private static final Set<String> SUPPORTED_PRIVS_SET = new HashSet<String>(Arrays.asList(SUPPORTED_PRIVS));
    public static final Log LOG = LogFactory.getLog(SQLAuthorizationUtils.class);

    static PrivilegeBag getThriftPrivilegesBag(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException {
        HiveObjectRef privObj = SQLAuthorizationUtils.getThriftHiveObjectRef(hivePrivObject);
        PrivilegeBag privBag = new PrivilegeBag();
        for (HivePrivilege privilege : hivePrivileges) {
            if (privilege.getColumns() != null && privilege.getColumns().size() > 0) {
                throw new HiveAuthzPluginException("Privileges on columns not supported currently in sql standard authorization mode");
            }
            if (!SUPPORTED_PRIVS_SET.contains(privilege.getName().toUpperCase(Locale.US))) {
                throw new HiveAuthzPluginException("Privilege: " + privilege.getName() + " is not supported in sql standard authorization mode");
            }
            PrivilegeGrantInfo grantInfo = SQLAuthorizationUtils.getThriftPrivilegeGrantInfo(privilege, grantorPrincipal, grantOption, 0);
            for (HivePrincipal principal : hivePrincipals) {
                HiveObjectPrivilege objPriv = new HiveObjectPrivilege(privObj, principal.getName(), AuthorizationUtils.getThriftPrincipalType(principal.getType()), grantInfo);
                privBag.addToPrivileges(objPriv);
            }
        }
        return privBag;
    }

    static PrivilegeGrantInfo getThriftPrivilegeGrantInfo(HivePrivilege privilege, HivePrincipal grantorPrincipal, boolean grantOption, int grantTime) throws HiveAuthzPluginException {
        try {
            return AuthorizationUtils.getThriftPrivilegeGrantInfo(privilege, grantorPrincipal, grantOption, grantTime);
        }
        catch (HiveException e) {
            throw new HiveAuthzPluginException(e);
        }
    }

    static HiveObjectRef getThriftHiveObjectRef(HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        try {
            return AuthorizationUtils.getThriftHiveObjectRef(privObj);
        }
        catch (HiveException e) {
            throw new HiveAuthzPluginException(e);
        }
    }

    static HivePrivilegeObject.HivePrivilegeObjectType getPluginObjType(HiveObjectType objectType) throws HiveAuthzPluginException {
        switch (objectType) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
            case COLUMN: 
            case GLOBAL: 
            case PARTITION: {
                throw new HiveAuthzPluginException("Unsupported object type " + objectType);
            }
        }
        throw new AssertionError((Object)("Unexpected object type " + objectType));
    }

    public static void validatePrivileges(List<HivePrivilege> hivePrivileges) throws HiveAuthzPluginException {
        for (HivePrivilege hivePrivilege : hivePrivileges) {
            if (hivePrivilege.getColumns() != null && hivePrivilege.getColumns().size() != 0) {
                throw new HiveAuthzPluginException("Privilege with columns are not currently supported with sql standard authorization:" + hivePrivilege);
            }
            SQLPrivilegeType.getRequirePrivilege(hivePrivilege.getName());
        }
    }

    static RequiredPrivileges getPrivilegesFromMetaStore(IMetaStoreClient metastoreClient, String userName, HivePrivilegeObject hivePrivObject, List<String> curRoles, boolean isAdmin) throws HiveAuthzPluginException {
        PrincipalPrivilegeSet thrifPrivs = null;
        try {
            HiveObjectRef objectRef = AuthorizationUtils.getThriftHiveObjectRef(hivePrivObject);
            if (objectRef.getObjectType() == null) {
                objectRef.setObjectType(HiveObjectType.GLOBAL);
            }
            thrifPrivs = metastoreClient.get_privilege_set(objectRef, userName, null);
        }
        catch (MetaException e) {
            SQLAuthorizationUtils.throwGetPrivErr((Exception)((Object)e), hivePrivObject, userName);
        }
        catch (TException e) {
            SQLAuthorizationUtils.throwGetPrivErr((Exception)((Object)e), hivePrivObject, userName);
        }
        catch (HiveException e) {
            SQLAuthorizationUtils.throwGetPrivErr(e, hivePrivObject, userName);
        }
        SQLAuthorizationUtils.filterPrivsByCurrentRoles(thrifPrivs, curRoles);
        RequiredPrivileges privs = SQLAuthorizationUtils.getRequiredPrivsFromThrift(thrifPrivs);
        if (SQLAuthorizationUtils.isOwner(metastoreClient, userName, curRoles, hivePrivObject)) {
            privs.addPrivilege(SQLPrivTypeGrant.OWNER_PRIV);
        }
        if (isAdmin) {
            privs.addPrivilege(SQLPrivTypeGrant.ADMIN_PRIV);
        }
        return privs;
    }

    private static void filterPrivsByCurrentRoles(PrincipalPrivilegeSet thriftPrivs, List<String> curRoles) {
        if (thriftPrivs == null || thriftPrivs.getRolePrivileges() == null || thriftPrivs.getRolePrivilegesSize() == 0) {
            return;
        }
        HashMap<String, List> filteredRolePrivs = new HashMap<String, List>();
        for (String role : curRoles) {
            List privs = (List)thriftPrivs.getRolePrivileges().get(role);
            if (privs == null) continue;
            filteredRolePrivs.put(role, privs);
        }
        thriftPrivs.setRolePrivileges(filteredRolePrivs);
    }

    private static boolean isOwner(IMetaStoreClient metastoreClient, String userName, List<String> curRoles, HivePrivilegeObject hivePrivObject) throws HiveAuthzPluginException {
        switch (hivePrivObject.getType()) {
            case TABLE_OR_VIEW: {
                Table thriftTableObj = null;
                try {
                    thriftTableObj = metastoreClient.getTable(hivePrivObject.getDbname(), hivePrivObject.getObjectName());
                }
                catch (Exception e) {
                    SQLAuthorizationUtils.throwGetObjErr(e, hivePrivObject);
                }
                return userName.equals(thriftTableObj.getOwner());
            }
            case DATABASE: {
                if ("default".equalsIgnoreCase(hivePrivObject.getDbname())) {
                    return true;
                }
                Database db = null;
                try {
                    db = metastoreClient.getDatabase(hivePrivObject.getDbname());
                }
                catch (Exception e) {
                    SQLAuthorizationUtils.throwGetObjErr(e, hivePrivObject);
                }
                if (db.getOwnerType() == PrincipalType.USER) {
                    return userName.equals(db.getOwnerName());
                }
                if (db.getOwnerType() == PrincipalType.ROLE) {
                    return curRoles.contains(db.getOwnerName());
                }
                LOG.warn((Object)("Owner of database " + db.getName() + " is of unsupported type " + db.getOwnerType()));
                return false;
            }
        }
        return false;
    }

    private static void throwGetObjErr(Exception e, HivePrivilegeObject hivePrivObject) throws HiveAuthzPluginException {
        String msg = "Error getting object from metastore for " + hivePrivObject;
        throw new HiveAuthzPluginException(msg, e);
    }

    private static void throwGetPrivErr(Exception e, HivePrivilegeObject hivePrivObject, String userName) throws HiveAuthzPluginException {
        String msg = "Error getting privileges on " + hivePrivObject + " for " + userName + ": " + e.getMessage();
        throw new HiveAuthzPluginException(msg, e);
    }

    private static RequiredPrivileges getRequiredPrivsFromThrift(PrincipalPrivilegeSet thrifPrivs) throws HiveAuthzPluginException {
        RequiredPrivileges reqPrivs = new RequiredPrivileges();
        Map userPrivs = thrifPrivs.getUserPrivileges();
        if (userPrivs != null && userPrivs.size() != 1) {
            throw new HiveAuthzPluginException("Invalid number of user privilege objects: " + userPrivs.size());
        }
        SQLAuthorizationUtils.addRequiredPrivs(reqPrivs, userPrivs);
        Map rolePrivs = thrifPrivs.getRolePrivileges();
        SQLAuthorizationUtils.addRequiredPrivs(reqPrivs, rolePrivs);
        return reqPrivs;
    }

    private static void addRequiredPrivs(RequiredPrivileges reqPrivs, Map<String, List<PrivilegeGrantInfo>> availPrivs) throws HiveAuthzPluginException {
        if (availPrivs == null) {
            return;
        }
        for (Map.Entry<String, List<PrivilegeGrantInfo>> userPriv : availPrivs.entrySet()) {
            List<PrivilegeGrantInfo> userPrivGInfos = userPriv.getValue();
            for (PrivilegeGrantInfo userPrivGInfo : userPrivGInfos) {
                reqPrivs.addPrivilege(userPrivGInfo.getPrivilege(), userPrivGInfo.isGrantOption());
            }
        }
    }

    public static void addMissingPrivMsg(Collection<SQLPrivTypeGrant> missingPrivs, HivePrivilegeObject hivePrivObject, List<String> deniedMessages) {
        if (missingPrivs.size() != 0) {
            ArrayList<SQLPrivTypeGrant> sortedmissingPrivs = new ArrayList<SQLPrivTypeGrant>(missingPrivs);
            Collections.sort(sortedmissingPrivs);
            String errMsg = sortedmissingPrivs + " on " + hivePrivObject;
            deniedMessages.add(errMsg);
        }
    }

    public static RequiredPrivileges getPrivilegesFromFS(Path filePath, HiveConf conf, String userName) throws HiveAuthzPluginException {
        RequiredPrivileges availPrivs = new RequiredPrivileges();
        try {
            FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)conf);
            FileStatus fileStatus = FileUtils.getPathOrParentThatExists((FileSystem)fs, (Path)filePath);
            if (FileUtils.isOwnerOfFileHierarchy((FileSystem)fs, (FileStatus)fileStatus, (String)userName)) {
                availPrivs.addPrivilege(SQLPrivTypeGrant.OWNER_PRIV);
            }
            if (FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)fileStatus, (String)userName, (FsAction)FsAction.WRITE)) {
                availPrivs.addPrivilege(SQLPrivTypeGrant.INSERT_NOGRANT);
                availPrivs.addPrivilege(SQLPrivTypeGrant.DELETE_NOGRANT);
            }
            if (FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)fileStatus, (String)userName, (FsAction)FsAction.READ)) {
                availPrivs.addPrivilege(SQLPrivTypeGrant.SELECT_NOGRANT);
            }
        }
        catch (Exception e) {
            String msg = "Error getting permissions for " + filePath + ": " + e.getMessage();
            throw new HiveAuthzPluginException(msg, e);
        }
        return availPrivs;
    }

    public static void assertNoDeniedPermissions(HivePrincipal hivePrincipal, HiveOperationType hiveOpType, List<String> deniedMessages) throws HiveAccessControlException {
        if (deniedMessages.size() != 0) {
            Collections.sort(deniedMessages);
            String errorMessage = "Permission denied: " + hivePrincipal + " does not have following privileges for operation " + (Object)((Object)hiveOpType) + " " + deniedMessages;
            throw new HiveAccessControlException(errorMessage);
        }
    }

    static HiveAuthzPluginException getPluginException(String prefix, Exception e) {
        return new HiveAuthzPluginException(prefix + ": " + e.getMessage(), e);
    }

    public static HivePrincipal getValidatedPrincipal(HivePrincipal hPrincipal) throws HiveAuthzPluginException {
        if (hPrincipal == null || hPrincipal.getType() == null) {
            return hPrincipal;
        }
        switch (hPrincipal.getType()) {
            case USER: {
                return hPrincipal;
            }
            case ROLE: {
                return new HivePrincipal(hPrincipal.getName().toLowerCase(), hPrincipal.getType());
            }
        }
        throw new HiveAuthzPluginException("Invalid principal type in principal " + hPrincipal);
    }

    public static List<HivePrincipal> getValidatedPrincipals(List<HivePrincipal> hivePrincipals) throws HiveAuthzPluginException {
        ListIterator<HivePrincipal> it = hivePrincipals.listIterator();
        while (it.hasNext()) {
            it.set(SQLAuthorizationUtils.getValidatedPrincipal(it.next()));
        }
        return hivePrincipals;
    }

    static HiveAuthzSessionContext applyTestSettings(HiveAuthzSessionContext ctx, HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE) && ctx.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI) {
            HiveAuthzSessionContext.Builder ctxBuilder = new HiveAuthzSessionContext.Builder(ctx);
            ctxBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2);
            return ctxBuilder.build();
        }
        return ctx;
    }
}

