/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncPowerDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncPowerLongToDouble;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="power,pow", value="_FUNC_(x1, x2) - raise x1 to the power of x2", extended="Example:\n  > SELECT _FUNC_(2, 3) FROM src LIMIT 1;\n  8")
@VectorizedExpressions(value={FuncPowerLongToDouble.class, FuncPowerDoubleToDouble.class})
public class GenericUDFPower
extends GenericUDF {
    private final String opName;
    private transient PrimitiveObjectInspector baseOI;
    private transient PrimitiveObjectInspector powerOI;
    protected transient PrimitiveObjectInspector resultOI;
    private transient ObjectInspectorConverters.Converter baseConverter;
    private transient ObjectInspectorConverters.Converter powerConverter;
    private final DoubleWritable doubleWritable = new DoubleWritable();

    public GenericUDFPower() {
        this.opName = this.getClass().getSimpleName();
        this.resultOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.opName + " requires two arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            ObjectInspector.Category category = arguments[i].getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentTypeException(i, "The " + GenericUDFUtils.getOrdinal(i + 1) + " argument of " + this.opName + "  is expected to a " + ObjectInspector.Category.PRIMITIVE.toString().toLowerCase() + " type, but " + category.toString().toLowerCase() + " is found");
        }
        this.baseOI = (PrimitiveObjectInspector)arguments[0];
        if (!FunctionRegistry.isNumericType(this.baseOI.getTypeInfo())) {
            throw new UDFArgumentTypeException(0, "The " + GenericUDFUtils.getOrdinal(1) + " argument of " + this.opName + "  is expected to a " + "numeric type, but " + this.baseOI.getTypeName() + " is found");
        }
        this.powerOI = (PrimitiveObjectInspector)arguments[1];
        if (!FunctionRegistry.isNumericType(this.powerOI.getTypeInfo())) {
            throw new UDFArgumentTypeException(1, "The " + GenericUDFUtils.getOrdinal(2) + " argument of " + this.opName + "  is expected to a " + "numeric type, but " + this.powerOI.getTypeName() + " is found");
        }
        this.baseConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.baseOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        this.powerConverter = ObjectInspectorConverters.getConverter((ObjectInspector)this.powerOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        return this.resultOI;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return this.getStandardDisplayString("power", children);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null || arguments[1] == null) {
            return null;
        }
        Object base = arguments[0].get();
        Object power = arguments[1].get();
        if (base == null && power == null) {
            return null;
        }
        if ((base = this.baseConverter.convert(base)) == null) {
            return null;
        }
        if ((power = this.powerConverter.convert(power)) == null) {
            return null;
        }
        this.doubleWritable.set(Math.pow(((DoubleWritable)base).get(), ((DoubleWritable)power).get()));
        return this.doubleWritable;
    }
}

