/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.hive;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;

public class HiveShims {
    public static String normalizeOrcVersionName(String version) {
        return OrcFile.Version.byName((String)version).getName();
    }

    public static void addLessThanOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThan(columnName, value);
    }

    public static void addLessThanEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.lessThanEquals(columnName, value);
    }

    public static void addEqualsOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object value) {
        builder.equals(columnName, value);
    }

    public static void addBetweenOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType, Object low, Object high) {
        builder.between(columnName, low, high);
    }

    public static void addIsNullOpToBuilder(SearchArgument.Builder builder, String columnName, PredicateLeaf.Type columnType) {
        builder.isNull(columnName);
    }

    public static Class[] getOrcDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{OrcFile.class, HiveConf.class, AbstractSerDe.class, HadoopShims.class, HadoopShimsSecure.class, hadoopVersionShimsClass, Input.class};
    }

    public static Class[] getHiveUDFDependentClasses(Class hadoopVersionShimsClass) {
        return new Class[]{GenericUDF.class, PrimitiveObjectInspector.class, HiveConf.class, Serializer.class, ShimLoader.class, hadoopVersionShimsClass, HadoopShimsSecure.class, Collector.class};
    }

    public static Object getSearchArgObjValue(Object value) {
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof DateTime) {
            return new Timestamp(((DateTime)value).getMillis());
        }
        return value;
    }

    public static void setOrcConfigOnJob(Job job, Long stripeSize, Integer rowIndexStride, Integer bufferSize, Boolean blockPadding, CompressionKind compress, String versionName) {
        if (stripeSize != null) {
            job.getConfiguration().setLong(HiveConf.ConfVars.HIVE_ORC_DEFAULT_STRIPE_SIZE.varname, stripeSize.longValue());
        }
        if (rowIndexStride != null) {
            job.getConfiguration().setInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE.varname, rowIndexStride.intValue());
        }
        if (bufferSize != null) {
            job.getConfiguration().setInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BUFFER_SIZE.varname, bufferSize.intValue());
        }
        if (blockPadding != null) {
            job.getConfiguration().setBoolean(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING.varname, blockPadding.booleanValue());
        }
        if (compress != null) {
            job.getConfiguration().set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, compress.toString());
        }
        if (versionName != null) {
            job.getConfiguration().set(HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT.varname, versionName);
        }
    }

    public static GenericUDAFParameterInfo newSimpleGenericUDAFParameterInfo(ObjectInspector[] arguments, boolean distinct, boolean allColumns) {
        return new SimpleGenericUDAFParameterInfo(arguments, distinct, allColumns);
    }

    public static class TimestampWritableShim {
        public static boolean isAssignableFrom(Object object) {
            return object instanceof TimestampWritable;
        }

        public static TimestampWritable cast(Object ts) {
            return (TimestampWritable)ts;
        }

        public static long millisFromTimestampWritable(Object ts) {
            return TimestampWritableShim.cast(ts).getTimestamp().getTime();
        }
    }

    public static class TimestampShim {
        public static Timestamp cast(Object ts) {
            return (Timestamp)ts;
        }

        public static long millisFromTimestamp(Object ts) {
            return TimestampShim.cast(ts).getTime();
        }
    }

    public static class DateShim {
        public static Date cast(Object ts) {
            return (Date)ts;
        }

        public static long millisFromDate(Object ts) {
            return DateShim.cast(ts).getTime();
        }
    }

    public static class PigJodaTimeStampObjectInspector
    extends AbstractPrimitiveJavaObjectInspector
    implements TimestampObjectInspector {
        public PigJodaTimeStampObjectInspector() {
            super(TypeInfoFactory.timestampTypeInfo);
        }

        public TimestampWritable getPrimitiveWritableObject(Object o) {
            return o == null ? null : new TimestampWritable(new Timestamp(((DateTime)o).getMillis()));
        }

        public Timestamp getPrimitiveJavaObject(Object o) {
            return o == null ? null : new Timestamp(((DateTime)o).getMillis());
        }
    }
}

