/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.avro.Schema;
import org.apache.avro.mapred.tether.TetherJob;
import org.apache.avro.tool.Tool;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;

public class TetherTool
implements Tool {
    public TetherJob job;

    @Override
    public String getName() {
        return "tether";
    }

    @Override
    public String getShortDescription() {
        return "Run a tethered mapreduce job.";
    }

    @Override
    public int run(InputStream ins, PrintStream outs, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec exec = p.accepts("program", "executable program, usually in HDFS").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec in = p.accepts("in", "comma-separated input paths").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec out = p.accepts("out", "output directory").withRequiredArg().ofType(Path.class);
        ArgumentAcceptingOptionSpec outSchema = p.accepts("outschema", "output schema file").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec mapOutSchema = p.accepts("outschemamap", "map output schema file, if different").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec reduces = p.accepts("reduces", "number of reduces").withOptionalArg().ofType(Integer.class);
        JobConf job = new JobConf();
        try {
            OptionSet opts = p.parse(args.toArray(new String[0]));
            FileInputFormat.addInputPaths((JobConf)job, (String)((String)in.value(opts)));
            FileOutputFormat.setOutputPath((JobConf)job, (Path)((Path)out.value(opts)));
            TetherJob.setExecutable((JobConf)job, (File)((File)exec.value(opts)));
            job.set("avro.output.schema", Schema.parse((File)((File)outSchema.value(opts))).toString());
            if (opts.hasArgument((OptionSpec)mapOutSchema)) {
                job.set("avro.map.output.schema", Schema.parse((File)((File)mapOutSchema.value(opts))).toString());
            }
            if (opts.hasArgument((OptionSpec)reduces)) {
                job.setNumReduceTasks(((Integer)reduces.value(opts)).intValue());
            }
        }
        catch (Exception e) {
            p.printHelpOn((OutputStream)err);
            return -1;
        }
        TetherJob.runJob((JobConf)job);
        return 0;
    }
}

