/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.RequestHedgingProxyProvider;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestConfiguredFailoverProxyProvider {
    private Configuration conf;
    private int rpcPort = 8020;
    private URI ns1Uri;
    private URI ns2Uri;
    private String ns1;
    private String ns1nn1Hostname = "machine1.foo.bar";
    private InetSocketAddress ns1nn1 = new InetSocketAddress(this.ns1nn1Hostname, this.rpcPort);
    private String ns1nn2Hostname = "machine2.foo.bar";
    private InetSocketAddress ns1nn2 = new InetSocketAddress(this.ns1nn2Hostname, this.rpcPort);
    private String ns2;
    private String ns2nn1Hostname = "router1.foo.bar";
    private InetSocketAddress ns2nn1 = new InetSocketAddress(this.ns2nn1Hostname, this.rpcPort);
    private String ns2nn2Hostname = "router2.foo.bar";
    private InetSocketAddress ns2nn2 = new InetSocketAddress(this.ns2nn2Hostname, this.rpcPort);
    private String ns2nn3Hostname = "router3.foo.bar";
    private InetSocketAddress ns2nn3 = new InetSocketAddress(this.ns2nn3Hostname, this.rpcPort);
    private static final int NUM_ITERATIONS = 50;

    @BeforeClass
    public static void setupClass() throws Exception {
        GenericTestUtils.setLogLevel((Logger)RequestHedgingProxyProvider.LOG, (Level)Level.TRACE);
    }

    @Before
    public void setup() throws URISyntaxException {
        this.ns1 = "mycluster-1-" + Time.monotonicNow();
        this.ns1Uri = new URI("hdfs://" + this.ns1);
        this.conf = new Configuration();
        this.conf.set("dfs.ha.namenodes." + this.ns1, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns1 + ".nn1", this.ns1nn1Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns1 + ".nn2", this.ns1nn2Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.client.failover.proxy.provider." + this.ns1, ConfiguredFailoverProxyProvider.class.getName());
        this.conf.setBoolean("dfs.client.failover.random.order." + this.ns1, false);
        this.ns2 = "myroutercluster-2-" + Time.monotonicNow();
        this.ns2Uri = new URI("hdfs://" + this.ns2);
        this.conf.set("dfs.ha.namenodes." + this.ns2, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn1", this.ns2nn1Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn2", this.ns2nn2Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.namenode.rpc-address." + this.ns2 + ".nn3", this.ns2nn3Hostname + ":" + this.rpcPort);
        this.conf.set("dfs.client.failover.proxy.provider." + this.ns2, ConfiguredFailoverProxyProvider.class.getName());
        this.conf.setBoolean("dfs.client.failover.random.order." + this.ns2, true);
        this.conf.set("dfs.nameservices", this.ns1 + "," + this.ns2);
        this.conf.set("fs.defaultFS", "hdfs://" + this.ns1);
    }

    @Test
    public void testNonRandomGetProxy() throws Exception {
        AtomicInteger nn1Count = new AtomicInteger(0);
        AtomicInteger nn2Count = new AtomicInteger(0);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        ClientProtocol nn1Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenAnswer(this.createAnswer(nn1Count, 1L));
        proxyMap.put(this.ns1nn1, nn1Mock);
        ClientProtocol nn2Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn2Mock.getStats()).thenAnswer(this.createAnswer(nn2Count, 2L));
        proxyMap.put(this.ns1nn2, nn2Mock);
        ConfiguredFailoverProxyProvider provider1 = new ConfiguredFailoverProxyProvider(this.conf, this.ns1Uri, ClientProtocol.class, this.createFactory(proxyMap));
        ClientProtocol proxy1 = (ClientProtocol)provider1.getProxy().proxy;
        proxy1.getStats();
        Assert.assertEquals((long)1L, (long)nn1Count.get());
        Assert.assertEquals((long)0L, (long)nn2Count.get());
        proxy1.getStats();
        Assert.assertEquals((long)2L, (long)nn1Count.get());
        Assert.assertEquals((long)0L, (long)nn2Count.get());
        nn1Count.set(0);
        nn2Count.set(0);
        for (int i = 0; i < 50; ++i) {
            ConfiguredFailoverProxyProvider provider2 = new ConfiguredFailoverProxyProvider(this.conf, this.ns1Uri, ClientProtocol.class, this.createFactory(proxyMap));
            ClientProtocol proxy2 = (ClientProtocol)provider2.getProxy().proxy;
            proxy2.getStats();
        }
        Assert.assertEquals((long)50L, (long)nn1Count.get());
        Assert.assertEquals((long)0L, (long)nn2Count.get());
    }

    @Test
    public void testRandomGetProxy() throws Exception {
        AtomicInteger nn1Count = new AtomicInteger(0);
        AtomicInteger nn2Count = new AtomicInteger(0);
        AtomicInteger nn3Count = new AtomicInteger(0);
        HashMap<InetSocketAddress, ClientProtocol> proxyMap = new HashMap<InetSocketAddress, ClientProtocol>();
        ClientProtocol nn1Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn1Mock.getStats()).thenAnswer(this.createAnswer(nn1Count, 1L));
        proxyMap.put(this.ns2nn1, nn1Mock);
        ClientProtocol nn2Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn2Mock.getStats()).thenAnswer(this.createAnswer(nn2Count, 2L));
        proxyMap.put(this.ns2nn2, nn2Mock);
        ClientProtocol nn3Mock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)nn3Mock.getStats()).thenAnswer(this.createAnswer(nn3Count, 3L));
        proxyMap.put(this.ns2nn3, nn3Mock);
        for (int i = 0; i < 50; ++i) {
            ConfiguredFailoverProxyProvider provider = new ConfiguredFailoverProxyProvider(this.conf, this.ns2Uri, ClientProtocol.class, this.createFactory(proxyMap));
            ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
            proxy.getStats();
        }
        Assert.assertTrue((nn1Count.get() < 50 && nn1Count.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nn2Count.get() < 50 && nn2Count.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nn3Count.get() < 50 && nn3Count.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)50L, (long)(nn1Count.get() + nn2Count.get() + nn3Count.get()));
    }

    private Answer<long[]> createAnswer(final AtomicInteger counter, final long retVal) {
        return new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                return new long[]{retVal};
            }
        };
    }

    private HAProxyFactory<ClientProtocol> createFactory(Map<InetSocketAddress, ClientProtocol> proxies) {
        final Map<InetSocketAddress, ClientProtocol> proxyMap = proxies;
        return new HAProxyFactory<ClientProtocol>(){

            public ClientProtocol createProxy(Configuration cfg, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
                if (proxyMap.containsKey(nnAddr)) {
                    return (ClientProtocol)proxyMap.get(nnAddr);
                }
                throw new IOException("Name node address not found");
            }

            public ClientProtocol createProxy(Configuration cfg, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
                if (proxyMap.containsKey(nnAddr)) {
                    return (ClientProtocol)proxyMap.get(nnAddr);
                }
                throw new IOException("Name node address not found");
            }

            public void setAlignmentContext(AlignmentContext alignmentContext) {
            }
        };
    }
}

