/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestURLConnectionFactory {
    @Test
    public void testConnConfiguratior() throws IOException {
        final URL u = new URL("http://localhost");
        final ArrayList conns = Lists.newArrayList();
        URLConnectionFactory fc = new URLConnectionFactory(new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                Assert.assertEquals((Object)u, (Object)conn.getURL());
                conns.add(conn);
                return conn;
            }
        });
        fc.openConnection(u);
        Assert.assertEquals((long)1L, (long)conns.size());
    }

    @Test
    public void testSSLInitFailure() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.ssl.hostname.verifier", "foo");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(URLConnectionFactory.class));
        URLConnectionFactory.newDefaultURLConnectionFactory((Configuration)conf);
        Assert.assertTrue((String)"Expected log for ssl init failure not found!", (boolean)logs.getOutput().contains("Cannot load customized ssl related configuration"));
    }
}

