/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathAll
extends EvalFunc<Tuple> {
    private XPath xmlPath = null;
    private String xml = null;
    private Document document;
    private static boolean cache = true;
    private static boolean ignoreNamespace = true;
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    public static final String EMPTY_STRING = "";

    public Tuple exec(Tuple input) throws IOException {
        if (!this.isArgsValid(input)) {
            return null;
        }
        try {
            NodeList nodeEntries;
            String xml = (String)input.get(ARGUMENTS.XML_FILE.getPosition());
            if (xml == null) {
                this.warn("Error processing input, invalid parameter" + input, (Enum)PigWarning.UDF_WARNING_1);
                return null;
            }
            if (input.size() > 2) {
                cache = (Boolean)input.get(ARGUMENTS.CACHE.getPosition());
            }
            if (input.size() > 3) {
                ignoreNamespace = (Boolean)input.get(ARGUMENTS.IGNORE_NAMESPACE.getPosition());
            }
            if (!cache || this.xmlPath == null || !xml.equals(this.xml)) {
                InputSource source = new InputSource(new StringReader(xml));
                this.xml = xml;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.document = db.parse(source);
                XPathFactory xpathFactory = XPathFactory.newInstance();
                this.xmlPath = xpathFactory.newXPath();
            }
            String xpathString = (String)input.get(ARGUMENTS.XPATH.getPosition());
            if (ignoreNamespace) {
                xpathString = this.createNameSpaceIgnoreXpathString(xpathString);
            }
            if ((nodeEntries = (NodeList)this.xmlPath.compile(xpathString).evaluate(this.document, XPathConstants.NODESET)) == null) {
                return null;
            }
            Tuple resultTuple = tupleFactory.newTuple(nodeEntries.getLength());
            for (int nodeEntryIndex = 0; nodeEntryIndex < nodeEntries.getLength(); ++nodeEntryIndex) {
                String ELEMENT_NODE_SEPARATOR = ", ";
                Node node = nodeEntries.item(nodeEntryIndex);
                NodeList childNodes = node.getChildNodes();
                if (childNodes == null) continue;
                String nodeData = EMPTY_STRING;
                boolean dataFlag = false;
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    try {
                        Node subNode = childNodes.item(i);
                        if (subNode.getNodeType() == 1) {
                            if (subNode.getFirstChild().getNodeValue() == null) {
                                nodeData = nodeData.concat(", ");
                                nodeData = nodeData.concat(EMPTY_STRING);
                                dataFlag = true;
                                continue;
                            }
                            nodeData = nodeData.concat(", ");
                            nodeData = nodeData.concat(subNode.getFirstChild().getNodeValue());
                            dataFlag = true;
                            continue;
                        }
                        if (subNode.getNodeType() != 3 && subNode.getNodeType() != 2) continue;
                        nodeData = nodeData.concat(", ");
                        nodeData = nodeData.concat(subNode.getNodeValue());
                        dataFlag = true;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!dataFlag) continue;
                nodeData = nodeData.replaceFirst(", ", EMPTY_STRING);
                resultTuple.set(nodeEntryIndex, (Object)nodeData);
            }
            return resultTuple;
        }
        catch (Exception e) {
            this.warn("Error processing input " + input.getType(0), (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
    }

    private boolean isArgsValid(Tuple input) {
        if (input == null || input.size() <= 1) {
            this.warn("Error processing input, not enough parameters or null input" + input, (Enum)PigWarning.UDF_WARNING_1);
            return false;
        }
        if (input.size() > 4) {
            this.warn("Error processing input, too many parameters" + input, (Enum)PigWarning.UDF_WARNING_1);
            return false;
        }
        try {
            if (input.size() > 2 && !(input.get(ARGUMENTS.CACHE.getPosition()) instanceof Boolean)) {
                this.warn("Error processing input, invalid value in 3rd parameter" + input, (Enum)PigWarning.UDF_WARNING_1);
                return false;
            }
            if (input.size() > 3 && !(input.get(ARGUMENTS.IGNORE_NAMESPACE.getPosition()) instanceof Boolean)) {
                this.warn("Error processing input, invalid value in 4th parameter" + input, (Enum)PigWarning.UDF_WARNING_1);
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private String createNameSpaceIgnoreXpathString(String xpathString) {
        String QUERY_PREFIX = "//*";
        String LOCAL_PREFIX = "[local-name()='";
        String LOCAL_POSTFIX = "']";
        String SPLITTER = "/";
        try {
            String[] individualNodes;
            String xpathStringWithLocalName = EMPTY_STRING;
            for (String node : individualNodes = xpathString.split("/")) {
                xpathStringWithLocalName = xpathStringWithLocalName.concat("//*[local-name()='" + node + "']");
            }
            return xpathStringWithLocalName;
        }
        catch (Exception ex) {
            return xpathString;
        }
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        ArrayList<Schema.FieldSchema> fields = new ArrayList<Schema.FieldSchema>();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        Schema twoArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), twoArgInSchema));
        fields = new ArrayList();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 5));
        Schema threeArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), threeArgInSchema));
        fields = new ArrayList();
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 55));
        fields.add(new Schema.FieldSchema(null, 5));
        fields.add(new Schema.FieldSchema(null, 5));
        Schema fourArgInSchema = new Schema(fields);
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), fourArgInSchema));
        return funcList;
    }

    public static enum ARGUMENTS {
        XML_FILE(0),
        XPATH(1),
        CACHE(2),
        IGNORE_NAMESPACE(3);

        private int argument;

        private ARGUMENTS(int argument) {
            this.argument = argument;
        }

        int getPosition() {
            return this.argument;
        }
    }
}

