/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.log;

import java.io.PrintStream;
import org.joda.time.DateTime;
import org.jruby.util.log.Logger;
import org.jruby.util.log.ParameterizedWriter;

public class StandardErrorLogger
implements Logger {
    private final String loggerName;
    private boolean debug = false;
    private ParameterizedWriter writer;

    public StandardErrorLogger(String loggerName) {
        this.loggerName = loggerName;
        this.writer = new ParameterizedWriter(System.err);
    }

    public StandardErrorLogger(String loggerName, PrintStream stream) {
        this.loggerName = loggerName;
        this.writer = new ParameterizedWriter(stream);
    }

    @Override
    public String getName() {
        return this.loggerName;
    }

    @Override
    public void warn(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    @Override
    public void warn(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    @Override
    public void warn(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    @Override
    public void error(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    @Override
    public void error(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    @Override
    public void error(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    @Override
    public void info(String message2, Object ... args2) {
        this.write(message2, args2);
    }

    @Override
    public void info(Throwable throwable) {
        this.writeStackTrace(throwable);
    }

    @Override
    public void info(String message2, Throwable throwable) {
        this.write(message2, throwable);
    }

    @Override
    public void debug(String message2, Object ... args2) {
        if (this.debug) {
            this.write(message2, args2);
        }
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.debug) {
            this.writeStackTrace(throwable);
        }
    }

    @Override
    public void debug(String message2, Throwable throwable) {
        if (this.debug) {
            this.write(message2, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void setDebugEnable(boolean debug) {
        this.debug = debug;
    }

    private void write(String message2, Object[] args2) {
        this.writer.write(this.format(message2), args2);
    }

    private void write(String message2, Throwable throwable) {
        this.writer.write(this.format(message2), new Object[0]);
        this.writeStackTrace(throwable);
    }

    private void writeStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.writer.getStream());
    }

    private String format(String message2) {
        StringBuilder sb = new StringBuilder();
        sb.append(new DateTime(System.currentTimeMillis()).toString()).append(": ").append(this.loggerName).append(": ").append(message2);
        return sb.toString();
    }
}

