/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;
import org.apache.htrace.impl.MilliSpan;

public class Tracer {
    public static final Log LOG = LogFactory.getLog(Tracer.class);
    private static final Random random = new Random();
    private final List<SpanReceiver> receivers = new CopyOnWriteArrayList<SpanReceiver>();
    private static final ThreadLocal<Span> currentSpan = new ThreadLocal<Span>(){

        @Override
        protected Span initialValue() {
            return null;
        }
    };
    public static final TraceInfo DONT_TRACE = new TraceInfo(-1L, -1L);
    private static final long[] EMPTY_PARENT_ARRAY = new long[0];

    static long nonZeroRandom64() {
        long id;
        while ((id = random.nextLong()) == 0L) {
        }
        return id;
    }

    static void clientError(String str) {
        LOG.error(str);
        throw new RuntimeException(str);
    }

    public static Tracer getInstance() {
        return TracerHolder.INSTANCE;
    }

    protected Span createNew(String description) {
        Span parent = currentSpan.get();
        if (parent == null) {
            return new MilliSpan.Builder().begin(System.currentTimeMillis()).end(0L).description(description).traceId(Tracer.nonZeroRandom64()).parents(EMPTY_PARENT_ARRAY).spanId(Tracer.nonZeroRandom64()).build();
        }
        return parent.child(description);
    }

    protected boolean isTracing() {
        return currentSpan.get() != null;
    }

    protected Span currentSpan() {
        return currentSpan.get();
    }

    public void deliver(Span span) {
        for (SpanReceiver receiver : this.receivers) {
            receiver.receiveSpan(span);
        }
    }

    protected void addReceiver(SpanReceiver receiver) {
        this.receivers.add(receiver);
    }

    protected void removeReceiver(SpanReceiver receiver) {
        this.receivers.remove(receiver);
    }

    protected Span setCurrentSpan(Span span) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("setting current span " + span);
        }
        currentSpan.set(span);
        return span;
    }

    public TraceScope continueSpan(Span s) {
        Span oldCurrent = this.currentSpan();
        this.setCurrentSpan(s);
        return new TraceScope(s, oldCurrent);
    }

    protected int numReceivers() {
        return this.receivers.size();
    }

    private static class TracerHolder {
        private static final Tracer INSTANCE = new Tracer();

        private TracerHolder() {
        }
    }
}

