/*
 * Decompiled with CFR 0.152.
 */
package sdsu.logging;

import java.util.Enumeration;
import java.util.Vector;
import sdsu.logging.DebugMessage;
import sdsu.logging.FileLogger;
import sdsu.logging.LoggerImplementation;
import sdsu.logging.LoggerMessage;
import sdsu.logging.ScreenLogger;

public class Debug {
    static LoggerImplementation screen = new ScreenLogger();
    static LoggerImplementation file;
    static Vector activeLoggers;
    static boolean isDebugOn;

    static {
        activeLoggers = new Vector();
        isDebugOn = true;
        activeLoggers.addElement(screen);
    }

    public static void fileOn(String string, boolean bl) throws Exception {
        try {
            file = new FileLogger(string, bl);
            activeLoggers.addElement(file);
        }
        catch (Exception exception) {
            DebugMessage debugMessage = new DebugMessage("The following error occured trying to open the debug file: " + string + " " + exception.getMessage(), 1);
            screen.log(debugMessage);
        }
    }

    private static void logMessage(LoggerMessage loggerMessage) {
        if (isDebugOn) {
            Enumeration enumeration = activeLoggers.elements();
            while (enumeration.hasMoreElements()) {
                LoggerImplementation loggerImplementation = (LoggerImplementation)enumeration.nextElement();
                loggerImplementation.log(loggerMessage);
            }
        }
    }

    public static void off() {
        isDebugOn = false;
    }

    public static void on() {
        isDebugOn = true;
    }

    public static void println(char c) {
        Debug.logMessage(new DebugMessage(String.valueOf(c), 1));
    }

    public static void println(double d) {
        Debug.logMessage(new DebugMessage(String.valueOf(d), 1));
    }

    public static void println(float f) {
        Debug.logMessage(new DebugMessage(String.valueOf(f), 1));
    }

    public static void println(int n) {
        Debug.logMessage(new DebugMessage(String.valueOf(n), 1));
    }

    public static void println(long l) {
        Debug.logMessage(new DebugMessage(String.valueOf(l), 1));
    }

    public static void println(Object object) {
        Debug.logMessage(new DebugMessage(object.toString(), 1));
    }

    public static void println(String string) {
        Debug.logMessage(new DebugMessage(string, 1));
    }

    public static void println(boolean bl) {
        Debug.logMessage(new DebugMessage(String.valueOf(bl), 1));
    }

    public static void println(char[] cArray) {
        Debug.logMessage(new DebugMessage(String.valueOf((Object)cArray), 1));
    }

    public static void screenOff() {
        activeLoggers.removeElement(screen);
    }
}

