/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.server.util.AddressUtil;
import org.apache.hadoop.io.Text;

public class TServerInstance
implements Comparable<TServerInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    private InetSocketAddress location;
    private String session;
    private String cachedStringRepresentation;

    public TServerInstance(InetSocketAddress address, String session) {
        this.location = address;
        this.session = session;
        this.cachedStringRepresentation = this.hostPort() + "[" + session + "]";
    }

    public TServerInstance(InetSocketAddress address, long session) {
        this(address, Long.toHexString(session));
    }

    public TServerInstance(String address, long session) {
        this(AddressUtil.parseAddress(address, Property.TSERV_CLIENTPORT), Long.toHexString(session));
    }

    public TServerInstance(Value address, Text session) {
        this(AddressUtil.parseAddress(new String(address.get()), Property.TSERV_CLIENTPORT), session.toString());
    }

    public void putLocation(Mutation m) {
        m.put(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY, this.asColumnQualifier(), this.asMutationValue());
    }

    public void putFutureLocation(Mutation m) {
        m.put(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY, this.asColumnQualifier(), this.asMutationValue());
    }

    public void putLastLocation(Mutation m) {
        m.put(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY, this.asColumnQualifier(), this.asMutationValue());
    }

    public void clearLastLocation(Mutation m) {
        m.putDelete(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY, this.asColumnQualifier());
    }

    @Override
    public int compareTo(TServerInstance other) {
        if (this == other) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TServerInstance) {
            return this.compareTo((TServerInstance)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.cachedStringRepresentation;
    }

    public int port() {
        return this.getLocation().getPort();
    }

    public String host() {
        return this.getLocation().getAddress().getHostAddress();
    }

    public String hostPort() {
        return org.apache.accumulo.core.util.AddressUtil.toString((InetSocketAddress)this.getLocation());
    }

    public Text asColumnQualifier() {
        return new Text(this.getSession());
    }

    public Value asMutationValue() {
        return new Value(org.apache.accumulo.core.util.AddressUtil.toString((InetSocketAddress)this.getLocation()).getBytes());
    }

    public InetSocketAddress getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }
}

