/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state.tables;

import java.security.SecurityPermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.tables.TableObserver;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class TableManager {
    private static SecurityPermission TABLE_MANAGER_PERMISSION = new SecurityPermission("tableManagerPermission");
    private static final Logger log = Logger.getLogger(TableManager.class);
    private static final Set<TableObserver> observers = Collections.synchronizedSet(new HashSet());
    private static final Map<String, TableState> tableStateCache = Collections.synchronizedMap(new HashMap());
    private static TableManager tableManager = null;
    private final Instance instance = HdfsZooInstance.getInstance();
    private ZooCache zooStateCache = new ZooCache(new TableStateWatcher());

    public static void prepareNewTableState(String instanceId, String tableId, String tableName, TableState state, ZooUtil.NodeExistsPolicy existsPolicy) throws KeeperException, InterruptedException {
        String zTablePath = "/accumulo/" + instanceId + "/tables" + "/" + tableId;
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        zoo.putPersistentData(zTablePath, new byte[0], existsPolicy);
        zoo.putPersistentData(zTablePath + "/conf", new byte[0], existsPolicy);
        zoo.putPersistentData(zTablePath + "/name", tableName.getBytes(), existsPolicy);
        zoo.putPersistentData(zTablePath + "/state", state.name().getBytes(), existsPolicy);
        zoo.putPersistentData(zTablePath + "/flush-id", "0".getBytes(), existsPolicy);
        zoo.putPersistentData(zTablePath + "/compact-id", "0".getBytes(), existsPolicy);
        zoo.putPersistentData(zTablePath + "/compact-cancel-id", "0".getBytes(), existsPolicy);
    }

    public static synchronized TableManager getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLE_MANAGER_PERMISSION);
        }
        if (tableManager == null) {
            tableManager = new TableManager();
        }
        return tableManager;
    }

    private TableManager() {
        this.updateTableStateCache();
    }

    public TableState getTableState(String tableId) {
        return tableStateCache.get(tableId);
    }

    public synchronized void transitionTableState(final String tableId, final TableState newState) {
        String statePath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/tables" + "/" + tableId + "/state";
        try {
            ZooReaderWriter.getRetryingInstance().mutate(statePath, newState.name().getBytes(), ZooUtil.PUBLIC, new ZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] oldData) throws Exception {
                    TableState oldState = TableState.UNKNOWN;
                    if (oldData != null) {
                        oldState = TableState.valueOf((String)new String(oldData));
                    }
                    boolean transition = true;
                    switch (oldState) {
                        case NEW: {
                            transition = newState == TableState.OFFLINE || newState == TableState.ONLINE;
                            break;
                        }
                        case ONLINE: 
                        case UNKNOWN: 
                        case OFFLINE: {
                            transition = newState != TableState.NEW;
                            break;
                        }
                        case DELETING: {
                            transition = false;
                        }
                    }
                    if (!transition) {
                        throw new IllegalTableTransitionException(oldState, newState);
                    }
                    log.debug((Object)("Transitioning state for table " + tableId + " from " + oldState + " to " + newState));
                    return newState.name().getBytes();
                }
            });
        }
        catch (Exception e) {
            log.fatal((Object)("Failed to transition table to state " + newState));
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableStateCache() {
        Map<String, TableState> map = tableStateCache;
        synchronized (map) {
            for (String tableId : this.zooStateCache.getChildren(ZooUtil.getRoot((Instance)this.instance) + "/tables")) {
                if (this.zooStateCache.get(ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/" + tableId + "/state") == null) continue;
                this.updateTableStateCache(tableId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableState updateTableStateCache(String tableId) {
        Map<String, TableState> map = tableStateCache;
        synchronized (map) {
            TableState tState = TableState.UNKNOWN;
            byte[] data = this.zooStateCache.get(ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/" + tableId + "/state");
            if (data != null) {
                String sState = new String(data);
                try {
                    tState = TableState.valueOf((String)sState);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)("Unrecognized state for table with tableId=" + tableId + ": " + sState));
                }
                tableStateCache.put(tableId, tState);
            }
            return tState;
        }
    }

    public void addTable(String tableId, String tableName, ZooUtil.NodeExistsPolicy existsPolicy) throws KeeperException, InterruptedException {
        TableManager.prepareNewTableState(this.instance.getInstanceID(), tableId, tableName, TableState.NEW, existsPolicy);
        this.updateTableStateCache(tableId);
    }

    public void cloneTable(String srcTable, String tableId, String tableName, Map<String, String> propertiesToSet, Set<String> propertiesToExclude, ZooUtil.NodeExistsPolicy existsPolicy) throws KeeperException, InterruptedException {
        TableManager.prepareNewTableState(this.instance.getInstanceID(), tableId, tableName, TableState.NEW, existsPolicy);
        String srcTablePath = "/accumulo/" + this.instance.getInstanceID() + "/tables" + "/" + srcTable + "/conf";
        String newTablePath = "/accumulo/" + this.instance.getInstanceID() + "/tables" + "/" + tableId + "/conf";
        ZooReaderWriter.getRetryingInstance().recursiveCopyPersistent(srcTablePath, newTablePath, ZooUtil.NodeExistsPolicy.OVERWRITE);
        for (Map.Entry<String, String> entry : propertiesToSet.entrySet()) {
            TablePropUtil.setTableProperty(tableId, entry.getKey(), entry.getValue());
        }
        for (String prop : propertiesToExclude) {
            ZooReaderWriter.getRetryingInstance().recursiveDelete("/accumulo/" + this.instance.getInstanceID() + "/tables" + "/" + tableId + "/conf" + "/" + prop, ZooUtil.NodeMissingPolicy.SKIP);
        }
        this.updateTableStateCache(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTable(String tableId) throws KeeperException, InterruptedException {
        Map<String, TableState> map = tableStateCache;
        synchronized (map) {
            tableStateCache.remove(tableId);
            ZooReaderWriter.getRetryingInstance().recursiveDelete(ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/" + tableId + "/state", ZooUtil.NodeMissingPolicy.SKIP);
            ZooReaderWriter.getRetryingInstance().recursiveDelete(ZooUtil.getRoot((Instance)this.instance) + "/tables" + "/" + tableId, ZooUtil.NodeMissingPolicy.SKIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addObserver(TableObserver to) {
        Set<TableObserver> set = observers;
        synchronized (set) {
            Map<String, TableState> map = tableStateCache;
            synchronized (map) {
                to.initialize(Collections.unmodifiableMap(tableStateCache));
                return observers.add(to);
            }
        }
    }

    public boolean removeObserver(TableObserver to) {
        return observers.remove(to);
    }

    private class TableStateWatcher
    implements Watcher {
        private TableStateWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (log.isTraceEnabled()) {
                log.trace((Object)event);
            }
            String zPath = event.getPath();
            Watcher.Event.EventType zType = event.getType();
            String tablesPrefix = ZooUtil.getRoot((Instance)TableManager.this.instance) + "/tables";
            String tableId = null;
            if (zPath != null && zPath.startsWith(tablesPrefix + "/")) {
                String suffix = zPath.substring(tablesPrefix.length() + 1);
                if (suffix.contains("/")) {
                    String[] sa = suffix.split("/", 2);
                    if ("/state".equals("/" + sa[1])) {
                        tableId = sa[0];
                    }
                }
                if (tableId == null) {
                    log.warn((Object)("Unknown path in " + event));
                    return;
                }
            }
            block4 : switch (zType) {
                case NodeChildrenChanged: {
                    if (zPath != null && zPath.equals(tablesPrefix)) {
                        TableManager.this.updateTableStateCache();
                        break;
                    }
                    log.warn((Object)("Unexpected path " + zPath));
                    break;
                }
                case NodeCreated: 
                case NodeDataChanged: {
                    TableState tState = TableManager.this.updateTableStateCache(tableId);
                    log.debug((Object)("State transition to " + tState + " @ " + event));
                    Set set = observers;
                    synchronized (set) {
                        for (TableObserver to : observers) {
                            to.stateChanged(tableId, tState);
                        }
                        break;
                    }
                }
                case NodeDeleted: {
                    if (zPath == null || tableId == null || !zPath.equals(tablesPrefix + "/" + tableId + "/state") && !zPath.equals(tablesPrefix + "/" + tableId + "/conf") && !zPath.equals(tablesPrefix + "/" + tableId + "/name")) break;
                    tableStateCache.remove(tableId);
                    break;
                }
                case None: {
                    Set set;
                    switch (event.getState()) {
                        case Expired: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Session expired " + event));
                            }
                            set = observers;
                            synchronized (set) {
                                for (TableObserver to : observers) {
                                    to.sessionExpired();
                                }
                                break block4;
                            }
                        }
                        default: {
                            if (!log.isTraceEnabled()) break block4;
                        }
                    }
                    log.trace((Object)("Ignored " + event));
                    break;
                }
                default: {
                    log.warn((Object)("Unandled " + event));
                }
            }
        }
    }

    public static class IllegalTableTransitionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final TableState oldState;
        final TableState newState;

        public IllegalTableTransitionException(TableState oldState, TableState newState) {
            this.oldState = oldState;
            this.newState = newState;
        }

        public TableState getOldState() {
            return this.oldState;
        }

        public TableState getNewState() {
            return this.newState;
        }
    }
}

