/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.monitor.util.celltypes;

import org.apache.accumulo.core.util.Duration;
import org.apache.accumulo.server.monitor.util.celltypes.NumberType;

public class DurationType
extends NumberType<Long> {
    private Long errMin;
    private Long errMax;

    public DurationType() {
        this(null, null);
    }

    public DurationType(Long errMin, Long errMax) {
        this.errMin = errMin;
        this.errMax = errMax;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        Long millis = (Long)obj;
        if (this.errMin != null && this.errMax != null) {
            return DurationType.seconds(millis, this.errMin, this.errMax);
        }
        return Duration.format((long)millis);
    }

    private static String seconds(long secs, long errMin, long errMax) {
        String numbers = Duration.format((long)secs);
        if (secs < errMin || secs > errMax) {
            return "<span class='error'>" + numbers + "</span>";
        }
        return numbers;
    }
}

