/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import org.apache.accumulo.core.tabletserver.thrift.ActionStats;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;

public class TabletStatsKeeper {
    private ActionStats major = new ActionStats();
    private ActionStats minor = new ActionStats();
    private ActionStats split = new ActionStats();
    private ActionStats[] map = new ActionStats[]{this.major, this.split, this.minor};

    public static void update(ActionStats summary, ActionStats td) {
        summary.status += td.status;
        summary.elapsed += td.elapsed;
        summary.num += td.num;
        summary.count += td.count;
        summary.sumDev += td.sumDev;
        summary.queueTime += td.queueTime;
        summary.queueSumDev += td.queueSumDev;
        summary.fail += td.fail;
    }

    public void updateTime(Operation operation, long queued, long start, long count, boolean failed) {
        try {
            ActionStats data = this.map[operation.ordinal()];
            if (failed) {
                ++data.fail;
                --data.status;
            } else {
                double t = (double)(System.currentTimeMillis() - start) / 1000.0;
                double q = (double)(start - queued) / 1000.0;
                --data.status;
                data.count += count;
                ++data.num;
                data.elapsed += t;
                data.queueTime += q;
                data.sumDev += t * t;
                data.queueSumDev += q * q;
                if (data.elapsed < 0.0 || data.sumDev < 0.0 || data.queueSumDev < 0.0 || data.queueTime < 0.0) {
                    this.resetTimes();
                }
            }
        }
        catch (Exception E) {
            this.resetTimes();
        }
    }

    public void updateTime(Operation operation, long start, long count, boolean failed) {
        try {
            ActionStats data = this.map[operation.ordinal()];
            if (failed) {
                ++data.fail;
                --data.status;
            } else {
                double t = (double)(System.currentTimeMillis() - start) / 1000.0;
                --data.status;
                ++data.num;
                data.elapsed += t;
                data.sumDev += t * t;
                if (data.elapsed < 0.0 || data.sumDev < 0.0 || data.queueSumDev < 0.0 || data.queueTime < 0.0) {
                    this.resetTimes();
                }
            }
        }
        catch (Exception E) {
            this.resetTimes();
        }
    }

    public void saveMinorTimes(TabletStatsKeeper t) {
        TabletStatsKeeper.update(this.minor, t.minor);
    }

    public void saveMajorTimes(TabletStatsKeeper t) {
        TabletStatsKeeper.update(this.major, t.major);
    }

    public void resetTimes() {
        this.major = new ActionStats();
        this.split = new ActionStats();
        this.minor = new ActionStats();
    }

    public void incrementStatusMinor() {
        ++this.minor.status;
    }

    public void incrementStatusMajor() {
        ++this.major.status;
    }

    public void incrementStatusSplit() {
        ++this.split.status;
    }

    public TabletStats getTabletStats() {
        return new TabletStats(null, this.major, this.minor, this.split, 0L, 0.0, 0.0, 0L);
    }

    public static enum Operation {
        MAJOR,
        SPLIT,
        MINOR;

    }
}

