/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;

public class StatisticsDisplayFormatter
extends DefaultFormatter {
    private Map<String, Long> classifications = new HashMap<String, Long>();
    private Map<String, Long> columnFamilies = new HashMap<String, Long>();
    private Map<String, Long> columnQualifiers = new HashMap<String, Long>();
    private long total = 0L;

    @Override
    public String next() {
        Iterator<Map.Entry<Key, Value>> si = super.getScannerIterator();
        StatisticsDisplayFormatter.checkState(si, true);
        while (si.hasNext()) {
            this.aggregateStats(si.next());
        }
        return this.getStats();
    }

    private void aggregateStats(Map.Entry<Key, Value> entry) {
        String key;
        Long count = this.classifications.get(key = entry.getKey().getColumnVisibility().toString());
        this.classifications.put(key, count != null ? count + 1L : 0L);
        key = entry.getKey().getColumnFamily().toString();
        count = this.columnFamilies.get(key);
        this.columnFamilies.put(key, count != null ? count + 1L : 0L);
        key = entry.getKey().getColumnQualifier().toString();
        count = this.columnQualifiers.get(key);
        this.columnQualifiers.put(key, count != null ? count + 1L : 0L);
        ++this.total;
    }

    private String getStats() {
        StringBuilder buf = new StringBuilder();
        buf.append("CLASSIFICATIONS:\n");
        buf.append("----------------\n");
        for (String key : this.classifications.keySet()) {
            buf.append("\t").append(key).append(": ").append(this.classifications.get(key)).append("\n");
        }
        buf.append("COLUMN FAMILIES:\n");
        buf.append("----------------\n");
        for (String key : this.columnFamilies.keySet()) {
            buf.append("\t").append(key).append(": ").append(this.columnFamilies.get(key)).append("\n");
        }
        buf.append("COLUMN QUALIFIERS:\n");
        buf.append("------------------\n");
        for (String key : this.columnQualifiers.keySet()) {
            buf.append("\t").append(key).append(": ").append(this.columnQualifiers.get(key)).append("\n");
        }
        buf.append(this.total).append(" entries matched.");
        this.total = 0L;
        this.classifications = new HashMap<String, Long>();
        this.columnFamilies = new HashMap<String, Long>();
        this.columnQualifiers = new HashMap<String, Long>();
        return buf.toString();
    }
}

