/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUp
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(CleanUp.class);
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String namespaceId;
    private long creationTime;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (System.currentTimeMillis() < this.creationTime) {
            this.creationTime = System.currentTimeMillis();
        }
    }

    public CleanUp(String tableId, String namespaceId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (!master.hasCycled(this.creationTime)) {
            return 50L;
        }
        boolean done = true;
        Range tableRange = new KeyExtent(this.tableId, null, null).toMetadataRange();
        Scanner scanner = master.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)master);
        scanner.setRange(tableRange);
        for (Map.Entry entry : scanner) {
            TabletLocationState locationState = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            TabletState state = locationState.getState(master.onlineTabletServers());
            if (state.equals((Object)TabletState.UNASSIGNED)) continue;
            log.debug("Still waiting for table({}) to be deleted; Target tablet state: UNASSIGNED, Current tablet state: {}, locationState: {}", new Object[]{this.tableId, state, locationState});
            done = false;
            break;
        }
        if (!done) {
            return 50L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        master.clearMigrations(this.tableId);
        int refCount = 0;
        try {
            Connector conn = master.getConnector();
            try (BatchScanner bs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 8);){
                Range allTables = MetadataSchema.TabletsSection.getRange();
                Range tableRange = MetadataSchema.TabletsSection.getRange((String)this.tableId);
                Range beforeTable = new Range(allTables.getStartKey(), true, tableRange.getStartKey(), false);
                Range afterTable = new Range(tableRange.getEndKey(), false, allTables.getEndKey(), true);
                bs.setRanges(Arrays.asList(beforeTable, afterTable));
                bs.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                IteratorSetting cfg = new IteratorSetting(40, "grep", GrepIterator.class);
                GrepIterator.setTerm((IteratorSetting)cfg, (String)("/" + this.tableId + "/"));
                bs.addScanIterator(cfg);
                for (Map.Entry entry : bs) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains("/" + this.tableId + "/")) continue;
                    ++refCount;
                }
            }
        }
        catch (Exception e) {
            refCount = -1;
            log.error("Failed to scan accumulo.metadata looking for references to deleted table " + this.tableId, (Throwable)e);
        }
        try {
            MetadataTableUtil.deleteTable((String)this.tableId, (refCount != 0 ? 1 : 0) != 0, (ClientContext)master, null);
        }
        catch (Exception e) {
            log.error("error deleting " + this.tableId + " from metadata table", (Throwable)e);
        }
        try {
            ProblemReports.getInstance((AccumuloServerContext)master).deleteProblemReports(this.tableId);
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + this.tableId, (Throwable)e);
        }
        if (refCount == 0) {
            AccumuloConfiguration conf = master.getConfiguration();
            boolean archiveFiles = conf.getBoolean(Property.GC_FILE_ARCHIVE);
            try {
                VolumeManager fs = master.getFileSystem();
                for (String dir : ServerConstants.getTablesDirs()) {
                    if (archiveFiles) {
                        this.archiveFile(fs, dir, this.tableId);
                        continue;
                    }
                    fs.deleteRecursively(new Path(dir, this.tableId));
                }
            }
            catch (IOException e) {
                log.error("Unable to remove deleted table directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.error("Unable to remove deleted table directory", (Throwable)exception);
                }
                throw exception;
            }
        }
        try {
            TableManager.getInstance().removeTable(this.tableId);
            Tables.clearCache((Instance)master.getInstance());
        }
        catch (Exception e) {
            log.error("Failed to find table id in zookeeper", (Throwable)e);
        }
        try {
            AuditedSecurityOperation.getInstance((AccumuloServerContext)master).deleteTable(master.rpcCreds(), this.tableId, this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveTable(this.tableId, tid, true);
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        LoggerFactory.getLogger(CleanUp.class).debug("Deleted table " + this.tableId);
        return null;
    }

    protected void archiveFile(VolumeManager fs, String dir, String tableId) throws IOException {
        Path tableDirectory = new Path(dir, tableId);
        Volume v = fs.getVolumeByPath(tableDirectory);
        String basePath = v.getBasePath();
        String tableDirPath = tableDirectory.toUri().getPath();
        String tableDirSuffix = tableDirPath.substring(basePath.length());
        if ('/' == tableDirSuffix.charAt(0)) {
            tableDirSuffix = tableDirSuffix.length() > 1 ? tableDirSuffix.substring(1) : "";
        }
        Path fileArchiveDir = new Path(basePath, "fileArchive");
        fs.mkdirs(fileArchiveDir);
        Path destTableDir = new Path(fileArchiveDir, tableDirSuffix);
        log.debug("Archiving " + tableDirectory + " to " + tableDirectory);
        if (fs.exists(destTableDir)) {
            this.merge(fs, tableDirectory, destTableDir);
        } else {
            fs.rename(tableDirectory, destTableDir);
        }
    }

    protected void merge(VolumeManager fs, Path src, Path dest) throws IOException {
        for (FileStatus child : fs.listStatus(src)) {
            String childName = child.getPath().getName();
            Path childInSrc = new Path(src, childName);
            Path childInDest = new Path(dest, childName);
            if (child.isFile()) {
                if (fs.exists(childInDest)) {
                    log.warn("File already exists in archive, ignoring. " + childInDest);
                    continue;
                }
                fs.rename(childInSrc, childInDest);
                continue;
            }
            if (child.isDirectory()) {
                if (fs.exists(childInDest)) {
                    this.merge(fs, childInSrc, childInDest);
                    continue;
                }
                fs.rename(childInSrc, childInDest);
                continue;
            }
            log.warn("Ignoring archiving of non file/directory: " + child);
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

