/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, SmallTests.class})
public class TestZNodePaths {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZNodePaths.class);

    @Test
    public void testIsClientReadable() {
        ZNodePaths znodePaths = new ZNodePaths(HBaseConfiguration.create());
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.baseZNode));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.getZNodeForReplica(0)));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.masterAddressZNode));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.clusterIdZNode));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.tableZNode));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(ZNodePaths.joinZNode((String)znodePaths.tableZNode, (String)"foo")));
        Assert.assertTrue((boolean)znodePaths.isClientReadable(znodePaths.rsZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.balancerZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.regionNormalizerZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.clusterStateZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.drainingZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.splitLogZNode));
        Assert.assertFalse((boolean)znodePaths.isClientReadable(znodePaths.backupMasterAddressesZNode));
    }
}

