/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.ReflectionUtils;

@InterfaceAudience.Private
public final class RelocalizationUtils {
    private RelocalizationUtils() {
    }

    public static List<URL> processAdditionalResources(Map<String, URI> additionalResources, Configuration conf, String destDir) throws IOException {
        if (additionalResources == null || additionalResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList urls = Lists.newArrayListWithCapacity((int)additionalResources.size());
        for (Map.Entry<String, URI> lrEntry : additionalResources.entrySet()) {
            Path dFile = RelocalizationUtils.downloadResource(lrEntry.getKey(), lrEntry.getValue(), conf, destDir);
            urls.add(dFile.toUri().toURL());
        }
        return urls;
    }

    public static void addUrlsToClassPath(List<URL> urls) {
        ReflectionUtils.addResourcesToSystemClassLoader(urls);
    }

    private static Path downloadResource(String destName, URI uri, Configuration conf, String destDir) throws IOException {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Path cwd = new Path(destDir);
        Path dFile = new Path(cwd, destName);
        Path srcPath = new Path(uri);
        fs.copyToLocalFile(srcPath, dFile);
        return dFile.makeQualified(FileSystem.getLocal((Configuration)conf).getUri(), cwd);
    }
}

