/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
public class TestHBaseClassTestRule {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseClassTestRule.class);

    @Test
    public void testNumParameters() {
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(NonParameterizedClass.class), (int)1);
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ParameterizedClassWithNoParametersMethod.class), (int)1);
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(InValidParameterizedClass.class), (int)1);
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ValidParameterizedClass1.class), (int)ValidParameterizedClass1.parameters().size());
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ValidParameterizedClass2.class), (int)ValidParameterizedClass2.parameters().length);
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ValidParameterizedClass3.class), (int)Iterables.size(ValidParameterizedClass3.parameters()));
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ValidParameterizedClass4.class), (int)ValidParameterizedClass4.parameters().size());
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ExtendedParameterizedClass1.class), (int)ValidParameterizedClass1.parameters().size());
        TestCase.assertEquals((int)HBaseClassTestRule.getNumParameters(ExtendedParameterizedClass2.class), (int)ExtendedParameterizedClass2.parameters().size());
    }

    @RunWith(value=Parameterized.class)
    private static class ExtendedParameterizedClass2
    extends ValidParameterizedClass1 {
        private ExtendedParameterizedClass2() {
        }

        @Parameterized.Parameters
        public static List<Object> parameters() {
            return Arrays.asList(1, 2, 3);
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ExtendedParameterizedClass1
    extends ValidParameterizedClass1 {
        private ExtendedParameterizedClass1() {
        }

        int dummy2(int a) {
            return 0;
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ValidParameterizedClass4 {
        private ValidParameterizedClass4() {
        }

        @Parameterized.Parameters
        public static Collection<Integer> parameters() {
            return Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ValidParameterizedClass3 {
        private ValidParameterizedClass3() {
        }

        @Parameterized.Parameters
        public static Iterable<Integer> parameters() {
            return Arrays.asList(1, 2, 3, 4, 5, 6, 7);
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ValidParameterizedClass2 {
        private ValidParameterizedClass2() {
        }

        @Parameterized.Parameters
        public static Object[] parameters() {
            return new Integer[]{1, 2, 3, 4, 5, 6};
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ValidParameterizedClass1 {
        private ValidParameterizedClass1() {
        }

        @Parameterized.Parameters
        public static List<Object> parameters() {
            return Arrays.asList(1, 2, 3, 4, 5);
        }

        int dummy(int a) {
            return 0;
        }
    }

    @RunWith(value=Parameterized.class)
    private static class InValidParameterizedClass {
        private InValidParameterizedClass() {
        }

        @Parameterized.Parameters
        private static List<Object> parameters() {
            return Arrays.asList(1, 2, 3, 4);
        }

        int dummy(int a) {
            return 0;
        }
    }

    @RunWith(value=Parameterized.class)
    private static class ParameterizedClassWithNoParametersMethod {
        private ParameterizedClassWithNoParametersMethod() {
        }

        void dummy() {
        }
    }

    private static class NonParameterizedClass {
        private NonParameterizedClass() {
        }

        void dummy() {
        }

        int dummy(int a) {
            return 0;
        }
    }
}

