/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.nio.ByteBuffer;

public abstract class BufferAllocator {
    private boolean usingDirect = false;

    public BufferAllocator(boolean usingDirect) {
        this.usingDirect = usingDirect;
    }

    protected boolean isUsingDirect() {
        return this.usingDirect;
    }

    public abstract ByteBuffer allocate(int var1);

    public static class SlicedBufferAllocator
    extends BufferAllocator {
        private ByteBuffer overallBuffer;

        public SlicedBufferAllocator(boolean usingDirect, int totalBufferLen) {
            super(usingDirect);
            this.overallBuffer = this.isUsingDirect() ? ByteBuffer.allocateDirect(totalBufferLen) : ByteBuffer.allocate(totalBufferLen);
        }

        @Override
        public ByteBuffer allocate(int bufferLen) {
            if (bufferLen > this.overallBuffer.capacity() - this.overallBuffer.position()) {
                return this.isUsingDirect() ? ByteBuffer.allocateDirect(bufferLen) : ByteBuffer.allocate(bufferLen);
            }
            this.overallBuffer.limit(this.overallBuffer.position() + bufferLen);
            ByteBuffer result = this.overallBuffer.slice();
            this.overallBuffer.position(this.overallBuffer.position() + bufferLen);
            return result;
        }
    }

    public static class SimpleBufferAllocator
    extends BufferAllocator {
        public SimpleBufferAllocator(boolean usingDirect) {
            super(usingDirect);
        }

        @Override
        public ByteBuffer allocate(int bufferLen) {
            return this.isUsingDirect() ? ByteBuffer.allocateDirect(bufferLen) : ByteBuffer.allocate(bufferLen);
        }
    }
}

