/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.util.Shell;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;

public class TestDomainSocket {
    private static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void init() {
        sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
    }

    @AfterClass
    public static void shutdown() throws IOException {
        sockDir.close();
    }

    @Before
    public void before() {
        Assume.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
    }

    @Test(timeout=180000L)
    public void testSocketCreateAndClose() throws IOException {
        DomainSocket serv = DomainSocket.bindAndListen((String)new File(sockDir.getDir(), "test_sock_create_and_close").getAbsolutePath());
        serv.close();
    }

    @Test(timeout=180000L)
    public void testSocketPathSetGet() throws IOException {
        Assert.assertEquals((Object)"/var/run/hdfs/sock.100", (Object)DomainSocket.getEffectivePath((String)"/var/run/hdfs/sock._PORT", (int)100));
    }

    @Test(timeout=180000L)
    public void testSocketReadEof() throws Exception {
        String TEST_PATH = new File(sockDir.getDir(), "testSocketReadEof").getAbsolutePath();
        final DomainSocket serv = DomainSocket.bindAndListen((String)TEST_PATH);
        ExecutorService exeServ = Executors.newSingleThreadExecutor();
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                DomainSocket conn;
                try {
                    conn = serv.accept();
                }
                catch (IOException e) {
                    throw new RuntimeException("unexpected IOException", e);
                }
                byte[] buf = new byte[100];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = 0;
                }
                try {
                    Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
                }
                catch (IOException e) {
                    throw new RuntimeException("unexpected IOException", e);
                }
                return null;
            }
        };
        Future<Void> future = exeServ.submit(callable);
        DomainSocket conn = DomainSocket.connect((String)serv.getPath());
        Thread.sleep(50L);
        conn.close();
        serv.close();
        future.get(2L, TimeUnit.MINUTES);
    }

    @Test(timeout=180000L)
    public void testSocketAcceptAndClose() throws Exception {
        String TEST_PATH = new File(sockDir.getDir(), "test_sock_accept_and_close").getAbsolutePath();
        final DomainSocket serv = DomainSocket.bindAndListen((String)TEST_PATH);
        ExecutorService exeServ = Executors.newSingleThreadExecutor();
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    serv.accept();
                    throw new RuntimeException("expected the accept() to be interrupted and fail");
                }
                catch (AsynchronousCloseException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException("unexpected IOException", e);
                }
            }
        };
        Future<Void> future = exeServ.submit(callable);
        Thread.sleep(500L);
        serv.close();
        future.get(2L, TimeUnit.MINUTES);
    }

    private void testAsyncCloseDuringIO(final boolean closeDuringWrite) throws Exception {
        String TEST_PATH = new File(sockDir.getDir(), "testAsyncCloseDuringIO(" + closeDuringWrite + ")").getAbsolutePath();
        final DomainSocket serv = DomainSocket.bindAndListen((String)TEST_PATH);
        ExecutorService exeServ = Executors.newFixedThreadPool(2);
        Callable<Void> serverCallable = new Callable<Void>(){

            @Override
            public Void call() {
                DomainSocket serverConn;
                block10: {
                    serverConn = null;
                    try {
                        serverConn = serv.accept();
                        byte[] buf = new byte[100];
                        for (int i = 0; i < buf.length; ++i) {
                            buf[i] = 0;
                        }
                        if (closeDuringWrite) {
                            try {
                                while (true) {
                                    serverConn.getOutputStream().write(buf);
                                }
                            }
                            catch (IOException iOException) {
                                break block10;
                            }
                        }
                        while (serverConn.getInputStream().read(buf, 0, buf.length) != -1) {
                        }
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException("unexpected IOException", e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.cleanupWithLogger((Logger)DomainSocket.LOG, (Closeable[])new Closeable[]{serverConn});
                            throw throwable;
                        }
                    }
                }
                IOUtils.cleanupWithLogger((Logger)DomainSocket.LOG, (Closeable[])new Closeable[]{serverConn});
                return null;
            }
        };
        Future<Void> serverFuture = exeServ.submit(serverCallable);
        final DomainSocket clientConn = DomainSocket.connect((String)serv.getPath());
        Callable<Void> clientCallable = new Callable<Void>(){

            @Override
            public Void call() {
                byte[] buf = new byte[100];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = 0;
                }
                try {
                    if (closeDuringWrite) {
                        while (true) {
                            clientConn.getOutputStream().write(buf);
                        }
                    }
                    while (true) {
                        clientConn.getInputStream().read(buf, 0, buf.length);
                    }
                }
                catch (ClosedChannelException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException("unexpected IOException", e);
                }
            }
        };
        Future<Void> clientFuture = exeServ.submit(clientCallable);
        Thread.sleep(500L);
        clientConn.close();
        serv.close();
        clientFuture.get(2L, TimeUnit.MINUTES);
        serverFuture.get(2L, TimeUnit.MINUTES);
    }

    @Test(timeout=180000L)
    public void testAsyncCloseDuringWrite() throws Exception {
        this.testAsyncCloseDuringIO(true);
    }

    @Test(timeout=180000L)
    public void testAsyncCloseDuringRead() throws Exception {
        this.testAsyncCloseDuringIO(false);
    }

    @Test(timeout=180000L)
    public void testInvalidOperations() throws IOException {
        try {
            DomainSocket.connect((String)new File(sockDir.getDir(), "test_sock_invalid_operation").getAbsolutePath());
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("connect(2) error: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testServerOptions() throws Exception {
        String TEST_PATH = new File(sockDir.getDir(), "test_sock_server_options").getAbsolutePath();
        DomainSocket serv = DomainSocket.bindAndListen((String)TEST_PATH);
        try {
            int bufSize = serv.getAttribute(2);
            int newBufSize = bufSize / 2;
            serv.setAttribute(2, newBufSize);
            int nextBufSize = serv.getAttribute(2);
            Assert.assertEquals((long)newBufSize, (long)nextBufSize);
            int newTimeout = 1000;
            serv.setAttribute(4, newTimeout);
            int nextTimeout = serv.getAttribute(4);
            Assert.assertEquals((long)newTimeout, (long)nextTimeout);
            try {
                serv.accept();
                Assert.fail((String)"expected the accept() to time out and fail");
            }
            catch (SocketTimeoutException e) {
                GenericTestUtils.assertExceptionContains("accept(2) error: ", e);
            }
        }
        finally {
            serv.close();
            Assert.assertFalse((boolean)serv.isOpen());
        }
    }

    void testClientServer1(final Class<? extends WriteStrategy> writeStrategyClass, final Class<? extends ReadStrategy> readStrategyClass, final DomainSocket[] preConnectedSockets) throws Exception {
        final String TEST_PATH = new File(sockDir.getDir(), "test_sock_client_server1").getAbsolutePath();
        final byte[] clientMsg1 = new byte[]{1, 2, 3, 4, 5, 6};
        final byte[] serverMsg1 = new byte[]{9, 8, 7, 6, 5};
        int clientMsg2 = 69;
        final ArrayBlockingQueue threadResults = new ArrayBlockingQueue(2);
        final DomainSocket serv = preConnectedSockets != null ? null : DomainSocket.bindAndListen((String)TEST_PATH);
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                DomainSocket conn = null;
                try {
                    conn = preConnectedSockets != null ? preConnectedSockets[0] : serv.accept();
                    byte[] in1 = new byte[clientMsg1.length];
                    ReadStrategy reader = (ReadStrategy)readStrategyClass.newInstance();
                    reader.init(conn);
                    reader.readFully(in1, 0, in1.length);
                    Assert.assertTrue((boolean)Arrays.equals(clientMsg1, in1));
                    WriteStrategy writer = (WriteStrategy)writeStrategyClass.newInstance();
                    writer.init(conn);
                    writer.write(serverMsg1);
                    DomainSocket.DomainInputStream connInputStream = conn.getInputStream();
                    int in2 = connInputStream.read();
                    Assert.assertEquals((long)69L, (long)in2);
                    conn.close();
                }
                catch (Throwable e) {
                    threadResults.add(e);
                    Assert.fail((String)e.getMessage());
                }
                threadResults.add(new Success());
            }
        };
        serverThread.start();
        Thread clientThread = new Thread(){

            @Override
            public void run() {
                try {
                    DomainSocket client = preConnectedSockets != null ? preConnectedSockets[1] : DomainSocket.connect((String)TEST_PATH);
                    WriteStrategy writer = (WriteStrategy)writeStrategyClass.newInstance();
                    writer.init(client);
                    writer.write(clientMsg1);
                    ReadStrategy reader = (ReadStrategy)readStrategyClass.newInstance();
                    reader.init(client);
                    byte[] in1 = new byte[serverMsg1.length];
                    reader.readFully(in1, 0, in1.length);
                    Assert.assertTrue((boolean)Arrays.equals(serverMsg1, in1));
                    DomainSocket.DomainOutputStream clientOutputStream = client.getOutputStream();
                    clientOutputStream.write(69);
                    client.close();
                }
                catch (Throwable e) {
                    threadResults.add(e);
                }
                threadResults.add(new Success());
            }
        };
        clientThread.start();
        for (int i = 0; i < 2; ++i) {
            Throwable t = (Throwable)threadResults.take();
            if (t instanceof Success) continue;
            Assert.fail((String)(t.getMessage() + ExceptionUtils.getStackTrace((Throwable)t)));
        }
        serverThread.join(120000L);
        clientThread.join(120000L);
        if (serv != null) {
            serv.close();
        }
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInStream() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, InputStreamReadStrategy.class, null);
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInStreamWithSocketpair() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, InputStreamReadStrategy.class, DomainSocket.socketpair());
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInDbb() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, DirectByteBufferReadStrategy.class, null);
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInDbbWithSocketpair() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, DirectByteBufferReadStrategy.class, DomainSocket.socketpair());
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInAbb() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, ArrayBackedByteBufferReadStrategy.class, null);
    }

    @Test(timeout=180000L)
    public void testClientServerOutStreamInAbbWithSocketpair() throws Exception {
        this.testClientServer1(OutputStreamWriteStrategy.class, ArrayBackedByteBufferReadStrategy.class, DomainSocket.socketpair());
    }

    @Test(timeout=180000L)
    public void testFdPassing() throws Exception {
        final String TEST_PATH = new File(sockDir.getDir(), "test_sock").getAbsolutePath();
        final byte[] clientMsg1 = new byte[]{17, 34, 51, 68, 85, 102};
        final byte[] serverMsg1 = new byte[]{49, 48, 50, 52, 49, 51, 68, 1, 1, 1, 1, 1};
        final ArrayBlockingQueue threadResults = new ArrayBlockingQueue(2);
        final DomainSocket serv = DomainSocket.bindAndListen((String)TEST_PATH);
        final PassedFile[] passedFiles = new PassedFile[]{new PassedFile(1), new PassedFile(2)};
        final FileDescriptor[] passedFds = new FileDescriptor[passedFiles.length];
        for (int i = 0; i < passedFiles.length; ++i) {
            passedFds[i] = passedFiles[i].getInputStream().getFD();
        }
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                DomainSocket conn = null;
                try {
                    conn = serv.accept();
                    byte[] in1 = new byte[clientMsg1.length];
                    DomainSocket.DomainInputStream connInputStream = conn.getInputStream();
                    IOUtils.readFully((InputStream)connInputStream, (byte[])in1, (int)0, (int)in1.length);
                    Assert.assertTrue((boolean)Arrays.equals(clientMsg1, in1));
                    DomainSocket domainConn = conn;
                    domainConn.sendFileDescriptors(passedFds, serverMsg1, 0, serverMsg1.length);
                    conn.close();
                }
                catch (Throwable e) {
                    threadResults.add(e);
                    Assert.fail((String)e.getMessage());
                }
                threadResults.add(new Success());
            }
        };
        serverThread.start();
        Thread clientThread = new Thread(){

            @Override
            public void run() {
                try {
                    DomainSocket client = DomainSocket.connect((String)TEST_PATH);
                    DomainSocket.DomainOutputStream clientOutputStream = client.getOutputStream();
                    DomainSocket.DomainInputStream clientInputStream = client.getInputStream();
                    clientOutputStream.write(clientMsg1);
                    DomainSocket domainConn = client;
                    byte[] in1 = new byte[serverMsg1.length];
                    FileInputStream[] recvFis = new FileInputStream[passedFds.length];
                    int r = domainConn.recvFileInputStreams(recvFis, in1, 0, in1.length - 1);
                    Assert.assertTrue((r > 0 ? 1 : 0) != 0);
                    IOUtils.readFully((InputStream)clientInputStream, (byte[])in1, (int)r, (int)(in1.length - r));
                    Assert.assertTrue((boolean)Arrays.equals(serverMsg1, in1));
                    for (int i = 0; i < passedFds.length; ++i) {
                        Assert.assertNotNull((Object)recvFis[i]);
                        passedFiles[i].checkInputStream(recvFis[i]);
                    }
                    for (FileInputStream fis : recvFis) {
                        fis.close();
                    }
                    client.close();
                }
                catch (Throwable e) {
                    threadResults.add(e);
                }
                threadResults.add(new Success());
            }
        };
        clientThread.start();
        for (int i = 0; i < 2; ++i) {
            Throwable t = (Throwable)threadResults.take();
            if (t instanceof Success) continue;
            Assert.fail((String)(t.getMessage() + ExceptionUtils.getStackTrace((Throwable)t)));
        }
        serverThread.join(120000L);
        clientThread.join(120000L);
        serv.close();
        for (PassedFile pf : passedFiles) {
            pf.cleanup();
        }
    }

    private static void testValidateSocketPath(String str, String prefix) throws IOException {
        int skipComponents = 1;
        File prefixFile = new File(prefix);
        while ((prefixFile = prefixFile.getParentFile()) != null) {
            ++skipComponents;
        }
        DomainSocket.validateSocketPathSecurity0((String)str, (int)skipComponents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFdPassingPathSecurity() throws Exception {
        try (TemporarySocketDirectory tmp = new TemporarySocketDirectory();){
            String prefix = tmp.getDir().getAbsolutePath();
            Shell.execCommand((String[])new String[]{"mkdir", "-p", prefix + "/foo/bar/baz"});
            Shell.execCommand((String[])new String[]{"chmod", "0700", prefix + "/foo/bar/baz"});
            Shell.execCommand((String[])new String[]{"chmod", "0700", prefix + "/foo/bar"});
            Shell.execCommand((String[])new String[]{"chmod", "0707", prefix + "/foo"});
            Shell.execCommand((String[])new String[]{"mkdir", "-p", prefix + "/q1/q2"});
            Shell.execCommand((String[])new String[]{"chmod", "0700", prefix + "/q1"});
            Shell.execCommand((String[])new String[]{"chmod", "0700", prefix + "/q1/q2"});
            TestDomainSocket.testValidateSocketPath(prefix + "/q1/q2", prefix);
            try {
                TestDomainSocket.testValidateSocketPath(prefix + "/foo/bar/baz", prefix);
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains("world-writable", e);
                GenericTestUtils.assertExceptionContains("/foo'", e);
            }
            try {
                TestDomainSocket.testValidateSocketPath(prefix + "/nope", prefix);
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains("failed to stat a path component: ", e);
            }
            DomainSocket.validateSocketPathSecurity0((String)"/foo", (int)0);
        }
    }

    @Test(timeout=180000L)
    public void testShutdown() throws Exception {
        final AtomicInteger bytesRead = new AtomicInteger(0);
        final AtomicBoolean failed = new AtomicBoolean(false);
        final DomainSocket[] socks = DomainSocket.socketpair();
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int ret;
                        if ((ret = socks[1].getInputStream().read()) == -1) {
                            return;
                        }
                        bytesRead.addAndGet(1);
                    }
                }
                catch (IOException e) {
                    DomainSocket.LOG.error("reader error", (Throwable)e);
                    failed.set(true);
                    return;
                }
            }
        };
        Thread readerThread = new Thread(reader);
        readerThread.start();
        socks[0].getOutputStream().write(1);
        socks[0].getOutputStream().write(2);
        socks[0].getOutputStream().write(3);
        Assert.assertTrue((boolean)readerThread.isAlive());
        socks[0].shutdown();
        readerThread.join();
        Assert.assertFalse((boolean)failed.get());
        Assert.assertEquals((long)3L, (long)bytesRead.get());
        IOUtils.cleanupWithLogger(null, (Closeable[])socks);
    }

    private static class PassedFile {
        private final int idx;
        private final byte[] contents;
        private FileInputStream fis;

        public PassedFile(int idx) throws IOException {
            this.idx = idx;
            this.contents = new byte[]{(byte)(idx % 127)};
            Files.write((byte[])this.contents, (File)new File(this.getPath()));
            this.fis = new FileInputStream(this.getPath());
        }

        public String getPath() {
            return new File(sockDir.getDir(), "passed_file" + this.idx).getAbsolutePath();
        }

        public FileInputStream getInputStream() throws IOException {
            return this.fis;
        }

        public void cleanup() throws IOException {
            new File(this.getPath()).delete();
            this.fis.close();
        }

        public void checkInputStream(FileInputStream fis) throws IOException {
            byte[] buf = new byte[this.contents.length];
            IOUtils.readFully((InputStream)fis, (byte[])buf, (int)0, (int)buf.length);
            Arrays.equals(this.contents, buf);
        }

        protected void finalize() {
            try {
                this.cleanup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class ArrayBackedByteBufferReadStrategy
    extends ReadStrategy {
        private DomainSocket.DomainChannel ch = null;

        ArrayBackedByteBufferReadStrategy() {
        }

        @Override
        public void init(DomainSocket s) throws IOException {
            this.ch = s.getChannel();
        }

        @Override
        public int read(byte[] b, int off, int length) throws IOException {
            ByteBuffer buf = ByteBuffer.wrap(b);
            int nread = this.ch.read(buf);
            if (nread < 0) {
                return nread;
            }
            buf.flip();
            buf.get(b, off, nread);
            return nread;
        }
    }

    static class DirectByteBufferReadStrategy
    extends ReadStrategy {
        private DomainSocket.DomainChannel ch = null;

        DirectByteBufferReadStrategy() {
        }

        @Override
        public void init(DomainSocket s) throws IOException {
            this.ch = s.getChannel();
        }

        @Override
        public int read(byte[] b, int off, int length) throws IOException {
            ByteBuffer buf = ByteBuffer.allocateDirect(b.length);
            int nread = this.ch.read(buf);
            if (nread < 0) {
                return nread;
            }
            buf.flip();
            buf.get(b, off, nread);
            return nread;
        }
    }

    static class InputStreamReadStrategy
    extends ReadStrategy {
        private InputStream ins = null;

        InputStreamReadStrategy() {
        }

        @Override
        public void init(DomainSocket s) throws IOException {
            this.ins = s.getInputStream();
        }

        @Override
        public int read(byte[] b, int off, int length) throws IOException {
            return this.ins.read(b, off, length);
        }
    }

    static abstract class ReadStrategy {
        ReadStrategy() {
        }

        public abstract void init(DomainSocket var1) throws IOException;

        public abstract int read(byte[] var1, int var2, int var3) throws IOException;

        public void readFully(byte[] buf, int off, int len) throws IOException {
            int toRead = len;
            while (toRead > 0) {
                int ret = this.read(buf, off, toRead);
                if (ret < 0) {
                    throw new IOException("Premature EOF from inputStream");
                }
                toRead -= ret;
                off += ret;
            }
        }
    }

    static class OutputStreamWriteStrategy
    implements WriteStrategy {
        private OutputStream outs = null;

        OutputStreamWriteStrategy() {
        }

        @Override
        public void init(DomainSocket s) throws IOException {
            this.outs = s.getOutputStream();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outs.write(b);
        }
    }

    static interface WriteStrategy {
        public void init(DomainSocket var1) throws IOException;

        public void write(byte[] var1) throws IOException;
    }

    static class Success
    extends Throwable {
        private static final long serialVersionUID = 1L;

        Success() {
        }
    }
}

