/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import org.apache.pig.SortInfo;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;

public class SortInfoSetter
extends LogicalRelationalNodesVisitor {
    public SortInfoSetter(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    public void visit(LOStore store) throws FrontendException {
        Operator split;
        Object value;
        Operator root;
        LOSplitOutput splitOutput;
        LogicalExpressionPlan conditionPlan;
        Operator storePred = store.getPlan().getPredecessors(store).get(0);
        if (storePred == null) {
            int errCode = 2051;
            String msg = "Did not find a predecessor for Store.";
            throw new VisitorException((Operator)store, msg, errCode, 4);
        }
        SortInfo sortInfo = null;
        if (storePred instanceof LOLimit) {
            storePred = store.getPlan().getPredecessors(storePred).get(0);
        } else if (storePred instanceof LOSplitOutput && (conditionPlan = (splitOutput = (LOSplitOutput)storePred).getFilterPlan()).getSinks().size() == 1 && (root = conditionPlan.getSinks().get(0)) instanceof ConstantExpression && (value = ((ConstantExpression)root).getValue()) instanceof Boolean && ((Boolean)value).booleanValue() && (split = splitOutput.getPlan().getPredecessors(splitOutput).get(0)) instanceof LOSplit) {
            storePred = store.getPlan().getPredecessors(split).get(0);
        }
        if (storePred instanceof LOSort) {
            sortInfo = ((LOSort)storePred).getSortInfo();
        }
        store.setSortInfo(sortInfo);
    }
}

