/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class InternalLog4jUtils {
    private InternalLog4jUtils() {
    }

    static void setLogLevel(String loggerName, String levelName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        Level level = Level.toLevel((String)levelName.toUpperCase());
        if (!level.toString().equalsIgnoreCase(levelName)) {
            throw new IllegalArgumentException("Unsupported log level " + levelName);
        }
        logger.setLevel(level);
    }

    static String getEffectiveLevel(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        return logger.getEffectiveLevel().toString();
    }

    static Set<File> getActiveLogFiles() throws IOException {
        HashSet<File> ret = new HashSet<File>();
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender a = (Appender)e.nextElement();
            if (!(a instanceof FileAppender)) continue;
            FileAppender fa = (FileAppender)a;
            String filename = fa.getFile();
            ret.add(new File(filename));
        }
        return ret;
    }
}

