/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.Credentials;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;

@InterfaceAudience.Public
public class DataSinkDescriptor {
    private final OutputDescriptor outputDescriptor;
    private final OutputCommitterDescriptor committerDescriptor;
    private final Credentials credentials;
    private final Collection<URI> urisForCredentials = Sets.newHashSet();

    @Deprecated
    public DataSinkDescriptor(OutputDescriptor outputDescriptor, @Nullable OutputCommitterDescriptor committerDescriptor, @Nullable Credentials credentials) {
        this.outputDescriptor = outputDescriptor;
        this.committerDescriptor = committerDescriptor;
        this.credentials = credentials;
    }

    public static DataSinkDescriptor create(OutputDescriptor outputDescriptor, @Nullable OutputCommitterDescriptor committerDescriptor, @Nullable Credentials credentials) {
        return new DataSinkDescriptor(outputDescriptor, committerDescriptor, credentials);
    }

    public OutputDescriptor getOutputDescriptor() {
        return this.outputDescriptor;
    }

    @Nullable
    public OutputCommitterDescriptor getOutputCommitterDescriptor() {
        return this.committerDescriptor;
    }

    public synchronized DataSinkDescriptor addURIsForCredentials(Collection<URI> uris) {
        Objects.requireNonNull(uris, "URIs cannot be null");
        this.urisForCredentials.addAll(uris);
        return this;
    }

    public Collection<URI> getURIsForCredentials() {
        return Collections.unmodifiableCollection(this.urisForCredentials);
    }

    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }
}

