/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class SparkMapJoinProcessor
extends MapJoinProcessor {
    @Override
    public MapJoinOperator convertMapJoin(HiveConf conf, JoinOperator op, boolean leftSrc, String[] baseSrc, List<String> mapAliases, int bigTablePos, boolean noCheckOuterJoin, boolean validateMapJoinTree) throws SemanticException {
        JoinCondDesc[] condns = ((JoinDesc)op.getConf()).getConds();
        if (!noCheckOuterJoin && SparkMapJoinProcessor.checkMapJoin(bigTablePos, condns) < 0) {
            throw new SemanticException(ErrorMsg.NO_OUTER_MAPJOIN.getMsg());
        }
        MapJoinOperator mapJoinOp = SparkMapJoinProcessor.convertJoinOpMapJoinOp(conf, op, ((JoinDesc)op.getConf()).isLeftInputJoin(), ((JoinDesc)op.getConf()).getBaseSrc(), ((JoinDesc)op.getConf()).getMapAliases(), bigTablePos, noCheckOuterJoin);
        List<Operator<OperatorDesc>> parentOps = mapJoinOp.getParentOperators();
        for (int i = 0; i < parentOps.size(); ++i) {
            Operator<OperatorDesc> parentOp = parentOps.get(i);
            parentOp.getChildOperators().remove(op);
            if (i != bigTablePos) continue;
            List<Operator<OperatorDesc>> grandParentOps = parentOp.getParentOperators();
            Preconditions.checkArgument((grandParentOps.size() == 1 ? 1 : 0) != 0, (Object)("AssertionError: expect number of parents to be 1, but was " + grandParentOps.size()));
            Operator<OperatorDesc> grandParentOp = grandParentOps.get(0);
            grandParentOp.replaceChild(parentOp, mapJoinOp);
            mapJoinOp.replaceParent(parentOp, grandParentOp);
        }
        return mapJoinOp;
    }
}

