/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import javax.management.ObjectName;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.tserver.metrics.TabletServerUpdateMetricsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerUpdateMetrics
extends AbstractMetricsImpl
implements TabletServerUpdateMetricsMBean {
    static final Logger log = LoggerFactory.getLogger(TabletServerUpdateMetrics.class);
    private static final String METRICS_PREFIX = "tserver.update";
    private ObjectName OBJECT_NAME = null;

    TabletServerUpdateMetrics() {
        this.reset();
        try {
            this.OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerUpdateMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    protected ObjectName getObjectName() {
        return this.OBJECT_NAME;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }

    @Override
    public long getPermissionErrorCount() {
        return this.getMetricCount("permissionErrors");
    }

    @Override
    public long getUnknownTabletErrorCount() {
        return this.getMetricCount("unknownTabletErrors");
    }

    @Override
    public long getMutationArrayAvgSize() {
        return this.getMetricAvg("mutationArraysSize");
    }

    @Override
    public long getMutationArrayMinSize() {
        return this.getMetricMin("mutationArraysSize");
    }

    @Override
    public long getMutationArrayMaxSize() {
        return this.getMetricMax("mutationArraysSize");
    }

    @Override
    public long getCommitPrepCount() {
        return this.getMetricCount("commitPrep");
    }

    @Override
    public long getCommitPrepMinTime() {
        return this.getMetricMin("commitPrep");
    }

    @Override
    public long getCommitPrepMaxTime() {
        return this.getMetricMax("commitPrep");
    }

    @Override
    public long getCommitPrepAvgTime() {
        return this.getMetricAvg("commitPrep");
    }

    @Override
    public long getConstraintViolationCount() {
        return this.getMetricCount("constraintViolations");
    }

    @Override
    public long getWALogWriteCount() {
        return this.getMetricCount("waLogWriteTime");
    }

    @Override
    public long getWALogWriteMinTime() {
        return this.getMetricMin("waLogWriteTime");
    }

    @Override
    public long getWALogWriteMaxTime() {
        return this.getMetricMax("waLogWriteTime");
    }

    @Override
    public long getWALogWriteAvgTime() {
        return this.getMetricAvg("waLogWriteTime");
    }

    @Override
    public long getCommitCount() {
        return this.getMetricCount("commitTime");
    }

    @Override
    public long getCommitMinTime() {
        return this.getMetricMin("commitTime");
    }

    @Override
    public long getCommitMaxTime() {
        return this.getMetricMax("commitTime");
    }

    @Override
    public long getCommitAvgTime() {
        return this.getMetricAvg("commitTime");
    }

    @Override
    public void reset() {
        this.createMetric("permissionErrors");
        this.createMetric("unknownTabletErrors");
        this.createMetric("mutationArraysSize");
        this.createMetric("commitPrep");
        this.createMetric("constraintViolations");
        this.createMetric("waLogWriteTime");
        this.createMetric("commitTime");
    }
}

