/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.TestCacheConfig;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestBlockCacheReporting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockCacheReporting.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockCacheReporting.class);
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
    }

    private void addDataAndHits(BlockCache bc, int count) {
        TestCacheConfig.DataCacheEntry dce = new TestCacheConfig.DataCacheEntry();
        TestCacheConfig.IndexCacheEntry ice = new TestCacheConfig.IndexCacheEntry();
        for (int i = 0; i < count; ++i) {
            BlockCacheKey bckd = new BlockCacheKey("f", (long)i);
            BlockCacheKey bcki = new BlockCacheKey("f", (long)(i + count));
            bc.getBlock(bckd, true, false, true);
            bc.cacheBlock(bckd, (Cacheable)dce);
            bc.cacheBlock(bcki, (Cacheable)ice);
            bc.getBlock(bckd, true, false, true);
            bc.getBlock(bcki, true, false, true);
        }
        Assert.assertEquals((long)(2 * count), (long)bc.getStats().getHitCount());
        BlockCacheKey bckd = new BlockCacheKey("f", 0L);
        BlockCacheKey bcki = new BlockCacheKey("f", (long)(0 + count));
        bc.evictBlock(bckd);
        bc.evictBlock(bcki);
        bc.getStats().getEvictedCount();
    }

    @Test
    public void testBucketCache() throws IOException {
        this.conf.set("hbase.bucketcache.ioengine", "offheap");
        this.conf.setInt("hbase.bucketcache.size", 100);
        BlockCache blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        Assert.assertTrue((boolean)(blockCache instanceof CombinedBlockCache));
        this.logPerBlock(blockCache);
        int count = 3;
        this.addDataAndHits(blockCache, 3);
        LOG.info(Objects.toString(blockCache.getStats()));
        BlockCacheUtil.CachedBlocksByFile cbsbf = this.logPerBlock(blockCache);
        LOG.info(Objects.toString(cbsbf));
        this.logPerFile(cbsbf);
        this.bucketCacheReport(blockCache);
        LOG.info(BlockCacheUtil.toJSON((BlockCacheUtil.CachedBlocksByFile)cbsbf));
    }

    @Test
    public void testLruBlockCache() throws IOException {
        CacheConfig cc = new CacheConfig(this.conf);
        Assert.assertTrue((false == cc.isInMemory() ? 1 : 0) != 0);
        BlockCache blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        this.logPerBlock(blockCache);
        this.addDataAndHits(blockCache, 3);
        LOG.info("count=" + blockCache.getBlockCount() + ", currentSize=" + blockCache.getCurrentSize() + ", freeSize=" + blockCache.getFreeSize());
        LOG.info(Objects.toString(blockCache.getStats()));
        BlockCacheUtil.CachedBlocksByFile cbsbf = this.logPerBlock(blockCache);
        LOG.info(Objects.toString(cbsbf));
        this.logPerFile(cbsbf);
        this.bucketCacheReport(blockCache);
        LOG.info(BlockCacheUtil.toJSON((BlockCacheUtil.CachedBlocksByFile)cbsbf));
    }

    private void bucketCacheReport(BlockCache bc) {
        LOG.info(bc.getClass().getSimpleName() + ": " + bc.getStats());
        BlockCache[] bcs = bc.getBlockCaches();
        if (bcs != null) {
            for (BlockCache sbc : bc.getBlockCaches()) {
                LOG.info(bc.getClass().getSimpleName() + ": " + sbc.getStats());
            }
        }
    }

    private void logPerFile(BlockCacheUtil.CachedBlocksByFile cbsbf) throws IOException {
        for (Map.Entry e : cbsbf.getCachedBlockStatsByFile().entrySet()) {
            int count = 0;
            long size = 0L;
            int countData = 0;
            long sizeData = 0L;
            for (CachedBlock cb : (NavigableSet)e.getValue()) {
                ++count;
                size += cb.getSize();
                BlockType bt = cb.getBlockType();
                if (bt == null || !bt.isData()) continue;
                ++countData;
                sizeData += cb.getSize();
            }
            LOG.info("filename=" + (String)e.getKey() + ", count=" + count + ", countData=" + countData + ", size=" + size + ", sizeData=" + sizeData);
        }
    }

    private BlockCacheUtil.CachedBlocksByFile logPerBlock(BlockCache bc) throws IOException {
        BlockCacheUtil.CachedBlocksByFile cbsbf = new BlockCacheUtil.CachedBlocksByFile();
        for (CachedBlock cb : bc) {
            LOG.info(cb.toString());
            cbsbf.update(cb);
        }
        return cbsbf;
    }
}

