/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionStateStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionStateStore.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testVisitMetaForRegionExistingRegion() throws Exception {
        TableName tableName = this.name.getTableName();
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForBadRegionState() throws Exception {
        TableName tableName = this.name.getTableName();
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        Put put = new Put(regions.get(0).getRegionInfo().getRegionName(), EnvironmentEdgeManager.currentTime());
        put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)"BAD_STATE"));
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                Assert.assertNull((Object)state);
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForRegionNonExistingRegion() throws Exception {
        String encodedName = "fakeencodedregionname";
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion("fakeencodedregionname", new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                visitorCalled.set(true);
            }
        });
        Assert.assertFalse((String)"Visitor has been called, but it shouldn't.", (boolean)visitorCalled.get());
    }

    @Test
    public void testMetaLocationForRegionReplicasIsRemovedAtTableDeletion() throws IOException {
        long regionId = System.currentTimeMillis();
        TableName tableName = this.name.getTableName();
        RegionInfo primary = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).setSplit(false).setRegionId(regionId).setReplicaId(0).build();
        try (Table meta = MetaTableAccessor.getMetaHTable((Connection)UTIL.getConnection());){
            ArrayList regionInfos = Lists.newArrayList((Object[])new RegionInfo[]{primary});
            MetaTableAccessor.addRegionsToMeta((Connection)UTIL.getConnection(), (List)regionInfos, (int)3);
            RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
            regionStateStore.removeRegionReplicas(tableName, 3, 1);
            Get get = new Get(primary.getRegionName());
            Result result = meta.get(get);
            for (int replicaId = 0; replicaId < 3; ++replicaId) {
                Cell serverCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)replicaId));
                Cell startCodeCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)replicaId));
                Cell stateCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getRegionStateColumn((int)replicaId));
                Cell snCell = result.getColumnLatestCell(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerNameColumn((int)replicaId));
                if (replicaId == 0) {
                    Assert.assertNotNull((Object)stateCell);
                    continue;
                }
                Assert.assertNull((Object)serverCell);
                Assert.assertNull((Object)startCodeCell);
                Assert.assertNull((Object)stateCell);
                Assert.assertNull((Object)snCell);
            }
        }
    }
}

