/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.File;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.snapshot.TestSnapshotFileCache;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestSnapshotFileCacheWithDifferentWorkingDir
extends TestSnapshotFileCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFileCacheWithDifferentWorkingDir.class);
    protected static String TEMP_DIR = Paths.get(".", UUID.randomUUID().toString()).toAbsolutePath().toString();

    @BeforeClass
    public static void startCluster() throws Exception {
        TestSnapshotFileCacheWithDifferentWorkingDir.initCommon();
        conf.set("hbase.snapshot.working.dir", "file://" + new Path(TEMP_DIR, ".tmpDir").toUri());
        workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((Path)rootDir, (Configuration)conf);
        workingFs = workingDir.getFileSystem(conf);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
        FileUtils.deleteDirectory((File)new File(TEMP_DIR));
    }
}

