/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class AppCollectorData {
    protected static final long DEFAULT_TIMESTAMP_VALUE = -1L;

    public static AppCollectorData newInstance(ApplicationId id, String collectorAddr, long rmIdentifier, long version, Token token) {
        AppCollectorData appCollectorData = (AppCollectorData)Records.newRecord(AppCollectorData.class);
        appCollectorData.setApplicationId(id);
        appCollectorData.setCollectorAddr(collectorAddr);
        appCollectorData.setRMIdentifier(rmIdentifier);
        appCollectorData.setVersion(version);
        appCollectorData.setCollectorToken(token);
        return appCollectorData;
    }

    public static AppCollectorData newInstance(ApplicationId id, String collectorAddr, long rmIdentifier, long version) {
        return AppCollectorData.newInstance(id, collectorAddr, rmIdentifier, version, null);
    }

    public static AppCollectorData newInstance(ApplicationId id, String collectorAddr, Token token) {
        return AppCollectorData.newInstance(id, collectorAddr, -1L, -1L, token);
    }

    public static AppCollectorData newInstance(ApplicationId id, String collectorAddr) {
        return AppCollectorData.newInstance(id, collectorAddr, null);
    }

    public static boolean happensBefore(AppCollectorData dataA, AppCollectorData dataB) {
        if (dataA == null && dataB == null) {
            return false;
        }
        if (dataA == null || dataB == null) {
            return dataA == null;
        }
        return dataA.getRMIdentifier() < dataB.getRMIdentifier() || dataA.getRMIdentifier() == dataB.getRMIdentifier() && dataA.getVersion() < dataB.getVersion();
    }

    public boolean isStamped() {
        return this.getRMIdentifier() != -1L || this.getVersion() != -1L;
    }

    public abstract ApplicationId getApplicationId();

    public abstract void setApplicationId(ApplicationId var1);

    public abstract String getCollectorAddr();

    public abstract void setCollectorAddr(String var1);

    public abstract long getRMIdentifier();

    public abstract void setRMIdentifier(long var1);

    public abstract long getVersion();

    public abstract void setVersion(long var1);

    public abstract Token getCollectorToken();

    public abstract void setCollectorToken(Token var1);
}

