/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;

public abstract class TimelineDelgationTokenSecretManagerService
extends AbstractService {
    private static long delegationTokenRemovalScanInterval = 3600000L;
    private AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> secretManager = null;

    public TimelineDelgationTokenSecretManagerService(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long secretKeyInterval = conf.getLong("yarn.timeline-service.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.timeline-service.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.timeline-service.delegation.token.renew-interval", 86400000L);
        this.secretManager = this.createTimelineDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, delegationTokenRemovalScanInterval);
        super.init(conf);
    }

    protected abstract AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> createTimelineDelegationTokenSecretManager(long var1, long var3, long var5, long var7);

    protected void serviceStart() throws Exception {
        this.secretManager.startThreads();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.secretManager.stopThreads();
        super.stop();
    }

    public AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> getTimelineDelegationTokenSecretManager() {
        return this.secretManager;
    }
}

