/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NumericRange is the corresponding interface of NumericRange
type NumericRange interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsNumericRange is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNumericRange()
	// CreateBuilder creates a NumericRangeBuilder
	CreateNumericRangeBuilder() NumericRangeBuilder
}

// _NumericRange is the data-structure of this message
type _NumericRange struct {
}

var _ NumericRange = (*_NumericRange)(nil)

// NewNumericRange factory function for _NumericRange
func NewNumericRange() *_NumericRange {
	return &_NumericRange{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NumericRangeBuilder is a builder for NumericRange
type NumericRangeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() NumericRangeBuilder
	// Build builds the NumericRange or returns an error if something is wrong
	Build() (NumericRange, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NumericRange
}

// NewNumericRangeBuilder() creates a NumericRangeBuilder
func NewNumericRangeBuilder() NumericRangeBuilder {
	return &_NumericRangeBuilder{_NumericRange: new(_NumericRange)}
}

type _NumericRangeBuilder struct {
	*_NumericRange

	collectedErr []error
}

var _ (NumericRangeBuilder) = (*_NumericRangeBuilder)(nil)

func (b *_NumericRangeBuilder) WithMandatoryFields() NumericRangeBuilder {
	return b
}

func (b *_NumericRangeBuilder) Build() (NumericRange, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NumericRange.deepCopy(), nil
}

func (b *_NumericRangeBuilder) MustBuild() NumericRange {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NumericRangeBuilder) DeepCopy() any {
	_copy := b.CreateNumericRangeBuilder().(*_NumericRangeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNumericRangeBuilder creates a NumericRangeBuilder
func (b *_NumericRange) CreateNumericRangeBuilder() NumericRangeBuilder {
	if b == nil {
		return NewNumericRangeBuilder()
	}
	return &_NumericRangeBuilder{_NumericRange: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNumericRange(structType any) NumericRange {
	if casted, ok := structType.(NumericRange); ok {
		return casted
	}
	if casted, ok := structType.(*NumericRange); ok {
		return *casted
	}
	return nil
}

func (m *_NumericRange) GetTypeName() string {
	return "NumericRange"
}

func (m *_NumericRange) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_NumericRange) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NumericRangeParse(ctx context.Context, theBytes []byte) (NumericRange, error) {
	return NumericRangeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func NumericRangeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (NumericRange, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (NumericRange, error) {
		return NumericRangeParseWithBuffer(ctx, readBuffer)
	}
}

func NumericRangeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (NumericRange, error) {
	v, err := (&_NumericRange{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_NumericRange) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__numericRange NumericRange, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NumericRange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NumericRange")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("NumericRange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NumericRange")
	}

	return m, nil
}

func (m *_NumericRange) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NumericRange) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("NumericRange"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for NumericRange")
	}

	if popErr := writeBuffer.PopContext("NumericRange"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for NumericRange")
	}
	return nil
}

func (m *_NumericRange) IsNumericRange() {}

func (m *_NumericRange) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NumericRange) deepCopy() *_NumericRange {
	if m == nil {
		return nil
	}
	_NumericRangeCopy := &_NumericRange{}
	return _NumericRangeCopy
}

func (m *_NumericRange) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
