/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableH is an enum
type OpcuaNodeIdServicesVariableH int32

type IOpcuaNodeIdServicesVariableH interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad    OpcuaNodeIdServicesVariableH = 11204
	OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataBad         OpcuaNodeIdServicesVariableH = 11205
	OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataGood        OpcuaNodeIdServicesVariableH = 11206
	OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation OpcuaNodeIdServicesVariableH = 11207
	OpcuaNodeIdServicesVariableH_HAConfiguration_Stepped                                       OpcuaNodeIdServicesVariableH = 11208
	OpcuaNodeIdServicesVariableH_HAConfiguration_Definition                                    OpcuaNodeIdServicesVariableH = 11209
	OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeInterval                               OpcuaNodeIdServicesVariableH = 11210
	OpcuaNodeIdServicesVariableH_HAConfiguration_MinTimeInterval                               OpcuaNodeIdServicesVariableH = 11211
	OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviation                            OpcuaNodeIdServicesVariableH = 11212
	OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviationFormat                      OpcuaNodeIdServicesVariableH = 11213
	OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfArchive                                OpcuaNodeIdServicesVariableH = 11503
	OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfOnlineArchive                          OpcuaNodeIdServicesVariableH = 11504
	OpcuaNodeIdServicesVariableH_HAConfiguration_ServerTimestampSupported                      OpcuaNodeIdServicesVariableH = 19093
	OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeStoredValues                           OpcuaNodeIdServicesVariableH = 32635
	OpcuaNodeIdServicesVariableH_HAConfiguration_MaxCountStoredValues                          OpcuaNodeIdServicesVariableH = 32636
)

var OpcuaNodeIdServicesVariableHValues []OpcuaNodeIdServicesVariableH

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableHValues = []OpcuaNodeIdServicesVariableH{
		OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad,
		OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataBad,
		OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataGood,
		OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation,
		OpcuaNodeIdServicesVariableH_HAConfiguration_Stepped,
		OpcuaNodeIdServicesVariableH_HAConfiguration_Definition,
		OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeInterval,
		OpcuaNodeIdServicesVariableH_HAConfiguration_MinTimeInterval,
		OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviation,
		OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviationFormat,
		OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfArchive,
		OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfOnlineArchive,
		OpcuaNodeIdServicesVariableH_HAConfiguration_ServerTimestampSupported,
		OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeStoredValues,
		OpcuaNodeIdServicesVariableH_HAConfiguration_MaxCountStoredValues,
	}
}

func OpcuaNodeIdServicesVariableHByValue(value int32) (enum OpcuaNodeIdServicesVariableH, ok bool) {
	switch value {
	case 11204:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad, true
	case 11205:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataBad, true
	case 11206:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataGood, true
	case 11207:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation, true
	case 11208:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_Stepped, true
	case 11209:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_Definition, true
	case 11210:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeInterval, true
	case 11211:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MinTimeInterval, true
	case 11212:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviation, true
	case 11213:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviationFormat, true
	case 11503:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfArchive, true
	case 11504:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfOnlineArchive, true
	case 19093:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ServerTimestampSupported, true
	case 32635:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeStoredValues, true
	case 32636:
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxCountStoredValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHByName(value string) (enum OpcuaNodeIdServicesVariableH, ok bool) {
	switch value {
	case "HAConfiguration_AggregateConfiguration_TreatUncertainAsBad":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad, true
	case "HAConfiguration_AggregateConfiguration_PercentDataBad":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataBad, true
	case "HAConfiguration_AggregateConfiguration_PercentDataGood":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataGood, true
	case "HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation, true
	case "HAConfiguration_Stepped":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_Stepped, true
	case "HAConfiguration_Definition":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_Definition, true
	case "HAConfiguration_MaxTimeInterval":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeInterval, true
	case "HAConfiguration_MinTimeInterval":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MinTimeInterval, true
	case "HAConfiguration_ExceptionDeviation":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviation, true
	case "HAConfiguration_ExceptionDeviationFormat":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviationFormat, true
	case "HAConfiguration_StartOfArchive":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfArchive, true
	case "HAConfiguration_StartOfOnlineArchive":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfOnlineArchive, true
	case "HAConfiguration_ServerTimestampSupported":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_ServerTimestampSupported, true
	case "HAConfiguration_MaxTimeStoredValues":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeStoredValues, true
	case "HAConfiguration_MaxCountStoredValues":
		return OpcuaNodeIdServicesVariableH_HAConfiguration_MaxCountStoredValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableHKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableHValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableH(structType any) OpcuaNodeIdServicesVariableH {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableH {
		if sOpcuaNodeIdServicesVariableH, ok := typ.(OpcuaNodeIdServicesVariableH); ok {
			return sOpcuaNodeIdServicesVariableH
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableH) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableH) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableHParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableH, error) {
	return OpcuaNodeIdServicesVariableHParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableHParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableH, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableH", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableH")
	}
	if enum, ok := OpcuaNodeIdServicesVariableHByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableH")
		return OpcuaNodeIdServicesVariableH(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableH) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableH) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableH", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableH) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableH) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_TreatUncertainAsBad:
		return "HAConfiguration_AggregateConfiguration_TreatUncertainAsBad"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataBad:
		return "HAConfiguration_AggregateConfiguration_PercentDataBad"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_PercentDataGood:
		return "HAConfiguration_AggregateConfiguration_PercentDataGood"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation:
		return "HAConfiguration_AggregateConfiguration_UseSlopedExtrapolation"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_Stepped:
		return "HAConfiguration_Stepped"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_Definition:
		return "HAConfiguration_Definition"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeInterval:
		return "HAConfiguration_MaxTimeInterval"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_MinTimeInterval:
		return "HAConfiguration_MinTimeInterval"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviation:
		return "HAConfiguration_ExceptionDeviation"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_ExceptionDeviationFormat:
		return "HAConfiguration_ExceptionDeviationFormat"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfArchive:
		return "HAConfiguration_StartOfArchive"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_StartOfOnlineArchive:
		return "HAConfiguration_StartOfOnlineArchive"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_ServerTimestampSupported:
		return "HAConfiguration_ServerTimestampSupported"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_MaxTimeStoredValues:
		return "HAConfiguration_MaxTimeStoredValues"
	case OpcuaNodeIdServicesVariableH_HAConfiguration_MaxCountStoredValues:
		return "HAConfiguration_MaxCountStoredValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableH) String() string {
	return e.PLC4XEnumName()
}
